+++
author = ["authors/arturo-fernandez.md"]
categories = "Review"
date = "2018-03-24T20:31:00-04:00"
lastmod = "2018-03-24T20:59:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1521937792283/sq---BLO2018_3PO2.jpg.jpg"
primary_image_credit = "Kelly Kaduce as Polly Peachum sings the iconic “Pirate Jenny” in the Boston Lyric Opera’s production of Weill and Brecht’s THE THREEPENNY OPERA, running March 16-25 at the Huntington Avenue Theatre. BLO.org. Photo: Liza Voll Photography."
publishDate = "2018-03-24T20:31:00-04:00"
related_articles = ["articles/in-review-the-threepenny-opera-.md","articles/vergesst-uns-nicht-adi-braun-on-weimar-cabaret.md","articles/schoenberg-in-hollywood-a-heap-of-excess.md"]
related_companies = ["scene/companies/boston-lyric-opera.md"]
related_people = ["scene/people/kelly-kaduce.md","scene/people/daniel-belcher.md"]
short_description = "And then Kelly Kaduce came onstage: when her Polly Peachum walked on in an unglamorous wedding dress and unkempt black hair playing a sarcastic, monotone version of the typical operatic ingenue her character is written as, it became clear exactly what the work was setting out to do."
slug = "blos-threepenny-opera-a-misanthropic-delight"
title = "BLO&#039;s Threepenny Opera: a misanthropic delight"
+++

The world of Kurt Weill's *The Threepenny Opera* is a world not easily broken into by most audiences: even aside from the hyper-theatrical tappings in Bertold Brecht's libretto, it's a cold, unfeeling world filled with characters who are all so universally selfish and greedy that the only way for any ending to be considered just is - as one character observes - for all of the characters to hang, not just Macheath, the man around whom the entire work revolves. This poses a challenge for any company that decides to stage the work: how does one handle what is, essentially, a satirical morality tale?

Stage director James Darrah's solution, which played out on the stage of the Huntington Avenue Theater to a sold-out audience at the Boston Lyric Opera, was to lean hard into the work's inherent misanthropy. The result did take a little time to grow on the audience: for the first ten minutes, the action kind of stalled through the introductory exposition delivered by actors whose intent was not quite clear. And then [Kelly Kaduce](scene/people/kelly-kaduce/) came onstage: when her Polly Peachum walked on in an unglamorous wedding dress and unkempt black hair playing a sarcastic, monotone version of the typical operatic ingenue her character is written as, it became clear exactly what the work was setting out to do. From there, the ensuing stage action was full of pettiness, selfishness, and allegiances that changed at the drop of a dollar bill, and it was an absolute delight to watch.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1521937527311/BLO2018_3PO9.jpg.jpg)
<figcaption>Christopher Burchett as Macheath (top) and the cast of Boston Lyric Opera's production of Weill and Brecht's *The Threepenny Opera*, running March 16-25 at the Huntington Avenue Theatre. BLO.org. Photo: Liza Voll Photography.</figcaption>
</figure>

Part of the production's success is that Darrah leans into the work's hyper-theatrical tappings to deliver a visually striking production. Both set designer Julia Noulin-Mérat and lighting designer Pablo Santiago make heavily predominant use of the square in the production, both in the squares that made up the walls of the set in which the entire action played out to the squares created by the various lighting cues that denoted location throughout the entire production. The use of brown in the set also helped highlight how almost out of place Charles Neumann's costumes looked: the 19th-century garb would seem out of place given how sparse the rest of the production was, but considering the quirky nature of the show the gaudiness of such costuming fit right in with the production.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1521937547022/BLO2018_3PO4.jpg.jpg)
<figcaption>Jenny (Renee Tatum, in blue) reads the palm of Macheath (Christopher Burchett, center, top) in the Boston Lyric Opera's production of Weill and Brecht's *The Threepenny Opera*, running March 16-25 at the Huntington Avenue Theatre. BLO.org. Photo: Liza Voll Photography.</figcaption>
</figure>

However, a bigger part of this production's success is that Darrah gets incredible commitment out of his cast of opera singers, both in terms of singing and acting. Their singing was more than ready to take on the work's sound world: one can debate whether or not a more operatic vocal sound is appropriate for *Threepenny Opera*'s frequent dips into the world of the Weimar Cabaret, but the cast frequently broke from an operatic vocal style when required. They thus imbued an incredible sense of character into Weill's incredibly tuneful score, bringing out the subversive nature of the score with ease. Thankfully, unlike most times when spoken words are employed by opera singers, the singers also sustained this commitment through the spoken portions of the show, which resulted in a show that sustained interest through the entire run-time.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1521937556670/BLO2018_3PO3.jpg.jpg)
<figcaption>James Maddalena, Kelly Kaduce and Michelle Trainor are the unconventional Peachum Family in the Boston Lyric Opera's production of Weill and Brecht's *The Threepenny Opera*, running March 16-25 at the Huntington Avenue Theatre. BLO.org. Photo: Liza Voll Photography.</figcaption>
</figure>

Finding stand-outs in the cast was difficult, but it began with the aforementioned Kelly Kaduce, whose Polly Peachum was an absolute delight of performance intentionally clashing with the text. However, she also displayed an incredible chemistry with the entire rest of the cast: her playing Polly so sarcastically resulted in a good chunk of the laughs throughout the evening. Noteworthy as well was her co-star Christopher Burchett, whose Macheath had so much charisma that it was hard to look away any time he was onstage. It also benefited the show in other ways: the charisma he imbued Macheath with made it so that, even given the fact that he is kind of characterized as a scumbag, we felt a dramatic urgency to not want him to hang. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1521937566441/BLO2018_3PO8.jpg.jpg)
<figcaption>Daniel Belcher is Chief of Police Tiger Brown in the Boston Lyric Opera's production of Weill and Brecht's *The Threepenny Opera*, running March 16-25 at the Huntington Avenue Theatre. BLO.org. Photo: Liza Voll Photography.</figcaption>
</figure>

Other stand-outs in the cast included Daniel Belcher imbuing Tiger Brown with so much pathetic charm it was hard not to love him, Chelsea Basler absolutely stealing the show by coating Macheath's second love interest Lucy with so much sugar it almost highlighted how venomous of a character she is, and Michelle Trainor playing Polly Peachum's mother with a Brooklynite-esque bravado that delivered both a ton of laughs and one of the more memorable pre-show announcements about cell phones I have seen in the theater.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1521937584063/BLO2018_3PO7.jpg.jpg)
<figcaption>Michelle Trainor as Mrs. Peachum in the Boston Lyric Opera's production of Weill and Brecht's *The Threepenny Opera*, running March 16-25 at the Huntington Avenue Theatre. BLO.org. Photo: Liza Voll Photography.</figcaption>
</figure>

To be sure, the evening did not go perfectly. Among the biggest flaws was that the orchestra sometimes had difficulty staying out of the way of the male singers: this made some of the songs sung by men difficult to understand, particularly the opening *Ballad of Mack the Knife*. I also question the wisdom of ending this production on an inexact replica of the opening tableau: I am not so certain that setting up an expectation that it could all restart at any moment is smart given the show's deus ex machina of an ending.

However, in general, the evening was a delight of misanthropic characters cavorting about. In the wrong hands, this show can easily dip into unpleasant territory, but fortunately the Boston Lyric Opera found the right combination of people to keep the show funny and sharp. It almost begs a longer run at the Huntington Avenue Theater, but in the meantime it brings Weill's work to life in a very exciting way.

