+++
author = ["authors/arturo-fernandez.md"]
categories = "Review"
date = "2019-03-12T17:25:13+00:00"
disclaimer = ""
image_gallery = []
postamble = "Boston Lyric Opera's production of _The Rape of Lucretia_ runs through March 17. For details and tickets, [click here](https://blo.org/lucretia/)."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1552411853/media/2019/03/sqBLO2019Lucretia3138.jpg"
primary_image_credit = "Kelley O'Connor as Lucretia in Boston Lyric Opera's production of The Rape of Lucretia, 2019. Photo: Liza Voll."
related_articles = ["articles/rehearsing-trauma-how-working-on-an-opera-helped-me-heal.md"]
related_companies = ["scene/companies/boston-lyric-opera.md"]
related_people = ["scene/people/kelley-oconnor.md", "scene/people/brandon-cedel.md", "scene/people/duncan-rock.md"]
short_description = "This production of The Rape of Lucretia was presented as one of BLO's now-signature installation operas: in this case, much of the action was concentrated on a relatively small circle in the center of the Arts for Humanity Epicenter building."
slug = "blos-electrifying-rape-of-lucretia-a-revelation"
title = "BLO's electrifying Rape of Lucretia a revelation"
youtube_url = ""

+++
Whenever a production company gets mired up in producing Benjamin Britten's _The Rape of Lucretia_, a common pitfall of productions is to present the work as a series of tableaus that are static and don't move forward very much. Considering the work's framing device, it is not difficult to see why: the Male and Female Chorus that function as the tale's narrators lampshade their function in the story with enough frequency that most directors' first instinct would be to produce this opera in such a way.

> The audience was seated surrounding the circle on three sides, which in pretty much all situations would give the singers absolutely nowhere to hide.

However, this is a decided mistake. For the first part, at the end of the opera the Male Chorus eventually ends up sounding incredibly patronizing when he explains to the Female Chorus about the hope of Christ. It has the very strange effect of sounding preachy in a way that the work does very little to demand, and it is a proper weakness of the show. For the other part, however, playing it as a tableau really robs pretty much the rest of the story of the raw emotional power that it can have, and this was something that Boston Lyric Opera's staging addressed in a great many ways.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1552412440/media/2019/03/BLO2019Lucretia3050.jpg){{% /md %}}

<figcaption>Duncan Rock as Tarquinius (rear) and Brandon Cedel as Collatinus in Boston Lyric Opera's production of The Rape of Lucretia, 2019. Photo: Liza Voll.</figcaption>

</figure>

This production of _The Rape of Lucretia_ was presented as one of BLO's now-signature installation operas: in this case, much of the action was concentrated on a relatively small circle in the center of the Arts for Humanity Epicenter building. The audience was seated surrounding the circle on three sides, which in pretty much all situations would give the singers absolutely nowhere to hide. At first, one would probably question the wisdom of such an arrangement of the audience and the action, considering that the work almost does not demand such an approach.

However, the effect essentially heightened the drama already present in the work. Putting the people in the front rows closer to the action does come with its share of acoustical problems for sure, but it also gives an immediacy to the action that likely would have been lost in the traditional proscenium arrangement. It is also fortunate that the Arts for Humanity Epicenter has two levels to work with, as this allowed stage director Sarna Lapine to experiment with height in her staging. This was used to great effect, and her placement of the singers at various points in the show amplified the opera's theme of the use (and abuse) of power - something that is indispensable when staging a work like this in the #MeToo era.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1552412520/media/2019/03/BLO2019Lucretia3087.jpg){{% /md %}}

<figcaption>David McFerrin as Junius and Duncan Rock as Tarquinius in Boston Lyric Opera's production of The Rape of Lucretia, 2019. Photo: Liza Voll.</figcaption>

</figure>

But more than that, the vastness of the space (and the Arts for Humanity Epicenter is a _big_ space) gave extra importance to everything that happened on the center platform, and this was used to shocking effect. This is especially true of the climactic rape scene, which takes place almost entirely within the confines of that circular platform. The staging itself was really fast-paced and effective in telling the story that Britten tells with horrifying urgency in the music, but the real show-stopper was when the performers in the center platform were enshrouded in what felt like a singular beam of darkness when it came time to depict Tarquinius in the actual act of raping Lucretia. It was certainly nothing graphic, but suddenly enshrouding the place that everyone's attention was centered on had the effect of allowing the imagination to run wild, and the effect is chilling in the best way.

> The moment still comes as shocking and unexpected - which is not something that can be said about very many opera suicides.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1552412603/media/2019/03/BLO2019Lucretia3155.jpg){{% /md %}}

<figcaption>Kelley O'Connor as Lucretia and Margaret Lattimore as Bianca in Boston Lyric Opera's production of The Rape of Lucretia, 2019. Photo: Liza Voll.</figcaption>

</figure>

The directing is also filled with inspired touches that helped add dramatic urgency to the work, especially in the scenes after the rape. Lucretia's slow march to meet her husband Collatinus at the end took place mostly on a higher platform from the center circle, and the fact she deliberately walked such a distance with such deliberated sluggishness leant a finality and weight that only foreshadowed her decision.

The fact that Lucretia uses Tarquinius' blade in her suicide is also an inspired touch, but what also helps is the fact that it is staged in such a way that she draws it and stabs herself in a position where the audience's vantage point does not see it coming until literally two seconds before the act, such that the moment still comes as shocking and unexpected - which is not something that can be said about very many opera suicides. And then there is a singular hand gesture from the Female Chorus during the Male Chorus' tract about Christianity at the end of the show: I won't spoil exactly what she does, but suffice to say that this one singular gesture helps to throw the more problematic aspects of Britten's framing device into relief, even turning it into an asset.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1552412686/media/2019/03/BLO2019Lucretia3299.jpg){{% /md %}}

<figcaption>Duncan Rock as Tarquinius and Kelley O'Connor as Lucretia in Boston Lyric Opera's production of The Rape of Lucretia, 2019. Photo: Liza Voll.</figcaption>

</figure>

And then there are all the wonderful singers that put so much work into bringing this production to life. [Brandon Cedel](/scene/people/brandon-cedel/)'s Collatinus is loving in such a way that is different from his male costars: his warm, lyrical baritone also gave us a sense of his relationship with Lucretia even though the two are not on-stage together until the end of the work. Among the men, however, it was [Duncan Rock](/scene/people/duncan-rock/)'s Tarquinius that grounded the aspect of power: the brashness with which Mr. Rock played this character played off the rest of the action perfectly, and gave us real reason to fear for Lucretia. Among the rest of the cast, Jesse Darden and Antonia Tamer gave real characterizations to the Male and Female Chorus, a pair of roles that usually just exist in the opera: here, Darden smartly plays into the patronizing quality of the character, which Tamer responds to in kind.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1552412774/media/2019/03/BLO2019Lucretia3464.jpg){{% /md %}}

<figcaption>Brandon Cedel as Collatinus in Boston Lyric Opera's production of The Rape of Lucretia, 2019. Photo: Liza Voll.</figcaption>

</figure>

But of course, the real star of the night was [Kelley O'Connor](/scene/people/kelley-oconnor/) as Lucretia. For certain, Britten gives both her and Lapine plenty to work with given the way he plays with tessitura throughout the opera, but the direction and O'Connor herself add layers of nuance that breathe life into Lucretia in a role that runs the whole gamut of emotion.

> It is extremely rare that all of the forces of a particular production come together as well as they do here.

O'Connor put some real power into her refusal of Tarquinius' advances with a voice that was sharp and cutting, but she then pulled it back into an almost robotic tone when she came on-stage during what was a processing stage. The role of Lucretia is a difficult one to bring to life, and all the forces of the stagecraft and the vocal performance came together absolutely beautifully in portraying this character.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1552412937/media/2019/03/BLO2019Lucretia3197.jpg){{% /md %}}

<figcaption>Kelley O'Connor as Lucretia, Duncan Rock as Tarquinius, and Sarah Womble as Lucia Boston Lyric Opera's production of The Rape of Lucretia, 2019. Photo: Liza Voll.</figcaption>

</figure>

And in today's world where more awareness is brought to the realities of rape and sexual violence, this treatment of _The Rape of Lucretia_ is one for the ages. Aside from managing to tastefully tone down a lot of the more controversial elements of the framing device, Boston Lyric Opera have produced an absolute treasure of a production that is as intelligent and timely as it is dramatic and riveting. It is extremely rare that all of the forces of a particular production come together as well as they do here, or that indeed they manage to take the work's flaws and turn them into a strength, but that is exactly what has been achieved here. The result is absolutely breathtaking, and it is not to be missed.