+++
author = ["authors/arturo-fernandez.md"]
categories = "Review"
date = 2023-09-15T00:00:00Z
disclaimer = ""
image_gallery = []
postamble = "Boston Lyric Opera's [production of _Madama Butterfly_](https://blo.org/butterfly/) runs through September 24, 2023."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1694783131/SQBLO__2.jpg"
primary_image_credit = "Karen Chia-Ling Ho as Cio-Cio-San and Dominick Chenes as B.F. Pinkerton in Boston Lyric Opera's production of Madama Butterfly, 2023. Photo: Ken Yotsukura."
related_articles = ["articles/bluebeard-blo.md", "articles/la-boheme-reliable-as-ever-even-in-reverse.md"]
related_companies = ["scene/companies/boston-lyric-opera-1.md"]
related_people = ["/scene/people/karen-chia-ling-ho.md"]
short_description = "It is effectively trading one overdone opera death for another, but I think this decision to change who dies at the end of the story is still one of the most brilliant aspects of the production."
slug = "karen-chia-ling-hos-star-making-performance-in-BLOs-thoughtful-madama-butterfly"
title = "Karen Chia-Ling Ho's 'star-making' performance in BLO's thoughtful Madama Butterfly"
youtube_url = ""

+++
_Madama Butterfly_ is considered to have one of Puccini's more beloved scores, with one of his great showstopper arias and Puccini's own personal preference to its name. It also, however, has had a testy relationship with the Asian community, one that has been repeatedly unpacked by numerous people throughout the latter half of the 20th century, especially by people within the Asian-American community. [Boston Lyric Opera](/scene/companies/boston-lyric-opera/), perhaps noting the increase in anti-Asian hate in the wake of COVID-19, thus capped off three years of reflection on what is considered the more racially insensitive elements of _Madama Butterfly_ with a [production of their own](https://blo.org/butterfly/) that sought to address the more overtly racial issues present in the story.

The solution presented is to bring in an all-Asian directing and dramaturgical team behind the scenes, and their solution spearheaded by stage director Phil Chan is to move the beginning of the story to San Francisco in 1941, right before the bombing at Pearl Harbor. When the three-year time skip occurs, the setting then changes to an internment camp in Arizona, with Pinkerton being away at the war while Cio-Cio-San is stuck behind wire fencing with Suzuki. I have to admit I was not a big fan of where this production concept took the story, but I decided to sit with it, see what else would change.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1694783131/BLO_01_--_Nightclub_performer_Butterfly_Karen_Chia-Ling_Ho_at_mic_entertains_patrons_in_BLO_s_new_production_of_MADAMA_BUTTERFLY___PHOTO_by_Ken_Yotsukura.jpg){{% /md %}}

<figcaption>Karen Chia-Ling Ho as Cio-Cio San (centre) in Boston Lyric Opera's production of Madama Butterfly, 2023. Photo: Ken Yotsukura.</figcaption>  
</figure>

Act I did not really change much, except to amp up the playfulness of the marriage: here, it is recontextualized as a fake wedding at a club in Chinatown, where everyone is more or less in on the joke (including Cio-Cio-San). I do feel perhaps the Bonze episode did not quite land as hard as it should for that part of the story considering that the change to why Bonze is angry at Cio-Cio-San isn't made entirely clear by how this bit is staged and subtitled, but I do think there is precious little you can do to change this part of the story considering how many of the pieces are laid here to move the story to its denouement. 

But there is a significant change to the story in the back half with much more far-reaching implications; it is also a change that is a little difficult to talk about without also tying it into internment camp conditions. Cio-Cio-San does not kill herself in the end, and actually she makes it to the double bar line of Act III still alive, and being pantomimed by a different actor playing her almost four decades later in 1983. It is instead her child who dies at the end; at the top of Act II, it is made quite clear that the child has contracted tuberculosis while in the internment camp, and so the entire conflict of the second two acts is hoping Pinkerton will be able to do something to help heal the child. Unfortunately, as soon as Cio-Cio-San finishes singing to her child in the opera's final aria, he dies, with Pinkerton walking in to see her crying over her dead child.

It is effectively trading one overdone opera death for another, but I think this decision to change who dies at the end of the story is still one of the most brilliant aspects of the production. For one thing, it does address one of the major criticisms that most Asian communities have of the ending's Eurocentric subtext. But for another thing, it also somewhat changes the stakes of the story, and in a way that does lend a certain amount of urgency that perhaps was lacking a little in the original form of the story. It for sure also smooths over some of the criticism of Cio-Cio-San as a stereotypically submissive Asian woman, although on this front I am not entirely sure the production is successful.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1694783131/BLO_03_--_A_marriage_between_performer_Butterfly_Karen_Chia-Ling_Ho_onstage_l.jpg){{% /md %}}

<figcaption>Karen Chia-Ling Ho (Cio-Cio-San) and Dominick Chenes (B.F. Pinkerton) in Boston Lyric Opera's production of Madama Butterfly, 2023. Photo: Ken Yotsukura.</figcaption>  
</figure>

And perhaps part of that is because, for all that Phil Chan did to address the issue of why the child going with his father was somehow the better outcome for him, I don't think it completely manages to address the "Un bel di vedremo"-sized elephant in the room. For sure, it does change the nature of why she's so insistent on Pinkerton's return in a way that makes it less about lust and more about motherly love, but it makes the insistence that Pinkerton specifically will come back a little strange, to the point it bordered on making her somewhat delusional. Some of this is due to how they age the character up and how the youthful naiveté that is central to Cio-Cio-San in the original opera feels fairly out of place with the motherly figure that the rest of the production does such a good job of painting her as. Some of it is also due to the nature of the "wedding" in the first act: the insistence on Pinkerton's return specifically gets weirder when even Cio-Cio-San is in on the fact it's not a real wedding, and while it is established that Pinkerton and Cio-Cio-San develop true feelings between each other after the Bonze episode it still feels a little strange to me at least.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1694783130/BLO_08_--_Increasingly_desperate_for_Officer_Pinkerton_s_return_Butterfly_Karen_Chia-Ling_Ho_top_spots_a_US_military_plane_as_Suzuki_Alice_Chung_l.jpg){{% /md %}}

<figcaption>Karen Chia-Ling Ho (Cio-Cio-San) and Alice Chung (Suzuki) in Boston Lyric Opera's production of Madama Butterfly, 2023. Photo: Ken Yotsukura.</figcaption>  
</figure>

However, I feel a much bigger part of it is that this is one of the places where Puccini's score seems to poke through the conceit of the whole production. Part of the reason that _Madama Butterfly_ works so well as a dramatic work is that there is a sense of musical payoff that happens throughout the whole opera, and that can sometimes work against a radical reimagining like this. After all, it is easy to rewrite lines of dialogue (and indeed, this production went into Illica and Giacosa's libretto and changed a few things, including giving some of Cio-Cio-San's lines to Pinkerton and changing almost every specific reference to location), but reworking music that is as tightly paced and plotted out as _Madama Butterfly_ is is a much more Herculean task, and it occurred to me as I was biking home from the Emerson Colonial Theater that perhaps not every problematic edge could be sanded off of _Madama Butterfly_ for this reason. Thus, I imagine that Phil Chan and his team came up with the best solutions they could while being constrained by Puccini's score, and unfortunately that meant that this particular quirk of how Cio-Cio-San was written could not really be worked around. The result did end up taking me out of the experience a little bit, although thankfully not enough to completely alienate me from the production.

At the end of the day, after all, while the tone of what I have stated here may come off somewhat against the reimagining, I have to say I walked away from it actually rather enjoying a good chunk of it. The references to American life in Act II's internment camp scene came with a bit of sarcasm that is much appreciated at that point in the opera, the Act I setting change to a Forbidden City-style bar felt very playful in exactly the right way, and while I wish they could have gone all the way with it (for some reason, the "if you can't live with honor, die with honor" line is still sung with unaltered text even though the subtitles give a very different quote) I did appreciate that they were willing to edit the libretto to suit the production. But most importantly, while I was conscious of the way it was addressing the issues of racial stereotyping and anti-Asian racism in the opera house, the production never felt like it was calling attention specifically to how that conversation applied to _Madama Butterfly_. It felt like it was a story that at the very least cropped out of the outline of _Madama Butterfly_ that was worth telling in its own right, and while some of the edges were still a little rough I walked away from it with more things I liked about the production's details than things I did not like.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1694783131/BLO_11_--_Suzuki_Alice_Chung_l.jpg){{% /md %}}

<figcaption>Alice Chung (Suzuki) and Troy Cook (Sharpless) in Boston Lyric Opera's production of Madama Butterfly, 2023. Photo: Ken Yotsukura.</figcaption>  
</figure>

It also helped significantly that Puccini's score was performed rather sumptuously throughout the whole. David Angus led the orchestra through Puccini's score with incredible depth of feeling and understanding for the material, and he made sure that the singers could always be heard no matter what. The singing was also to quite a high standard throughout the night. Some highlights included Alice Chung's warmer take on Suzuki, Rodell Rosel making quite a comedic impression as the normally thankless Goro, and Dominick Chenes providing a rather more soulful Pinkerton than you usually get with this role.

But easily the highlight of the night had to be [Karen Chia-Ling Ho](/scene/people/karen-chia-ling-ho/) as the titular Madame Butterfly: this was one incredible star-making turn in Puccini's title role. Chia-Ling Ho had an incredibly clear voice that cut through Puccini's orchestration with almost no problems whatsoever. It also had a lot of very clear character, in that she was an incredible actress, and even was able to alter her voice in a mocking manner when talking about the judges sending her to the concentration camps in Act II. But her "Un bel di vedremo" absolutely brought the house down; my issues with it in this production aside, she beautifully conveyed the sense of hope that comes with the aria, and the two-minute long stretch of applause she brought out of the Emerson Colonial's audience was thoroughly deserved in every way.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1694783131/BLO_09_--_Butterfly_Karen_Chia-Ling_Ho_embraces_her_son_Dolore_Neko_Umphenour_in_BLO_s_new_production_of_MADAMA_BUTTERFLY___PHOTO_by_Ken_Yotsukura.jpg){{% /md %}}

<figcaption>Karen Chia-Ling Ho (Cio-Cio-San) and Neko Umphenour (Dolore) in Boston Lyric Opera's production of Madama Butterfly, 2023. Photo: Ken Yotsukura.</figcaption>  
</figure>

It ended up anchoring a rather unusual take on _Madama Butterfly_ that, for the most part, ended up working significantly better than I feared it might. I found myself not loving every aspect of the production, for there are still a few asterisks I think could have been answered differently. But for the most part, I actually rather enjoyed everything I saw, and it found ways to address the racial elements of the story without coming off as especially preachy about it within the context of the production. And for a company that spent three years mulling on this opera and how to produce it in this century, that is quite the compliment.