+++
author = ["authors/arturo-fernandez.md"]
categories = "Review"
date = "2018-10-13T10:10:00-04:00"
lastmod = "2018-10-13T16:07:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1539439833095/sqBLO2018_Barber-10.jpg.jpg"
primary_image_credit = "Daniela Mack (Rosina) in Boston Lyric Opera's new production of The Barber of Seville, directed by Rosetta Cucchi, 2018. Photo: Liza Voll Photography."
publishDate = "2018-10-13T10:10:00-04:00"
related_articles = ["articles/schoenberg-in-hollywood-a-heap-of-excess.md"]
related_companies = ["scene/companies/boston-lyric-opera.md"]
related_people = ["scene/people/daniela-mack.md"]
short_description = "So was this production of Barbiere overdesigned? For sure. But unlike most overdesigned productions, the director remembered that, at the end of the day, opera is a storytelling medium, and she carried that knowledge into the performances just as much as the production design. The result was thus a delight to watch, and even with the occasional misstep it proved to be perhaps the best demonstration of Italian opera I have seen in a long time."
slug = "blo-barber-brings-delightful-laughter-amid-overdesign"
title = "BLO Barber brings delightful laughter amid overdesign"
+++

There is a striking tendency among production designers in opera these days to bring an element of the abstract into the proceedings, especially in established staples of the operatic repertory. The effect is often distracting, and in its worst examples it distracts from opera's story-telling purpose. 

This description does not necessarily fit certain aspects of the production of Rossini's classic *Il barbiere di Siviglia*, which opened the Boston Lyric Opera's season. The production design opted for an M.C. Escher-inspired aesthetic that also left the barest suggestions of what Dr. Bartolo's house might look like. It certainly left a backdrop for insanity, as this design of the set allowed for over the top costume design that seemed to borrow everything from matador costume Figaro donned and the chorus's Alice in Wonderland card people garb to the 80's prom dress that Rosina wore. The effect proved a touch distracting.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1539439665810/BLO2018_Barber-2.jpg.jpg)
<figcaption>Matthew Worth (Figaro) in Boston Lyric Opera's new production of *The Barber of Seville*, directed by Rosetta Cucchi, 2018. Photo by Liza Voll Photography.</figcaption>
</figure>
	
Additionally, multiple aspects of the prop and scene design registered as being a little obvious in how they related to the action. During Don Basilio's slander aria, for instance, Basilio speaks from a pulpit flown in from the ceiling. A cage also flies over Rosina during one of the times that Dr. Bartolo tells her he is keeping her trapped in the house. And then, during the faux music lesson, there were red musical instruments scattered all around the stage: Almaviva-as-Lindoro-as-Don-Alonso played from a Giraffe on the top of one of the set’s two towers, with the rest of the instruments sitting there to embellish the scene.

If this seems noisy and chaotic to anybody else, well, that was the point: as stage director Rosetta Cucchi's program note explained, the production design was a play on Rossini's play between chaos and order. Whether or not it served the story is another matter, and this is where this Barbiere avoids the pitfalls of most overdesigned productions: Cucchi does not lose sight of the story she is telling, even when her production design doesn’t necessarily work. There was a moment where two chorus members perched in the audience with a lantern when Figaro is describing his barber shop to Almaviva: this was ultimately distracting and added nothing to the production, but it at least related to the action in a tangible way, which is certainly much more than you can say about other productions of this caliber.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1539439684948/BLO2018_Barber-5.jpg.jpg)
<figcaption>Daniela Mack (Rosina) and Jesus Garcia (Count Almaviva) in Boston Lyric Opera's new production of *The Barber of Seville*, directed by Rosetta Cucchi, 2018. Photo by Liza Voll Photography.</figcaption>
</figure>

Additionally, when the more obvious touches work, they do add to the story in meaningful ways. The cage is one area that the production hit a home run with on this front: it provided a good chuckle when Rosina proceeded to step right out of the cage with no effort at all, and it provided hilarious punctuation to her declaration of how Bartolo's decree would be almost useless. So, too, did the red instruments come into play, as Almaviva, Rosina, Figaro, and Bartolo all weaponized the instruments to hilarious effect in the ensuing chase scene. Thus, when the obvious set pieces work, they really work, and luckily there were more hits than misses as relates to this aspect of the production.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1539439695029/BLO2018_Barber-6.jpg.jpg)
<figcaption>Michelle Trainor (Berta) in Boston Lyric Opera's new production of *The Barber of Seville*, directed by Rosetta Cucchi, 2018. Photo by Liza Voll Photography.</figcaption>
</figure>

It is also apparent that Cucchi knows *Barbiere*'s story incredibly well almost exclusively from how she directs her singers' Italian diction. Where most productions would treat the recitative sections as an afterthought, here they are overflowing with character and comedy just from the myriad ways that the singers' Italian stretched and pattered and inflected in every which direction. The specificity of the Italian also carries into the arias and ensemble numbers, and while those are more controlled by necessity they never lose the character and flavor they have in the recitatives. It is not unreasonable to expect that Cucchi may be partly responsible for this, as I have never heard the Italian language used in such a specific way in any other production of any Italian opera, never mind Barbiere: let it be said that the audience should be immensely thankful for such attention to detail in the Italian, because the use of the Italian itself tied the whole production together in the end.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1539439703139/BLO2018_Barber-9.jpg.jpg)
<figcaption>The cast of Boston Lyric Opera's new production of *The Barber of Seville*, directed by Rosetta Cucchi, 2018. Photo by Liza Voll Photography.</figcaption>
</figure>

Of course, that would not be possible without the excellent cast that populated the stage of the Cutler Majestic. Steven Condy, for instance, brought a delicious stuffiness to Dr. Bartolo that amplified his tyrannical nature to great results. David Crawford also wrangled a lot of laughs by playing Don Basilio as a walking corpse, which played perfectly into his fake illness in the second act while simultaneously poking fun at his moral bankruptcy. Even Matthew Worth’s Figaro fell into these neuroses, where his already-large joie de vivre and wit was amplified to almost superhuman levels. Jesus Garcia brought a manic energy to Almaviva not typically seen, and this helped lend both credibility and a whole lot of laughs to the scenes where Almaviva was disguised as other people. [Daniela Mack](/talking-with-singers-daniela-mack/) brought a bratty irreverence to Rosina that made the libretto’s declarations of her wit carry weight. It should really say something that Michelle Trainor, a favorite of the Boston opera scene and one of the highlights of BLO's [Threepenny Opera](/blos-threepenny-opera-a-misanthropic-delight/) from last season, almost had to fight for attention amongst this ensemble of neuroses: all of these neuroses combined led to an innumerable number of laughs. And of course, that is before the audience even considers the fantastic singing they all provided.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1539439710403/BLO2018_Barber-1.jpg.jpg)
<figcaption>Jesus Garcia (Count Almaviva) in Boston Lyric Opera's new production of *The Barber of Seville*, directed by Rosetta Cucchi, 2018. Photo by Liza Voll Photography.</figcaption>
</figure>

So was this production of *Barbiere* overdesigned? For sure. But unlike most overdesigned productions, the director remembered that, at the end of the day, opera is a storytelling medium, and she carried that knowledge into the performances just as much as the production design. The result was thus a delight to watch, and even with the occasional misstep it proved to be perhaps the best demonstration of Italian opera I have seen in a long time.

>BLO's *The Barber of Seville* runs through October 21. For details and tickets, [click here](https://blo.org/barber/)
