+++
author = ["authors/arturo-fernandez.md"]
categories = "Review"
date = "2024-02-21T00:00:00+01:00"
lastmod = "2024-02-21T00:00:00+01:00"
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1708525012/sqBLO_anon_Valcour_Omar_Najmi_advises_Leontine_Brianna_J.jpg"
primary_image_credit = "Valcour (Omar Najmi) advises Leontine (Brianna J. Robinson) on how to deal with a secret admirer in BLO's The Anonymous Lover. Photo by Nile Scott Studios."
postamble = ""
publishDate = "2024-02-21T00:00:00+01:00"
related_articles = ["articles/in-review-tcherniakovs-don-giovanni/.md", "articles/pagliacci-alone-makes-festive-shocking-season-opener/.md"]
related_companies = ["scene/companies/boston-lyric-opera.md"]
related_people = ["scene/people/brianna-j-robinson.md", "scene/people/evan-hughes.md", "scene/people/omar-najmi.md"]
short_description = "This opera is a rather simple affair, where the entire storyline is 'Valcour loves Leontine and absolutely cannot spit it out until their mutual friends and a young peasant couple in love inspire him to do so', and… that's it."
slug = "simplicity-strikes-a-chord-in-blo-anonymous-lover"
title = "Simplicity strikes a chord in BLO Anonymous Lover"
+++
When one thinks of comic opera, one's mind is typically drawn to a work where complicated slapstick shenanigans occur, with characters often frantically running around a stage trying to untangle a complicated mess of misunderstandings and mistaken identities. For indeed, this is what tends to proliferate throughout any movement of comic opera. 

It is a refreshing surprise, then, when an opera comes along that dispenses with the slapstick shenanigans and keeps the stakes relatively simple. After all, much of these operas are about characters unable to simply spit out how attracted they are to each other. It is sometimes worth asking what an opera would be like if it dispensed with the slapstick and focused on romance.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1708525012/BLO_anon_The_Cast_of_BLO_s_The_Anonymous_Lover_PHOTO_by_Nile_Scott_Studios.jpg){{% /md %}}

<figcaption>The cast of The Anonymous Lover, BLO, 2024. Photo by Nile Scott Studios.</figcaption>
</figure>

Enter Joseph Bologne, the Chevalier de Saint-George and his opera _L'amant anonyme_, the only one of his operas to survive to the modern day. This opera is a rather simple affair, where the entire storyline is "Valcour loves Leontine and absolutely cannot spit it out until their mutual friends and a young peasant couple in love inspire him to do so", and… that's it. It is a premise as simple as Joseph Bologne's highly melodic music, and one might be forgiven for feeling that such a simple premise as this might not be enough to carry an entire evening.

And yet, at least in [Boston Lyric Opera](/scene/companies/boston-lyric-opera/)'s rendering, it does, partly thanks to a very well-adapted (and updated) book by Kirsten Greenidge. Between the various numbers in Bologne's score, BLO opted for spoken dialogue between the numbers in English, and this was delivered in absolutely hilarious manner by practically everyone on-stage. This was some very snappy dialogue, and it engendered a fun atmosphere that carried the very simple premise forward. In fact, in my estimation, it almost carried it a little too much; there were moments in the production where it felt like Bologne's score took a little bit of a back seat to the spoken dialogue, and while the dialogue never missed I felt like there were times it could have backed off and let the score do a little bit more of the talking. This is sometimes a bit of a shame, because Bologne's score is genuinely quite charming in a lot of ways. There is a mastery of mood that Bologne demonstrates throughout the score, but it never fully loses its sense of playfulness even as it navigates the characters' more dour moods.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1708525013/BLO_anon_Brianna_J.jpg){{% /md %}}

<figcaption>Brianna J. Robinson as Leontine in The Anonymous Lover, BLO, 2024. Photo: Nile Scott Studios.</figcaption>
</figure>

That said, it was still an immensely entertaining script, in that when it did manage to let the score shine through it played very well with the score's playful nature. It is indeed a very good match overall, and both combined to lead to a very fun night at the opera.

I would go on about individuals in the cast, but truly, among the main characters in this cast there were pretty much no misses whatsoever. [Brianna J. Robinson](/scene/people/brianna-j-robinson/) is probably the one stand-out performer as Leontine: she generally has the hardest stuff to sing in the whole score, and not only did she meet the challenging writing head-on, but she also played off the other characters really well even in the spoken dialogue scenes. It should also frankly surprise nobody that [Omar Najmi](/scene/people/omar-najmi/) absolutely relished the part of Valcour, and he was every bit Miss Robinson's equal in terms of vocal ability and comedy chops. Among the supporting players, there were also nothing but hits: [Evan Hughes](/scene/people/evan-hughes/) made for an absolutely hilarious best friend for Valcour even if I did feel he struggled a little with the role's punishingly high tessitura, Sandra Piques Eddy made for a similar counterpart to Leontine, and then Zhengyi Bai and Ashley Emerson both rounded out the cast with a bubbly pair of lovers that tied a bow on the whole.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1708525013/BLO_anon_1.jpg){{% /md %}}

<figcaption>(l-r) Omar Najmi, Sandra Piques-Eddy, Brianna J. Robinson and Evan Hughes in BLO's The Anonymous Lover. Photo by Nile Scott Studios.</figcaption>
</figure>

Musically, as well, the production was generally a hit. I do perhaps feel that the orchestra could have stood to be a little bit closer to the audience: the orchestra played behind a scrim behind the singers, rather than within the Huntington Theater's orchestra pit. While this meant that the orchestra never overpowered the singers, I feel like the result led to the opposite problem, where the orchestra got absolutely swallowed up by the singers in some of the larger ensemble numbers. Still, David Angus led the orchestra on a very sensitive and stylistically minded rendering of Bologne's score, and it really set a good backdrop for the singers to play off.

The production, there is not very much to comment on. In general, apart from Bai's green coat I loved the color scheme, which opted for pastel reds and blues through a good chunk of the design aesthetic. The set, while minimal, did enough to tell the story and keep things moving at a good clip, and it really let Dennis Whitehead Darling's direction shine. And this was something critical, for the direction kept everything moving at a good clip.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1708525012/BLO_anon_Valcour_Omar_Najmi.jpg){{% /md %}}

<figcaption>Valcour (Omar Najmi, l.) confides to Jeannette (Ashlee Emerson) his indecision about what to send his secret love in BLO's The Anonymous Lover. Photo by Nile Scott Studios.</figcaption>
</figure>

There is also one touch in the direction that, while small, I greatly appreciated, and I think anyone would appreciate when you consider the life story of Joseph Bologne: while it is not necessarily a major plot point, Valcour in this adapted script is played as a composer himself, who has not composed a note since starting to pen anonymous letters to Leontine four years before. This was perhaps best highlighted in the overture (really his 11th Symphony), where, towards the end, Omar Najmi as Valcour stepped up to an on-stage harpsichord and played along with the orchestra for a few bars as if composing the piece. Considering Bologne's status as a black man in Classical Parisian society, and further considering Najmi's status as a composer in his own right, it gave me the impression that Valcour was standing in for Bologne himself. I generally do not get on well with "love makes for bad art" as a storytelling trope, but here it is forgivable since it feels like it gives Joseph Bologne a happy ending he was likely denied in real life.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1708525012/BLO_anon_Leontine_Brianna_J.jpg){{% /md %}}

<figcaption>Leontine (Brianna J. Robinson) cajoles Ophemon (Evan Hughes) to tell the identity of The Anonymous Lover in BLO's production. Photo by Nile Scott Studios.</figcaption>
</figure>

Overall, BLO brought a charming piece to brilliant life all throughout. It is always an interesting thing to see how certain genres handle simplicity of the greatest order, and Bologne's score manages such with a lot of charm and a lot of verve. This is for sure a comic opera that deserves its current cultural spotlight, and this performance here was a delightfully bubbly affair that is perfect for a late Valentine's Day date.