+++
author = ["authors/john-hohmann.md"]
categories = "Review"
date = "2018-04-12T22:27:00-04:00"
lastmod = "2018-04-13T17:46:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1523586145261/sq---6Q5A0562.jpg.jpg"
primary_image_credit = "Jessica Fishenfeld and Scott Joiner during the poignant conclusion of Big Jim and the Small-Time Investors. Photo: Travis Magee."
publishDate = "2018-04-12T22:27:00-04:00"
related_articles = ["articles/opera-technology-hither-and-yon.md"]
related_people = ["scene/people/scott-joiner.md","scene/people/jessica-fishenfeld.md"]
short_description = "If the title sounds more like a riff on Dion and the Belmonts or Martha Reeves and the Vandellas, in a way, it is. Big Jim sings, or more precisely, croons, about getting rich by investing in his interactive &quot;reality&quot; fantasy goggles. His small-time investors hum along. Big Jim appears live to the audience but only on suggested video screens to his investors. They are the ultimate back-up singers."
slug = "big-jim-and-the-smalltime-investors-a-story-often-told"
title = "Big Jim and the Small-time Investors: a story often told"
+++

The best stories are the ones told over and over again. How fortunate we are then, to have one of the oldest sung and played with such musical verve and theatrical invention. The story, that of getting rich quick, is summed up in the title of the late Eric Salzman's opera, *Big Jim and the Small-Time Investors*. This week Cutting Edge Concerts New Music Festival 2018 presented the first fully staged production of this timely and innovative work.

If the title sounds more like a riff on Dion and the Belmonts or Martha Reeves and the Vandellas, in a way, it is. Big Jim sings, or more precisely, croons, about getting rich by investing in his interactive "reality" fantasy goggles. His small-time investors hum along. Big Jim appears live to the audience but only on suggested video screens to his investors. They are the ultimate back-up singers.

But the gifted ensemble portraying these greedy schemers does more than just hum along. They play journalists, preachers, police offers, and assorted others in J. Griffith Brown's fast-moving staging. That they manage to establish individual personae, especially as the investors, is as much due to their ability to turn on a dime as to Ned Jackson's adroit libretto. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1523586227285/6Q5A0481.jpg.jpg)
<figcaption>(l-r) Jessica Fishenfeld as Kim, Big Jim's wife, dealing with Allison McAuley, Alex Frankel, Helena Brown, Blake Burroughs, Jami Leonard and Benjamin Bloomfield as Jim's investors while they experience his interactive virtual reality goggles, and Aaron Theno (in the foreground without goggles), as Stan, Jim's manager in *Big Jim and the Small-Time Investors*. Photo: Travis Magee.</figcaption>
</figure>

Eric Salzman originated a genre he called music, not musical, theater, that is neither musical theater nor opera, though it included elements of both. Big Jim leans towards opera. In addition to being a composer, Salzman involved himself in other aspects of his music theater, as writer, director, producer, and founder of performance organizations. 


Salzman's works tend to be on a smaller scale than most operas. They are less text-driven or linear than standard book musicals, which is certainly true to form here. This one-night outing makes a case for the production of some of Salzman's other compositions, like the intriguingly titled, *Jukebox in the Tavern of Love* or *The True Last Words of Dutch Schultz*, in which a barbershop quartet plays a mobster's henchmen.

If these musical works can be produced with the economical creativity exercised by scenic designer, Abby Walsh, by all means they should be. Her stacks of cardboard boxes that transform from an impressive inventory at the outset to ruins by the opera's end don't ask for, or require, any scenic mercy. They function beautifully. Hopefully CTC will rally its *Big Jim* collaborators, Quog Music Theater and Gramercy Opera, around the mission to keep Salzman's compositions front and center.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1523586291582/6Q5A0424.jpg.jpg)
<figcaption>Scott Joiner as Big Jim King in Cutting Edge Concerts New Music Festival 2018 production of Eric Salzman's opera, *Big Jim and the Small-time Investors*. Photo: Travis Magee.</figcaption>
</figure>

*Big Jim* travels in the avant-garde with atonal music that is comfortably braced with myriad rhythms including jazz, tango, and more than a touch of lounge. The composition makes the use of far-flung arioso and choral cacophony sound natural, indeed inevitable. It doesn't strive for profundity. Much the same can be said for CTC founder and *Big Jim* conductor, Victoria Bond, who is an exponent and composer of contemporary music herself. Bond leads a six-person orchestra that includes an accordion and electronics. She deftly controls the seemingly uncontrollable and conducts with an assurance that captures the surprising delicacy and frequent mayhem of the score. By operatic standards or even those of musical theater, *Big Jim* is a short show and would flow more seamlessly without an intermission. 

Scott Joiner performs a vocal slight of hand with his portrayal of Big Jim. Projecting a puppy dog charm that is both relaxed and insinuating, he surmounts Salzman's composition with an elastic tenor sound that thrillingly embraces the abstract, even as the intended effect is that of him singing "Moon River" or some other soothing tune. Such is Big Jim's power of persuasion that he can employ an intentionally naïve touch of sleaze to appear trustworthy. As Joiner sings one thing, Jim's investors process quite another. So do we. The results on stage are financial disaster and dashed rather than virtually realized dreams. The payoff is a magical performance by Scott Joiner.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1523586367598/6Q5A0399.jpg.jpg)
<figcaption>Darynn Zimmer as Big Jim's mother going wild with the goggles in *Big Jim and the Small-Time Investors*. Photo: Travis Magee.</figcaption>
</figure>

Jackson's libretto is so finely aligned with the composition, that even when parts of the ensemble's singing are clouded by the flat acoustics at the Thalia, we get the picture. Trust occupies much of the chatter in act one. A brief duet between Big Jim and Stan, his manager, wittily and ruefully sung by baritone, Aaron Theno, is accompanied by cello, accordion, and a blush of percussion. It is a fleeting and ravishing moment. 

In the second act, when trust is ousted by blame, chaos ensues. Everyone, even his own mother, sung with subtle power by soprano, Darynn Zimmer, denounces Jim, who appears to have shrunk within his dark suit. Decay, as in a portrait by Schiele, has set in and Jim's puppy dog appeal is lost to a disconcertingly angular angst.  

Mindful of the burst of the dot.com bubble; the emergence of fake news; and the acceptance of perception over reality, *Big Jim* has a currency that few contemporary operas can claim. When Jim holds auditions to select a wife, it is a cringe-worthy reminder of the power and temptation of reality television. Hopping through musical styles as the would-be wives audition, does little to ameliorate the odious exercise but at least it sounds interesting. 

That Jim chooses a wife who has won a beauty contest is, in this context, no surprise. That she turns out to be steadfast is. As Jim's wife, Kim, soprano, Jessica Fishenfeld sings with cool efficiency as she troubleshoots for Jim and becomes his best salesperson. Near the opera's end, when Jim finally appears in person, he is wrapped to great theatrical effect, in a red plastic drop cloth. As Kim embraces him, Fishenfelds's elegant soprano deepens to movingly convey her character's vocal arc. In the end, largely due to the poignant presence of Joiner and Fishenfeld, I wondered if ultimately *Big Jim and the Small Time Investors* was more a story of love, a concept even older than greed or deception.
