+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2024-05-30T00:00:00-00:00"
lastmod = "2024-05-30T00:00:00-00:00"
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1716998262/sqSWEAT_Credit_Kieran_Turnbull_1.jpg"
primary_image_credit = "A still from SWEAT, directed by Jennifer Nichols with cinematography by Ash Tailor and music direction by Geoffrey Sirett. Image credit: Kieran Turnbull."
publishDate = "2024-05-30T00:00:00-00:00"
related_articles = ["articles/in-review-sweat.md"]
related_people = ["scene/people/catherine-daniel.md", "scene/people/keith-lam.md", "scene/people/larissa-koniuk.md", "scene/people/stephanie-tritchew.md", "scene/people/caitlin-wood.md"]
related_companies = ["scene/companies/the-bicycle-opera-project.md", "scene/companies/canadian-art-song-project.md"]
short_description = "Before you even realize it, you know who's soft-spoken, who jokes the most, who's an activist, who's most in it for herself; you know what their desires and fantasies are -- to be a star of the fashion industry, of course -- and what they'd do with any sort of livable income they dream of making."
slug = "a-must-watch-sweat-on-screen"
title = "A must-watch: SWEAT on-screen"

+++
Canadian opera lovers might remember _SWEAT_, the 2016 opera by composer Juliet Palmer and librettist Anna Chatterton that pits beautifully intricate _a cappella_ singing with a dark glimpse into the bleakness of today's fashion industry. In 2017, [The Bicycle Opera Project toured _SWEAT_](/in-review-sweat/) across Canada, and last year they adapted it into a film; directed and choreographed by Jennifer Nichols, and with cinematography by Ash Tailor and music direction by Geoffrey Sirett, the film _SWEAT_ premiered at the 2023 Kingston Canadian Film Festival, and soon after won Best Narrative Feature at the LA Independent Women Film Awards.

Now, the film comes to Toronto, with a special screening at the Revue Cinema on Saturday, June 15. And for the rest of June, [_SWEAT_](https://bicycleopera.com/sweat-2024/) will be available to stream worldwide (June 16-30).

For fans of new opera or creative storytelling or art with a relevant message, _SWEAT_ is a must-see. The opera translates beautifully to the screen. We meet one team of workers at a sweatshop somewhere in the world -- it doesn't really matter, we always think of them as far away -- and watch as they try to survive. Their hurdles are many: grueling quotas to meet (1000 dresses a day!), pitifully low bids for the day's pay, a hazardous workplace, and verbal, physical, and sexual abuse by their superiors.

But still the women send hope out into their rough surroundings, and it's that hope that makes this story opera-sized. It's an impressive feat of storytelling -- by _SWEAT_'s creators, and by the choices by director Nichols and cinematographer Tailor -- that we so quickly understand the individuals among this group of women. Before you even realize it, you know who's soft-spoken, who jokes the most, who's an activist, who's most in it for herself; you know what their desires and fantasies are -- to be a star of the fashion industry, of course -- and what they'd do with any sort of livable income they dream of making. It's an ensemble cast of individuals, cohesively created by Larissa Koniuk, Stephanie Tritchew, Caitlin Wood, Alex Beley, Erica Iris, Justine Owen, and Cindy Won -- and we end up caring about all of them.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1716998097/SWEAT_Credit_Kieran_Turnbull_2.jpg)
<figcaption>A still from SWEAT, directed by Jennifer Nichols with cinematography by Ash Tailor and music direction by Geoffrey Sirett. Image credit: Kieran Turnbull.</figcaption>
</figure>

Well, most of them. _SWEAT_'s clear villain is The Owner, sung with a jarring bite by [Keith Lam](/scene/people/keith-lam/). Lam's is the only male voice in the show, and the opera leans on the sheer contrast of his cutting baritone against the womens' aetherial blend. Low-voiced person, cruel capitalist, misogynist and sexual abuser: The Owner stands for many villains, it seems. More murky is The Overseer, the woman supervising the sweatshop workers, hurling slurs at them and demanding gratitude for giving them a two-minute restroom break. Sung imposingly by [Catherine Daniel](/scene/people/catherine-daniel/), The Overseer is a frustrating presence; at my most naïve I'm dying to ask her: _Aren't you like these women? Don't you see this isn't right?_ But Daniel, with her cool stoicism that only fades when circumstances become their most dire, prods another facet of this story: what about the people -- like us, maybe -- who choose themselves over an injustice that's clearly too large for one person to fight?

It's a rare thing that an opera holds power both as a live artform and on screen. Onstage, _SWEAT_ is a musical feat, an impressive showcase of intricate vocal ensemble singing. As a film, it's stylized yet real, a true and earthy story told through a lens of beauty; Palmer's gorgeous harmonies and Chatterton's evocative words and and Nichols' choreography that drapes bodies like the swish of fabric. The sound design by Palmer and Sirett is thoughtful, not a flat imposition of a studio recording; the sound echoes differently when the women sing in confined spaces, outdoors, at their workstations. And since it's also Nichols' feature film directorial debut, it's worth noting how effective the climactic scene is, how she leans into the heartbreaking beauty in the singers even as a nightmare unfolds.

So, [give _SWEAT_ a watch](https://www.eventbrite.ca/e/sweat-tickets-884966046267). Head to the Revue Cinema at 400 Roncevalles Ave on __June 15 at 6:30pm__ for this exclusive screening, followed by a Q&A with the creative team; [tickets are $20 + fees](https://www.eventbrite.ca/e/sweat-tickets-884966046267). The event also features another premiere, the animated short _The Wild Goose_, produced by the [Canadian Art Song Project](/scene/companies/canadian-art-song-project/). _The Wild Goose_ is written by singer-songwriter Wade Hemsworth, arranged for CASP by [Cecilia Livingston](/talking-with-composers-cecilia-livingston/), and performed by CASP Co-Artistic Directors Stephen Philcox and Lawrence Wiliford.

After that, stream the film digitally for $15 (+ fees) from June 16 to June 30. For a sneak peek, check out the official trailer:

<figure data-type="video">{{% md %}}<iframe width="921" height="321" src="https://www.youtube.com/embed/FO4h_KdTVfI" title="SWEAT Trailer" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>{{% /md %}}
</figure>