+++
author = ["authors/john-hohmann.md"]
categories = "Review"
date = 2020-10-28T04:00:00Z
disclaimer = ""
image_gallery = []
postamble = "For further information and tickets, contact[ lesdelices.org](https://www.lesdelices.org/event/bewitched/)."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1603756860/media/2020/10/sqBewitched_nk2ly6.png"
primary_image_credit = "Hannah De Priest in \"Bewitched\", presented by Les Délices, 2020."
related_articles = ["articles/renee-fleming-brings-a-new-luster-to-dumbarton-oaks.md"]
related_companies = []
related_people = ["scene/people/hannah-de-priest.md"]
short_description = "Nagy and her group appear in the perfect environment for their naturalistic style of video that revels in dramatic fades to black, subtle cross fades and deft use of camerawork and lighting. The passing from day to night, from a sun-filled hall to one of intense lighting and dramatic shadow, is visually alluring."
slug = "bewitched-by-les-delices-captivating-in-cleveland"
title = "\"Bewitched\" by Les Délices: Captivating in Cleveland"
youtube_url = ""

+++
Witches are people too, and they have relatable issues. Those mythological heavy hitters, Medea and Circé, are the subjects of "Bewitched," the first installment of _Embracing Change_, the four-concert virtual season being streamed by the Cleveland-based early music group, [Les Délices](https://www.lesdelices.org/event/bewitched/). Resorting respectively to filicide and transforming men into beasts, these mythic women are nonetheless captivating. Artistic director, Debra Nagy and her group don’t explain away their actions but they do provide edifying narrative context that amplifies the circumstances of the women behind the myths. Les Délices meets the pandemic head on with creative energy in this gracefully produced and beautifully performed concert.

The four composers involved, all of the French baroque, are not widely known with the exception perhaps of Francois Couperin, whose "La Françoise Sonade" played by the ensemble, opens the program. "Medée" and "Circé", cantatas by Louis-Nicolas Clérambault and Colin de Blamont, sung by soprano [Hannah De Priest](/authors/hannah-de-priest/), flank "Le Vertigo," a work for solo harpsichord by Pancrace Royer played by Mark Edwards.

The gleaming Georgian Colonial architecture of the Plymouth Church in the Cleveland suburb of Shaker Heights, the setting for the entire series, is in the fullest sense of the phrase, simply elegant. Nagy and her group appear in the perfect environment for their naturalistic style of video that revels in dramatic fades to black, subtle cross fades and deft use of camerawork and lighting. The passing from day to night, from a sun-filled hall to one of intense lighting and dramatic shadow, is visually alluring.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1603821410/media/2020/10/Bewitched-2_qultjx.png){{% /md %}}

<figcaption>"Bewitched", presented by Les Délices, 2020.</figcaption>

</figure>

The magic lies in its contrasts; refined but not averse to showing snakes of electric cord or bank of lights and up-close intimacy while maintaining a distinct artistic distance. "Bewitched" raises the bar for streaming events that have fairly taken over since the pandemic halted live performing arts. At a most challenging time Les Délices embarks on a creative adventure to extend its audience beyond their in-person performances rather than an alternative to them. The modest ticket price is a cultural gift.

The concert, lasting just over an hour, is essentially "live" with interspersed pre-recorded narration by Nagy, De Priest and Edwards. Nagy speaks with the cool head of the group's leader, De Priest with the requisite concern of a soprano about to embody two furious figures, and Edwards with an efficient charm that evokes his prowess at the harpsichord. Collectively they present information that doesn't halt the evening's momentum but actually increases our anticipation for the music to come.

The ensemble, in addition to Edwards at the harpsichord, consists of Nagy on baroque oboe and recorder, Julie Andrijeski playing baroque violin and Rebecca Reed on cello and viola da gamba. Their rendition of "La Françoise Sonade" marked by close communication and a restrained flair for shifting moods, creates an atmospheric backdrop for the mythological meltdown that follows. These musicians are finely tuned to each other. Watch as the camera captures their many communicative moments, especially with De Priest. We would likely miss these in live performance but the sensitive camerawork guides the eye.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1603821421/media/2020/10/Bewitched-3_iqzncf.png){{% /md %}}

<figcaption>"Bewitched", presented by Les Délices, 2020.</figcaption>

</figure>

Chicago-based De Priest, to whose voice adjectives like "sparkling" and "shining" have already been applied, takes her lyric soprano to fervent depths as she creates vivid portraits of two complex figures with only a one cantata for each to work with. These are nuanced witches. De Priest's Medea is plagued by internal rage and revenge, while Circé registers uncertainty and regret as she evokes much of her community of gods and goddesses. De Priest's French sounds and feels impeccable adding to the luster of these singular interpretations. Wearing a black and gold power gown, she exudes the formality of a diva and lovely emotional accessibility. With roles such as Belinda in _Dido and Aeneas_ and Drusilla in _L'incoronazione di Poppea_ already in her repertoire, the future of this young soprano is bright on both the operatic and recital stages.

If any of the four composers are due for a resurgence, it's Royer. Composing in the shadow of the more famous Jean Phillippe Rameau, Royer's "Le Vertigo" takes the harpsichord to rather startling heights. Edwards calmly explains that the work is a dialogue and we are never in doubt as to who is talking. With repeated turns that switch from the deferential to unrelenting intensity, Edwards is the epitome of virtuosity. His crisp articulation and hold on the perfect balance between the confines of the score and technical dynamics ignite the heretofore prim harpsichord.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1603821432/media/2020/10/Bewitched-4_e0nyag.png){{% /md %}}

<figcaption>"Bewitched", presented by Les Délices, 2020.</figcaption>

</figure>

When you stream this event, available through November 2 - and you should - be sure to watch the pre-concert interview conducted by Nagy with Seth Pevnick, curator of Greek and Roman Art at the Cleveland Museum of Art and Timothy Wutrich, Professor in the Classic department at Case Western Reserve University. Using photos of two wine kraters, one featuring Medea, in the collection at CMU and another with Circé at the Metropolitan Museum of Art in New York, along with a wealth of scholarly perspective, they bring the infrastructure of this captivating concert full circle.