+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2016-03-06T21:26:00+00:00"
lastmod = "2016-03-08T11:42:00+00:00"
preamble = "American mezzo-soprano [Betany Coffland](/scene/people/betany-coffland/) has some of opera's juiciest roles under her belt, like Carmen, Rosina, Dorabella, and Elle in *La voix humaine*. She recently started her own floral design business, [Chloris Floral](http://www.chlorisfloral.com/#home), where she even designs bouquets based on her favourite pieces of classical music and [operatic characters](http://blog.chlorisfloral.com/index.php/2015/09/19/mozarts-zerlina-says-i-do/). \n\nBetany chats with us about stepping outside of singing in order to find artistic fulfilment, about the curious practice of [floriography](https://en.wikipedia.org/wiki/Language_of_flowers), and creating a *Pierrot Lunaire*-inspired bouquet.\n\n"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1457432930883/2016-03-08---Betany---Paige_Green_film_photo.jpg.jpg"
primary_image_credit = "Photo by Paige Green."
publishDate = "2016-03-08T11:39:00+00:00"
related_people = ["scene/people/betany-coffland.md"]
short_description = "It’s funny what happens when you let go and put out your truth to the world. Good things happen. So, I recommend for all singers at whatever stage of their career, look for passion. Passion is cultivating, inspiring and uplifting and it will only enhance your life and therefore, your art."
slug = "betany-coffland-creating-operatic-bouquets"
title = "Betany Coffland: creating operatic bouquets"
+++

## What inspired you to work with floral design, on top of your already busy singing schedule?

A few years back, though I had a busy singing schedule, I wasn’t being filled artistically. It literally felt like there was a hole in my chest from all the pressure I was putting upon myself to be a "busy singer". For my health, I decided that I needed to cut out all the noise to get at the root of the problem. So, I stopped singing to see what would happen and goodness, that was a scary time. Singing was all I’d ever known and so much of my identity and self-worth was wrapped up in being "a classical singer".

I had read a book called *The Dirty Life* about an ex-corporate’s adventures in organic farming; inspired by her, I started volunteering at a local flower farm. That season, I became a co-owner of that flower farm, returned to singing after my three months hiatus and relished my time in learning the new skills of farming, floral design and educating about the importance of local flowers. Reynaldo Hahn’s gorgeous song, "À Chloris" is one of my favorites and when I discovered that Chloris was also the Greek goddess of flowers, I knew that I had my business name, Chloris Floral.

## What sorts of operatic and classical music influences have you incorporated into your bouquet designs? Can you tell us more about the local flower movement?

For a year now, I’ve been doing the musically inspired floral bouquets and I started a blog six months ago called [Chloris Floral Notes](http://blog.chlorisfloral.com/), where about every month I do a musically inspired bouquet and photo shoot. My first one was based on Debussy’s symphonic piece *La Mer*, where I was able to shape the calla lilies into the shape of an ocean wave. I’ve done Bizet’s *Carmen* with the flowers representing her flamenco dancing in the shape of the gesturing ranunculus stems, and one of my favorite opera inspired bouquets has been Zerlina’s wedding bouquet from *Don Giovanni*. Other than obvious visual influences, I’m able to incorporate floriography, also known as the language of flowers.

The local flowers movement, also known as Slow Flowers, is revolutionizing the domestic flower industry. Currently about 80% of our flowers in the US are imported. The worst part is many of these flowers, being transported by planes, are sprayed with noxious chemicals that unsuspecting customers ingest when smelling and touching these flowers. There is also a hidden history of these big flower companies stealing precious water resources from small villages. It’s a practice that needs to be changed through education and believe me, when someone sees and smells the difference of a locally grown bouquet of blooms from the farm down the lane, there’s no turning back.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1457433266800/2016-03-08%20-%20Zerlina%20bouquet.jpg.jpg)
<figcaption>The "Zerlina bouquet". Photo by Jessica Sue Layton.</figcaption>
</figure>

## Can you tell us a bit about floriography, and how it influences the musically inspired bouquets?

Floriography comes from Victorian times, and was often used as a secret language. When lovers couldn’t communicate openly in society, they would often leave bouquets of flowers as codes to profess their secret thoughts. Victorians often gave each other "talking bouquets" and the receiver, with the help of their flower dictionary could decipher the message. For example, poppies mean "I am not free", a marigold signifies "jealousy" and sweet peas mean "goodbye".

Through floriography I’m able to add in my own secret meanings behind my musically inspired bouquets. For example, in Mozart’s Zerlina bouquet, I added in nigella pods, also known as "Devil in the Bush" to signify the Don’s unhappy end with Lucifer. In Ariadne’s wedding bouquet, I added gold colored tones found in the thistle and rattlesnake grass to signify her royalty.

## In your experience, how common is it for young singers to have a second passion? Do you find your music and floral design inform each other, or connect in some way?

I don’t find this to be cultivated in the industry and I highly encourage every singer to explore a passion outside of music. For me, it hasn’t taken away from my first aspiration, it’s only enhanced it. I had so many reservations in letting my music colleagues know about my floral design, for I was worried that it meant that I was less of a professional singer. But then I did this amazing photo shoot with master photographer, Paige Green, where I dressed in a gown and farmer wellies and we shot at my favorite local farm. The result was cathartic. For me, I was able to figuratively combine my two careers and shortly after that shoot, the ideas of doing musically inspired bouquets came to me. 

It’s funny what happens when you let go and put out your truth to the world. Good things happen. So, I recommend for all singers at whatever stage of their career, look for passion. Passion is cultivating, inspiring and uplifting and it will only enhance your life and therefore, your art.

## As a singer, do you have any roles you’re eager to perform?

I’ve been quite lucky to perform some of the great lyric mezzo roles in the repertoire, but of course, I do have my bucket list. My dream role is Jo in Adamo’s *Little Women*. I would also love to sing Massenet’s Charlotte (*Werther*) and Elizabeth in *The Crucible*. I’d also love to do some more Handel and I’m eager to repeat some of my favorites like Rosina, Cenerentola and Elle in *La Voix Humaine*.

## You’re performing *Pierrot Lunaire* this season; if you were to design a bouquet inspired by the piece, what would it look like?

Oh, this is something I’m definitely planning and I have so many ideas dancing around in my head! Learning *Pierrot* has been the biggest challenge of my professional singing career, and I’m so in love with the weird and intellectual. I’m not quite sure how that’s going to transfer yet in the actual bouquet, for how I work in my business is driving out to the flower farms and harvesting the most beautiful blooms at their peak. So, at lot will depend on what’s in season in Sonoma County at that time. 

However, I have my eye on this great swing in a barn loft where I’m hoping to incorporate some puppetry into the photo shoot for *Pierrot*. Of course, it’s also going to have to be a night shoot with the moon being present. It’d be great to get a dark black colored red rose in the bouquet representing blood and black magic as seen throughout the *Pierrot* poems. Perhaps some forget-me-nots to signify "memories", hyacinth for "playfulness", and some magnolia leaves to represent our "noble" artist Pierrot. All this imagery and imagination of what’s possible helps to strengthen and add to my interpretation of *Pierrot Lunaire*. I’m so inspired!

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/xw8IN97J1zo" frameborder="0" allowfullscreen></iframe>
<figcaption>Betany Coffland singing Hahn's "À Chloris", with guitarist and arranger Aaron Larget-Caplan.</figcaption></figure>
