+++
author = ["authors/sam-darling.md"]
categories = "Review"
date = 2020-01-25T05:00:00Z
disclaimer = ""
image_gallery = []
postamble = "[_BERLIN: The Last Cabaret_](https://cityoperavancouver.com/) runs Jan. 23-26 at Performance Works in Vancouver."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1579967701/media/2020/01/sqCityOperaVancouver_Berlinsmall2_yv34vo.jpg"
primary_image_credit = "Meaghan Chenosky. Photo: Diamond's Edge Photography."
related_articles = ["articles/vergesst-uns-nicht-adi-braun-on-weimar-cabaret.md", "articles/berlin-the-last-cabaret.md"]
related_companies = []
related_people = []
short_description = "With the world premiere nature of this show and the resurrection of some of this music, it should come as no surprise that the songs disappeared from our cultural lexicon because they’re not musically memorable. I kept waiting for a showstopper, but none were forthcoming"
slug = "a-vital-and-contemporary-evening-in-berlin-the-last-cabaret"
title = "A \"vital and contemporary\" evening in BERLIN: The Last Cabaret"
youtube_url = ""

+++
In a show that is heartbreakingly relevant and contemporary in its themes and anxiety, City Opera Vancouver presents the world premiere of the political satire, _BERLIN: The Last Cabaret_ from January 23–26, 2020, at Performance Works (sold out). Set in Nazi Germany on July 13, 1934, the biting satire of resurrected Weimar-era music set to English lyrics plumbs dark humor, to remind us to celebrate our freedom especially when it is in danger of being yanked away.

Directed and co-created by Alan Corbishley and Joanna Garfinkel (dramaturg) in association with Sound the Alarm: Music/Theatre, and presented with the PuSh International Performing Arts Festival, a cabaret troupe tatters and falls apart before our eyes as Nazism swells outside the café doors. A group of six stalwarts, barely persevering to put on a show for us as their unseen sixth member, "Tommy", has disappeared, the five that remain have to decide whether to quit in fear or perform their work.

> The production is cerebral rather than carnal in its meditation of the time and place.

The cast of five are given a whirlwind to execute with terrific choreography by Tara Cheyenne Friedenberg, apart for some screen work and climbing on lighting rigs that didn’t quite hit the mark – odd choices, perhaps hoping to expand the stage work rather than play with the intimate nature of a cabaret format. I would have preferred the cabaret-style interaction of actors with the audience instead. The troupe is expected to dance and sing through tears and sweat. In particular, Sebastian (Alen Dominguez) practically jumps through hoops. The audio equipment and speed of the numbers sometimes got the better of this nimble young group and made it hard for audiences to catch every acidic punchline of the stanzas. Musical director Roger Parton might be more sensitive to allegro tempo on mouthful songs like "I Am a Vamp" and "Life’s a Swindle".

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1579974482/media/2020/01/CityOperaVancouver-Berlinsmall3_aaed0h.jpg){{% /md %}}

<figcaption>Daniel Deorksen, Brent Hirose, Meghan Chenosky, Alen Dominguez, Julia Muncs. Photo: Diamond's Edge Photography.</figcaption>

</figure>

Some of these musical pieces have not been performed in decades, yet the topics are fresh and modern – meditations on our what it is to be "Masculine And Feminine" or how much the government should be permitted to interfere in a woman’s right to choose [Paragraph 218](https://en.wikipedia.org/wiki/Abortion_in_Germany).

Unsurprisingly, many of the characters reminded me of _I Am My Own Wife_, a show about the life of German antiquarian Charlotte von Mahlsdorf, who survived the Nazi and Communist regimes in East Berlin as a transgender woman. That award-winning theatrical production used Charlotte's own acerbic wit to leaven the cynicism of the time and place. This production of _BERLIN: The Last Cabaret_ sometimes forgets to lighten the mood, preferring to build to a dramatic ending that focuses on the disappeared in a time of authoritarianism, rather than remaining in the oddly uplifting style of Weimar cabaret: defiant mockery of the boot as it lands on your face.

People sometimes think of cabaret as early camp, but it is perhaps better explained in the show’s own words, "If we’re going to get in trouble for doing nothing we might as well start something." The four composers whose songs are featured were all of Jewish heritage and were forced to leave Germany due to their willingness to push society to expand at the fringe and make space for new kinds of people.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1579974527/media/2020/01/CityOperaVancouver-Berlinsmall4_xprpqa.jpg){{% /md %}}

<figcaption>Alen Dominguez, Julia Muncs. Photo: Diamond's Edge Photography.</figcaption>

</figure>

The one endemic flaw in this show is that the production is fading as we watch it, a performance withering on the vine due to external forces closing in. And for the audience members, too, the energy sags in the latter third of the show. The production is cerebral rather than carnal in its meditation of the time and place. The academic review of the time period means that when the actors simulate lustiness on stage it can come across as gratuitous. Even though the heart of cabaret is to shock audience away from their meals by putting on outré productions such moments here seem to appear out of nowhere. It is also somewhat lopsided with the women in the cast expected to bare themselves most explicitly. These moments of emotional and physical vulnerability did not feel earned.

> The actors were perhaps not given enough specificity as characters for us to relate to them.

The lack of emotional resonance in the latter third of the show was no fault of the cast. They were all splendid and Trude (Meaghan Chenosky) in particular demonstrates real authenticity in her emotional turns. There was a clear difference between her playing the vamp, versus when she’s revealing real emotions. The actors were perhaps not given enough specificity as characters for us to relate to them as they don’t interact with each other until toward the end of the show – most of their performance is done toward the audience, often acting in the arch style of a silent film. As a result, it was hard to understand the gravity of losing them when we were attached to them only as caricatures, not as people. This was the case despite the characters having been based on real-life counterparts.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1579974565/media/2020/01/sqBerlinLastCabaret_emplid.jpg){{% /md %}}

<figcaption>Alen Dominguez, Julia Muncs. Photo: Diamond's Edge Photography.</figcaption>

</figure>

With the world premiere nature of this show and the resurrection of some of this music, it should come as no surprise that the songs disappeared from our cultural lexicon because they’re not musically memorable. I kept waiting for a showstopper, but none were forthcoming. The closest to it was possibly the proto-gay anthem "Lavender Song "("Das Lila Lied") which ought to be memorized for Pride parades. We hear only a snippet of the one song that has lasted the test of time, "Falling In Love Again". Yet the English translation of the songs crisply makes the evening feel vital and contemporary; political satire that remains as salient today as it did on [The Night of the Long Knives](https://en.wikipedia.org/wiki/Night_of_the_Long_Knives).