+++
author = ["authors/jenna.md"]
categories = "Interview"
date = 2020-01-22T05:00:00Z
disclaimer = ""
image_gallery = []
postamble = "[_BERLIN: The Last Cabaret_](https://cityoperavancouver.com/) runs Jan. 23-26 at Performance Works in Vancouver."
preamble = "With its latest production, City Opera Vancouver is combining two things that opera fans love: world premieres and cabarets. [_BERLIN: The Last Cabaret_](https://cityoperavancouver.com/), running Jan. 23-26, is based on the real-life drama of Weimar-era cabaret artists under Nazi rule.\n\nWe spoke with Alan Corbishley, _BERLIN_ director and co-creator, about using cabaret as a way of telling the story of its Weimar artists."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1579747193/media/2020/01/sqBerlinLastCabaret_qqsmpu.jpg"
primary_image_credit = ""
related_articles = []
related_companies = []
related_people = []
short_description = "\"We chose July 13, 1934 for our piece, the day Hitler made a speech claiming responsibility for the \"Night of the Long Knives,\" where two weeks prior, he ordered the S.A. division of the Nazi Party, including Röhm who uneasily protected Queer artists, massacred due to a purported threat of mutiny.\""
slug = "disturbingly-relevant-berlin-the-last-cabaret"
title = "\"Disturbingly relevant\": BERLIN: The Last Cabaret"
youtube_url = ""

+++
## How true-to-life is the story in _BERLIN: The Last Cabaret_?

**Alan Corbishley**: The show is an interpretation of the Weimar era, based on our research and understanding of the Berlin cabaret scene and politics of the day.  The five characters created for this particular story are composites sourced from significant artists. With aspects and stories drawn from real life personalities such as Erich Mühsam, Ernst Busch, Karl Valentin, Trude Hesterberg, Trude Kolman, Sebastian Droste, Claire Waldorf, and Fritz Grünbaum to name but a few.

We chose July 13, 1934 for our piece, the day Hitler made a speech claiming responsibility for the ["Night of the Long Knives"](https://en.wikipedia.org/wiki/Night_of_the_Long_Knives), where two weeks prior, he ordered the S.A. division of the Nazi Party, including Röhm who uneasily protected Queer artists, massacred due to a purported threat of mutiny. In turn, he also threatened the general public with certain death to anyone who attempted to stand up against the Regime. This of course causes many problems for a Queer cabaret troupe whose entire artistry is based on political satire.

Within these pillars of historical reference, the story and plot is the product of Alan Corbishley and Joanna Garfinkel.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1579747239/media/2020/01/CityOperaVancouver-Berlinsmall2_xakvzg.jpg){{% /md %}}

<figcaption>Meaghan Chenosky. Photo: Diamond's Edge Photography.</figcaption>

</figure>

## How were the original cabaret songs chosen for this show?

**AC**: We chose the music of four remarkable Weimar composers who had in common powerful interest in experiment and disruption, a rich repertoire of cabaret gems, and they were all of Jewish heritage.  And for that, all four were driven from Germany when Hitler came to power in 1933.  

> This show explores how this particular troupe reacts to this political tension and eventual threat of death.

We wanted to explore the incredible songs that were true hits within the cabarets themselves and not necessarily choose commercial hits of the day. The songs are charged with humour and endless commentary on the legal and political issues of the day (which are disturbingly resonant to the issues of 2020 politics), and explored cultural identity through the lens of sexuality and gender non-conformity.

## What does _BERLIN_ say about the relationship between the arts and politics?

**AC**: This show is centred around this very framework - how politics not only affected the arts, but controlled and obliterated the voices of an entire generation.  After a rich decade known as the Weimar Era (1919-1933) where Germany was briefly a democratic state and artists were celebrated within an exceptionally progressive and liberal culture, their entire way of life was suddenly under intense censorship. In fact, once under Nazi rule, all artists needed to be approved and provided a permit to publicly present any artistic output be it music, visual art, theatre. 

Naturally, artists who were not deemed "worthy" were quickly denied and then prosecuted under strictest enforcement if caught presenting their art unauthorized. The vast majority of musicians and cabaret artists fled in 1933. This show explores how this particular troupe reacts to this political tension and eventual threat of death.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1579747256/media/2020/01/CityOperaVancouver-Berlinsmall3_fd2ibg.jpg){{% /md %}}

<figcaption>Daniel Deorksen, Brent Hirose, Meghan Chenosky, Alen Dominguez, Julia Muncs. Photo: Diamond's Edge Photography.</figcaption>

</figure>

## What do you hope to say with this world premiere production?

**AC**: This show is essentially a warning to never forget our past, as our surrounding culture is frequently and direly susceptible to corruption, hatred, and fear. How can we be living in 2020, and still be challenging the legitimacy of sexual orientation and gender non-conformity, as well as resisting women's rights and diverse cultures? And yet, Western societies - lands that are meant to be filled with "freedom and liberty" - are embracing ever more fervently xenophobia, racism and bigotry. This show is meant to generate thought and conversation around how we as a human species are capable of horrendous things - despite our collective beauty.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1579747270/media/2020/01/CityOperaVancouver-Berlinsmall4_tygcos.jpg){{% /md %}}

<figcaption>Alen Dominguez, Julia Muncs. Photo: Diamond's Edge Photography.</figcaption>

</figure>