+++
author = ["authors/arturo-fernandez.md"]
categories = "Review"
date = "2019-06-13T04:00:00+00:00"
disclaimer = ""
image_gallery = []
postamble = "[_Orlando_](https://bemf.org/2019-festival/festival-operas/centerpiece-opera/) runs at Boston Early Music Festival through June 16."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1560465422/media/2019/06/sqBEMForlandodress-22.jpg"
primary_image_credit = "Aaron Sheehan (Orlando) in Orlando, Boston Early Music Festival, 2019. Photo: Kathy Wittman."
related_articles = ["articles/blo-s-electrifying-rape-of-lucretia-a-revelation.md", "articles/chemistry-sizzles-onstage-in-paride-ed-elena.md"]
related_companies = ["scene/companies/boston-early-music-festival.md"]
related_people = ["scene/people/emöke-baráth.md", "scene/people/aaron-sheehan.md", "scene/people/amanda-forsythe.md", "scene/people/jesse-blumberg.md"]
short_description = "As messy as the plot of Orlando is, this approach worked for this opera just as well as it has in previous seasons, and the result was rather a joy to watch that it became rather easy to turn the brain off and just enjoy the opera as it is."
slug = "bemf-orlando-a-dazzingly-performed-spectacle"
title = "BEMF Orlando a dazzlingly performed spectacle"
youtube_url = ""

+++
The Boston opera scene has had an entire half of a season full of productions that have engaged with our modern times, frequently to great effect. However, sometimes one needs to engage with an opera on its own terms, and indeed there are a few operas in the repertory where meeting it on its own terms is the only way to perform it.

Typically, these are earlier operas, where performance requires a razor-sharp edge on the musical aspects of the work, and the performance can live or die on how well the music comes across to the audience.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1560465096/media/2019/06/BEMForlandodress-05.jpg){{% /md %}}

<figcaption>Emöke Baráth as Bradamante in Orlando, Boston Early Music Festival, 2019. Photo: Kathy Wittman.</figcaption>

</figure>

Thus, we turn to Agostino Steffani's _Orlando_, a singularly strange operatic creature that the [Boston Early Music Festival](https://bemf.org/2019-festival/) has decided to stage as its centerpiece opera in its 2019 festival. _Orlando_ is likely a difficult work to make sense of, particularly since Ortensio Mauro's libretto for the opera essentially hinges on the characters doing things for no reason other than the plot demanding it.

For example, there is a sorcerer character named Atlante, who begins the work opposing the marriage of the lovers Bradamante and Ruggiero. It is never really explained why he does not want this marriage to occur, and then in Act II the big lovers' spat between Bradamante and Ruggiero ends up happening anyway thanks to factors that Atlante has no part in. After all this (and a second encounter where Bradamante uses her ring to overpower Atlante), he suddenly decides not to oppose it, quite literally because Fate decreed they would marry.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1560465085/media/2019/06/BEMForlandodress-03.jpg){{% /md %}}

<figcaption>Jesse Blumberg (Atlante) and Emöke Baráth (Bradamante) in Orlando, Boston Early Music Festival, 2019. Photo: Kathy Wittman.</figcaption>

</figure>

This is far from the only element of Mauro's libretto that does not quite add up. Atlante also decides to form a strange palace for the characters to get lost in. Why does he do that? A reason is never given. Then, there is Angelica, a princess who decides to disguise herself as a shepherdess to investigate something in her father's house. Exactly what she decides to investigate is never made clear, and it instead becomes more of a set-up to allow title character Orlando to face a crisis of love that drives him mad. Of course, Orlando is suddenly cured of his madness, in no small part thanks to Angelica's father Galafro throwing him in a cell out of pity.

>The plot of Orlando thus comes off as an excuse to let the singers explore all sorts of configurations of love.

The one thing that is made clear is a very wild series of misunderstandings between different groups of lovers, all of whom grow jealous of each other as the work goes on. Bradamante becomes angry at Ruggiero when she mistakenly thinks Ruggiero has fallen for Angelica, Orlando's madness is triggered by his belief that Angelica loves Ruggiero, his madness manifests as believing that everyone is Angelica, and the whole time Angelica is trying to reunite with Medoro, who happens to be her actual lover.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1560465075/media/2019/06/BEMForlandodress-06.jpg){{% /md %}}

<figcaption>Emöke Baráth (Bradamante) in Orlando, Boston Early Music Festival, 2019. Photo: Kathy Wittman.</figcaption>

</figure>

Things get complicated when Galafro only releases on the request of his disguised daughter, and even then it is primarily because he begins to lust after her not knowing that the beautiful shepherdess is, in fact, his daughter in disguise.

>The dance corps that BEMF hired should also be applauded for some truly beautiful dancing.

The plot of _Orlando_ thus comes off as an excuse to let the singers explore all sorts of configurations of love. With such a work, therefore, the only way to engage it is on its own strange, silly terms. Ironically, this is perhaps why this opera is actually a perfect fit for the Boston Early Music Festival: BEMF has made it a habit of staging works by maintaining as much fidelity to Baroque staging styles as is reasonable, with the costume and set design taking many, many cues from production notes from the actual 17th and 18th centuries and updating many of the gestural cues involved. The stage directors that work with BEMF are thus kind of required to engage with the works they perform as they are, and typically this leads to a very fun, very spectacular result.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1560465065/media/2019/06/BEMForlandodress-14.jpg){{% /md %}}

<figcaption>A scene from Orlando, Boston Early Music Festival, 2019. Photo: Kathy Wittman.</figcaption>

</figure>

As messy as the plot of _Orlando_ is, this approach worked for this opera just as well as it has in previous seasons, and the result was rather a joy to watch that it became rather easy to turn the brain off and just enjoy the opera as it is. For one thing, the production handled the frequent spectacle of the work with taste and a deft hand for all of the elements. There were several times where characters were flown in on a little cart suspended from the rafters, and the effect never lost its freshness throughout the runtime considering how many different contexts there were for each flight into the scene. The dance corps that BEMF hired should also be applauded for some truly beautiful dancing, complete with tight footwork and hand gestures that conveyed a lot of character with very little.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1560465053/media/2019/06/BEMForlandodress-12.jpg){{% /md %}}

<figcaption>Amanda Forsythe (Angelica) in Orlando, Boston Early Music Festival, 2019. Photo: Kathy Wittman.</figcaption>

</figure>

And then there were several deft staging touches that, while perhaps not always accurate to the period, were nevertheless in good taste, and of these there are too many examples to count.  It also had some very adept comedy: in particular, Angelica had some stage business with a shepherdess hat in Act I that complemented the humor of the scene where she would tilt the hat down to hide her face any time she insisted she was not Angelica to Orlando. And then there was how the illusory people in Atlante's palace moved with rather robotic motions: it added to the idea that these people were not necessarily real.

>Steffani's music is innovative and strange according to the conventions of his time.

It was a lot of little touches all throughout, but the appropriateness of each little touch added to the drama and to the conceit of the whole production.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1560465040/media/2019/06/BEMForlandodress-20.jpg){{% /md %}}

<figcaption>Aaron Sheehan (Orlando) in Orlando, Boston Early Music Festival, 2019. Photo: Kathy Wittman.</figcaption>

</figure>

But of course, it all comes down to the singing in the end, and the musical direction allowed for some top-notch sung performances across the board. BEMF typically finds singers that are extremely well-versed in Baroque styles of singing, and the result ensures that it always feels like something is happening even in patches where there is nothing of import happening.

Practically the entire cast flawlessly pulled off Steffani's virtuosic vocal writing with ease, but what is more is that they also did so with such clarity in the line that every note in the runs could be heard. They also colored their voices in interesting ways to suit the needs of the drama: in particular, I must point at an aria in Act II in which [Amanda Forsythe](/scene/people/amanda-forsythe/)'s Angelica laments the fact she cannot find Medoro: the way her voice ebbed in and out with a pure tone leant a sorrow to the aria that would have been lost had it been performed any other way.

>Thus, BEMF's performance of Steffani's _Orlando_ proved to be a spectacular delight.

And then, [Emöke Baráth](/scene/people/emoke-barath/)'s Bradamante came charging forth with full voice any time she scolded Ruggiero for what she perceived as his unfaithfulness. Practically everyone had something to offer with that, from the way that [Jesse Blumberg](/scene/people/jesse-blumberg/)'s tone as Atlante grew softer after he stops trying to get in the way of Bradamante and Ruggiero to the passion with which [Aaron Sheehan](/scene/people/aaron-sheehan/) delivered his show-stopping Act III prison aria as Orlando, and the result was a well-rounded cast at the top of their game lending credibility to the emotions and motivations of the characters.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1560465023/media/2019/06/BEMForlandodress-24.jpg){{% /md %}}

<figcaption>A scene from Orlando, Boston Early Music Festival, 2019. Photo: Kathy Wittman.</figcaption>

</figure>

That on its own did a lot to help paper over the scattershot nature of the plot, but what also helps is that the musical direction was also top notch. The orchestra's basso continuo section was particularly strong, supporting all the singers in the way they pushed and pulled at the text in ways that suited what the text was saying. What was more, they kept the pacing very brisk, not lingering too long on anything. It also highlighted how unusual Steffani's music could be in its treatment of _da capo_ musical forms, and thus showed why the work was musically interesting enough to warrant a production. Steffani's music is innovative and strange according to the conventions of his time, and the performance allowed that to shine through in the best way possible.

Thus, BEMF's performance of Steffani's _Orlando_ proved to be a spectacular delight. Perhaps the plot of the opera proved a little scattershot, but when it is performed this exquisitely by musicians and direction that understands the style the way these performers and directors did, it is rather difficult to care. This led to a wonderful night at the opera, and one that should prove that performing Baroque opera on its own terms as Baroque opera is possible.