+++
author = ["authors/andrew-schneider.md"]
categories = "Review"
date = "2018-04-25T15:45:00-04:00"
lastmod = "2018-04-25T17:28:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1524685175131/sqhgo---west-side-story---photographer-lynn-lane-30-3000x2000.jpg.jpg"
primary_image_credit = "Andrea Carroll (Maria) and Norman Reinhardt (Tony) in West Side Story, Houston Grand Opera, 2018. Photo: Lynn Lane."
publishDate = "2018-04-25T17:28:00-04:00"
related_articles = ["articles/a-definitive-hit-west-side-story-in-atlanta.md"]
related_companies = ["scene/companies/houston-grand-opera.md"]
short_description = "HGO hit the nail on the head in making West Side Story come across as a highly successful play with songs, with Jerome Robbins&#039;s choreography being by far the lead attraction of the evening in terms of its sheer power of unspoken expression."
slug = "beloved-bernstein-hgos-west-side-story"
title = "Beloved Bernstein: HGO&#039;s West Side Story"
+++

The production of *West Side Story* that [Houston Grand Opera](/scene/companies/houston-grand-opera/) mounted this past Friday in the centennial year of its composer, the magisterially versatile Leonard Bernstein, proved itself to have been long overdue. I have always been a fan of his music, which brilliantly integrates elements of the culture of the United States into a cohesive whole; though this Broadway musical, the first one I have seen in a long time, rather underwhelmed me in certain aspects in comparison to the hype with which it has been promoted.

While the United States has a musical theatre tradition that can hold more than a candle to the great Offenbach, in a way, HGO hit the nail on the head in making *West Side Story* come across as a highly successful play with songs, with Jerome Robbins's choreography being by far the lead attraction of the evening in terms of its sheer power of unspoken expression. If it were not for these pantomimed expressions of unremitting conflict and tension, then this show would have very little reason to exist as an integral whole.

Especially jarring to me, however, was the extremely dated nature of Arthur Laurents's book, with its colorful vocabulary that can only be from the 50s, despite the production's efforts to update the setting to the present day, dress-wise; though this is an inevitable part of having shows with as many creators as this one does, one senses that hiding the quilt stitchings was not the biggest priority here. (Scribe or Metastasio feel to my perception so much easier to update, despite their antiquity.) 

Certainly with as many highly involved scene changes as this show demonstrated, an episodic feel was unavoidable; I stress that this is something that operatic audiences are not inclined to expect so much of, given their expectations for elaborate morceaux d'ensemble, as do people who see musicals
regularly.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1524689232198/hgo---west-side-story---photographer-lynn-lane-21-3000x2000.jpg.jpg)
<figcaption>Ensemble members in *West Side Story*, Houston Grand Opera, 2018. Photo: Lynn Lane.</figcaption>
</figure>

All of that aside, Bernstein's marriage of highly adept music to Stephen Sondheim's cynical lyrics was very much on display, with supreme vocalism being prevalent throughout the evening, as one would only expect. Though Bernstein's expertly crafted hit tunes, ensembles, and ballads were sung with a great deal of earnestness and genuine feeling, especially with the often snide and contrapuntal accompaniments being unsettled just below the surface in the way only a master composer can successfully pull off, the songs always felt like they were somehow interrupting dramatic momentum, and they generally always felt quite short in duration. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1524689360657/hgo---west-side-story---photographer-lynn-lane-45-3000x2000.jpg.jpg)
<figcaption>Andrea Carroll (Maria) and Norman Reinhardt in *West Side Story*, Houston Grand Opera, 2018. Photo: Lynn Lane.</figcaption>
</figure>

Nevertheless, this definitely accentuated the notion that the songs, for the most part, still make sense on their own, and that putting them in this theatrical piece feels like an effort to stuff a play with musical numbers, given the extreme length of the dialogue, which was also acted compellingly by all parties.

As Tony, tenor Norman Reinhardt was a very convincing example of this trait; this role gave him a great opportunity to display both his superb high register and his declamatory lower register. Overall, he got the very idealistic nature of his character just right, definitely a character that has no place around such pandillas, one who is searching for some greater meaning in this world that will simply not allow for him to find it. "Something was coming," indeed. When it was time for him to sing "Maria", he definitely sounded to my ear like a liberated soul free to express itself, though not in an entirely uninhibited manner: there was a certain sense of awe about Tony's realization of his finding love that kept his soliloquy somewhat in check. His frantic rant towards the end wherein he was searching for a final confrontation with Chino (a very human Dominic Pecikonis) truly was a cri du coeur in the most intimate sense, one which the absence of a musical accompaniment really let him express to the fullest extent.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1524689429329/hgo---west-side-story---photographer-lynn-lane-56-3000x2000.jpg.jpg)
<figcaption>Amanda Castro (Consuela), Alissa LaVergne (Estella), Gabrielle McClinton (Anita), Tempestt Perrin (Francisca), and Tasha Heggem (Teresita) in *West Side Story*, Houston Grand Opera, 2018. Photo: Lynn Lane.</figcaption>
</figure>

Andrea Carroll's Maria felt a rather imperfect fit; though I did enjoy her Woglinde last year, and though she was dramatically well-placed to fit the type of a naïve teenager whose bright-eyed hopes come crashing down around her, leaving her with no clear precedent to guide her reaction. Though her vocalism was very well-suited to long, soaring melodic lines as in "Somewhere", her rather thick accent made her seem rather like someone who was merely imitating the borinqueña she was portraying, but this may well be the result, once again, of an extremely dated script which lends itself to such portrayals.

Indeed she radiated an air of "feeling pretty", but I sensed that this role is less than an ideal one to study the flow of character development as opposed to a character's environment.

Yet so are many of the roles in this show, which give the impression of being caricatures that are struggling for a real purpose. In particular, the unmotivated adults who seem to know no practicable way of dealing with the senseless warfare in the streets are easily singled out. The hapless and brutish Officer Krupke (Thomas Glass), less than skilled at probing interrogation, was a particularly distasteful portrait; indeed one almost felt Glass's sense of frustration in not being allowed to make these particular cops look in any way charitable.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1524689446191/hgo---west-side-story---photographer-lynn-lane-127-3000x2000.jpg.jpg)
<figcaption>Gabrielle McClinton (Anita) and Andrea Carroll (Maria) in *West Side Story*, Houston Grand Opera, 2018. Photo: Lynn Lane.</figcaption>
</figure>

The most genuine of these characters would probably have to have been Zoie Reams's Rosalia, who was an effective, optimistic foil to the very cynical Anita (Gabrielle McClinton), although one suspects that in the current climate of public discourse in regards to the effects of a different, meteorological, Maria, the images she conjured in "America" of a destitute Caribbean island lacking basic infrastructure are infinitely more relevant. I should mention that the scene in which Anita is nearly subjected to rape by the Jets was extremely terrifying and not for the faint-hearted, all the more so for how visceral the atmosphere was.

Generally the cast members making up the gangs were skilled at portraying aimless youths with no clear purpose in life and only knowing the motivations of sex and survival. Brian Vu's take on Riff was particularly apt in portraying somebody with at least some sense of his own dignity without whom the world would not be the same. When he and then Bernardo (a dynamic DJ Petrosino) went down at the end of Act I, their absence cast a tangible pall over the rest of the performance: I genuinely missed them.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1524689459269/hgo---west-side-story---photographer-lynn-lane-64-3000x2000.jpg.jpg)
<figcaption>Connor McRory (Action), Christopher Tipps (Baby John), Rachel Mengden (Clarice), Kelsey Kincaid-Gibbs (Anybodys), Ben Delony (Snow Boy), Melissa Hunter McCann (Graziella), Brian Vu (Riff), Tucker Breder (Big Deal), Megan Morgan (Velma), PJ Palmer (A-Rab), Rob Fleebe (Gee-tar), and Randy Castillo (Diesel) in *West Side Story*, Houston Grand Opera, 2018. Photo: Lynn Lane.</figcaption>
</figure>

Throughout, the HGO Orchestra, led by the dynamic Timothy Myers, felt far more supportive of the cast than it has been accustomed to being in this particular venue, with the string section particularly showing off both their skills in warm, lush sustained chords and violently frenetic pizzicato passages.

Kudos likewise are due to the brass section, which was quite on point, as well as the extremely active, yet never excessively exuberant, percussion section. Indeed, the tamtam strokes at the end were of just sufficiently profound a nature to remind me of the death of Boris Godunov. The fact that I could not find any mention of the orchestrators in the program is, however, quite perplexing.

In short, many great artistic works are notable for how they are not very beautiful on the outside, but rely on an investigation of what makes them tick intrinsically, and though *West Side Story* did not always do so to the greatest extent in HGO's performance, it did show a great amount of compositional craft that the world would be far worse off without.
