+++
author = ["authors/loren-lester.md"]
categories = "Review"
date = "2017-11-04T12:53:00-04:00"
lastmod = "2017-11-04T13:10:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1509814515258/2017-11-04---square---la-belle-et-la-bete-Josette-Day-and-Jean-Marais-in-Jean-Cocteaus-1946-film-2.jpg.jpg"
primary_image_credit = "Josette Day and Jean Marais in Jean Cocteau's 1946 film, La Belle et la Bête."
publishDate = "2017-11-04T12:57:00-04:00"
related_articles = ["articles/6-operas-to-creep-you-out.md","articles/a-refreshing-gateway-drug-the-magic-flute-at-o17.md","articles/in-review-bluebeards-castle-erwartung.md","articles/persona-and-the-sounds-of-silence.md"]
related_companies = ["scene/companies/los-angeles-opera.md"]
short_description = "Cocteau&#039;s haunting visuals are appropriate to watch on Halloween. At the 10/31 LA Opera production there was in fact a sell-out crowd. Many were dressed for the costume contest and party that followed (included in the price of admission) but this reviewer was extremely impressed to see a sell-out crowd in Los Angeles wildly applaud the combination of a vintage film and avant-garde opera."
slug = "belle-bete-la-opera-beauty"
title = "La Belle et la Bête at LA Opera is a beauty"
+++

Is it possible to take an existing masterpiece and make something equally aesthetic? In the world of fine art, Andy Warhol would say yes. But what about film? I'm not talking about an adaptation or a remake - in the case of great films, remakes seldom work. But composer Philip Glass had a truly unique idea of what to do with the magnificent 1946 Jean Cocteau film *La Belle et la Bête* (*Beauty and the Beast*). He took out the dialogue and music, and replaced it all with an original opera. Written over twenty years ago, the Philip Glass work just made its [LA Opera debut](https://www.laopera.org/season/1718-Season/Belle/) at the Theatre at Ace Hotel as part of the LA Opera Off Grand series. Off Grand, presented at various venues, is dedicated to exploring "unusual repertoire" as a kind of counterpoint to the more well-established operas chosen for the Dorothy Chandler Pavilion. 

Opera and film have enjoyed an occasional successful tango, the best of which are represented by the Franco Zefferelli films starring Placido Domingo. But the Jean Cocteau/Philip Glass take on *Beauty and the Beast* is a medium blend - a hybrid of the two art forms. The audience watches the classic Cocteau film while an ensemble of singers and musicians perform the modern Glass score live, synchronized to the film.

Movies and music have been inextricably linked since the advent of film. Silent films were never meant to be silent - from the beginning they were always accompanied by music, even if that meant nothing more than an out-of-tune piano at a nickelodeon. Over the years, many silent films have enjoyed the addition of musical soundtracks, some of which are nothing short of symphonic. (Ironically, the Theatre at Ace Hotel is actually the restored United Artists silent movie palace.)

Cocteau's beautiful black and white film is the perfect candidate for such an unusual evening's entertainment. No, this sure isn't a Walt Disney production, but it's the same basic plot as the Disney film: after a princely and bewitched Beast holds a beauty (Belle) against her will, the two develop a surprising romance. Without Disney, a happy ending this time doesn't seem likely. (Again, some irony here - Philip Glass wrote an opera about the death of Walt Disney.) 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1509814570625/2017-11-04---la-belle-et-la-bete-Josette-Day-and-Jean-Marais-in-Jean-Cocteaus-1946-film.jpg.jpg)
<figcaption>Josette Day and Jean Marais in Jean Cocteau's 1946 film, *La Belle et la Bête*.</figcaption>
</figure>

A man of the stage (as well as the cinema), Cocteau's sets and costumes look like they belong inside a proscenium arch. You never see an exterior of the Beast's chateau, and inside you seldom see any walls - the rooms exist in magical pools of light. It's all very theatrical: faces carved into the fireplace mantel come to life and eerily watch the action; disembodied arms holding candelabras are the only source of light in hallways; an armless hand serves wine at the dinner table. But no one sings anything like "Be Our Guest" - in fact there is a spooky silence from all the "servants" in the castle.

Over all this we hear the seven members of the Philip Glass Ensemble playing keyboards and woodwinds. Conductor Michael Riesman and his musicians are worthy of their reputation as experts when it comes to musical/visual events.

Four singers (mezzo-soprano Hai-Ting Chinn, soprano Marie Mascari, baritone Gregory Purnhagen, and baritone Peter Stewart) played all the roles standing at microphones, and honestly we forgot they were there for much of the time - a high compliment, as they were successful in convincing us that their stellar voices were emanating from the characters on the screen. And performances by the actors in the film are powerful even without the original soundtrack. In fact, we are rooting for the protagonists thanks in large part to the pathos of the Beast and the empathy of Belle, (played by Jean Marais and Josette Day, respectively). The couple is completely convincing even without their voices; their faces and especially their eyes tell the whole story.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1509814604737/2017-11-04---philip-glass_credit_steve-pyke.jpg.jpg)
<figcaption>Philip Glass. Photo: Steve Pyke.</figcaption>
</figure>
 
Philip Glass loves film and has composed many film scores. The music for this project is vintage Glass, marked by his signature repetition of notes or phrases. A two note pulse plays under almost all the action, creating an urgency that continually reminds us that time is running out for the would-be lovers. When the notes were played on a synthesized organ, the pulse actually sounded like a ticking clock. There's a particularly effective use of a saxophone which weaves in and out, highlighting the sadness and the loneliness of la Bête. 
 
Cocteau's haunting visuals are appropriate to watch on Halloween. At the 10/31 LA Opera production there was in fact a sell-out crowd. Many were dressed for the costume contest and party that followed (included in the price of admission) but this reviewer was extremely impressed to see a sell-out crowd in Los Angeles wildly applaud the combination of a vintage film and avant-garde opera. Kudos to LA Opera and Pomegranate Arts for such bold programming and for giving us a chance to see a work of art transformed into...well… a work of art.
