+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2017-01-17T14:44:00+00:00"
lastmod = "2017-02-06T16:20:00+00:00"
preamble = "There's a haunting combination of voice, cello, and electronics that makes *Dare Voce*, the new album by Olivia Salvadori and Sandro Mussida, stand out. [Salvadori](https://twitter.com/oliviasalvadori), the Italian classically-trained soprano and performing artist, collaborates with cellist, composer, and electronic producer [Mussida](https://twitter.com/sandromussida), in a \"ten-year long exploration of the voice.\"\n\n*Dare Voce* has an ancient feel, organically combining acoustic and electronic sounds, and musical styles from various corners of the globe. There's a simplicity inherent in the atmospheric songs that evokes the feeling of a live performance. \n\nSalvadori and Mussida chat about their latest collaborative project, and about leaving their mark in the tradition of Italian *bel canto*.\n\n*Dare Voce* is released on Sony Classical. You can get it on [iTunes](https://itunes.apple.com/gb/album/dare-voce/id1181090103) and [Amazon](https://www.amazon.com/Dare-Voce-Olivia-Salvadori/dp/B01N3JMO24%3FSubscriptionId%3D0NYB3SKF1S4GEN0AE182%26tag%3Da978b-20%26linkCode%3Dxm2%26camp%3D2025%26creative%3D165953%26creativeASIN%3DB01N3JMO24).\n\n"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1486383007555/2017-02-05---Sandro-Mussida-with-Olivia-Salvadori.jpg.jpg"
primary_image_credit = "Olivia Salvadori and Sandro Mussida."
publishDate = "2017-02-06T15:28:00+00:00"
related_articles = ["articles/album-review-all-who-wander.md","articles/in-review-pretty-yendes-debut-album-a-journey.md","articles/in-review-baby-kintyre.md"]
short_description = "&quot;We wanted to make a Songbook, a series of songs within the tradition of the Italian &#039;bel canto&#039;, but using a range of contemporary sounds at our disposal, for example, the electric and electronic. If you think about it, opera was once a part of popular culture... in Italy you can still go to the markets and find someone calling out with a Puccini tune!&quot;"
slug = "bel-canto-indeed-dare-voce"
title = "Bel canto indeed: &quot;Dare Voce&quot;"
+++

## How did you discover your combined aesthetic for *Dare Voce*?

We discovered the sounds for *Dare Voce* during the time we spent playing in Milan and during the making of the album itself. I used to join Sandro in his studio after my singing lessons and we would just play together and experiment, sharing our skills and musical tastes with complete freedom. Everything unfolded very naturally.

## How collaborative was the composition process? These pieces sound very organic in your voice.

Collaborative to the fullest. Sometimes we would start playing together and choosing at that precise moment a preferred rhythm and sound while I would sing a melody and from there we would elaborate and re-define the whole piece, as in "Free From The Eye". Other times I would have a melody ready to go as with "Respiro" and then be embraced by Sandro's arrangement or in the case of "Sirena" I would sing Sandro's written score and make it mine through the lyrics and interpretation. The point of departure was often a blank sheet of paper and a state of emptiness with no preconceived or crystallized ideas, but the will to find a possible balance between operatic vocality and different soundscapes. I think this explains why the voice sounds organic in these pieces; it was clear to us from the beginning that my voice would have been the unifying sound, the thread of Arianna.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1486383103748/2017-02-05---olivia-salvadori-sandro-mussida1.jpg.jpg)
<figcaption>Olivia Salvadori, soprano and performing artist, and Sandro Mussida, cellist, composer, and electronic producer.</figcaption>
</figure>

## What sort of balance did you search for between a classical sound and something more popular and mainstream?

We wanted to make a Songbook, a series of songs within the tradition of the Italian *bel canto*, but using a range of contemporary sounds at our disposal, for example, the electric and electronic. If you think about it, opera was once a part of popular culture... in Italy you can still go to the markets and find someone calling out with a Puccini tune! 

For me these songs have a natural drive that can be directed towards a mainstream public, as well as one that is more familiar with classical music and sound. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1486383113620/2017-02-05---Olivia-Salvadori-Live-2012.jpg.jpg)
<figcaption>Olivia Salvadori performing live, 2012.</figcaption>
</figure>

## What do you hope people enjoy about this album?

I would be honoured if I could energize the listener through the experience of the different sounds.  There's a desire for freedom here, for the courageous to be protagonists of our times rather than spectators, a desire to have faith in new spaces and places of beauty which can be shared. If any of this emerges and is appreciated by the listener, it would be a great gift for me and would provide me with the strength to proceed with even more passion.

<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1486397117889/2017-02-05---Dare-Voce-Cover.jpg.jpg)
</figure>
