+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2018-10-26T19:47:00-04:00"
lastmod = "2018-10-26T19:53:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1540597048713/sqBelCanto.jpg.jpg"
primary_image_credit = "l-r: Renée Fleming (photo: Andrew Eccles/Decca); Julianne Moore in Bel Canto (still courtesy of Pacific Northwest Pictures)."
publishDate = "2018-10-26T19:53:00-04:00"
related_articles = ["articles/diegetic-music-in-opera-3-ways-to-use-it.md"]
related_people = ["scene/people/renee-fleming.md"]
short_description = "The term diva has been somewhat hijacked in 21st-century North America; &quot;Mostly now, it means bad behaviour,&quot; Fleming admits. Still, the character of Roxane has qualities that are charmingly familiar to those in the opera industry. Her ease in high-profile social situations, her ability to articulate what she does and does not want, her general fearlessness - these are the qualities of people like Sondra Radvanovsky, Anna Netrebko, and of course, Fleming."
slug = "bel-canto-creating-a-diva"
title = "Bel Canto: creating a diva"
+++

She may be officially [retired](https://www.nytimes.com/2017/04/05/arts/music/the-diva-departs-renee-flemings-farewell-to-opera.html) from the opera stage, but no one can accuse Renée Fleming of slowing down. She has a new album out on Decca Records - the self-explanatory *Renée Fleming - Broadway!* - and she continues her role at Lyric Opera of Chicago as Creative Consultant. In fact, LOC has a [star-studded gala](https://www.lyricopera.org/concertstickets/calendar/2018-2019/renee-fleming-25th-anniversary-tickets?utm_source=Newsletter&utm_medium=email&utm_content=PRESS+RELEASE%3A+Lyric+Announces+Guest+Artists+for+Ren%C3%A9e+Fleming+25th+Anniversary+Concert&utm_campaign=1819+RF+concert) in store to celebrate 25 years of Fleming's "extraordinary commitment to Chicago and her unparalleled contributions to our art form."

Something new in Fleming's recent calendar has been her work in film scores. She has lent her voice to the soundtracks on *The Shape of Water*, *Three Billboards Outside Ebbing, Missouri*, and most prominently, *Bel Canto*. Based on the novel of the same name by Ann Patchett, Paul Weitz's *Bel Canto* is the story of an American soprano who gets pulled into a hostage situation when the party at which she is hired to perform is stormed by a terrorist organization. Julianne Moore plays the diva Roxane Coss - all but her voice.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1540597276763/DSC00219.jpg.jpg)
<figcaption>Julianne Moore in *Bel Canto* (still courtesy of Pacific Northwest Pictures).</figcaption>
</figure>

Essentially lip-syncing to Renée Fleming is no small task - especially considering the opinionated passion of the real-life American diva's fans. Moore worked with Fleming's long-time coach, Gerald Martin Moore, to understand the physicality of singing opera, and hopefully convince even the most nit-picky of opera fans in her portrayal. She does a pretty good job, one has to admit. (In fact, the only suspect bit is in the makeshift rehearsal pianist Roxane manages to find during her hostage stay; he does an all-too-fine job of playing a piano reduction of Villa-Lobos' *Bachianas Brasilieras* No. 5, and follows his singer like a pro.)

Yet as is often the case, a picture is worth a thousand words. "[Moore] sat in front of me when I recorded everything," says Fleming. "She had the ability to watch, up close and centre, what it really looks like." The actress also attended a rehearsal at Carnegie Hall for the annual Richard Tucker Gala. Fleming recalls her saying, "You have no idea how interesting this is, and how beautiful it is from television. You really have to experience it live, because every voice is different."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1540597448062/Renee_Fleming_-_Poemes_3_cropped__credit_Andrew_Eccles_Decca.jpg.jpg)
<figcaption>Renée Fleming. Photo: Andrew Eccles/Decca.</figcaption>
</figure>

Among the varied voices in today's opera scene, Fleming's is one of the most recognizable. Yet an interesting thing happens when her voice moves from the opera stage, and into the world of film. "The music is become another character," she says. "You would never know, for instance, that I was the same singer for *The Shape of Water* as for *Three Billboards Outside Ebbing, Missouri*." 

Ammong filmmakers and other artists in search of the right music to complement their work, Fleming sees a rising trend, that she attributes to the playlist culture of today. "I think that comes out of the Spotify playlist, frankly," she says. "People are finding it creative to put together interesting playlists and really utilizing music and artists who are off the beaten track."

*Bel Canto* in particular is a mirror not just of top-notch singing, but of the 21st-century opera diva. "[Patchett] is definitely channelling not just a classic diva, but a very American character," says Fleming. The fictional diva Roxane certainly shows flashes of stereotypical diva-isms - talking back to armed terrorists, crinkling her nose at the sandwich she's given to eat, and shoving away a megaphone before singing on a balcony. "I don't need that," Roxane says, appalled at the suggestion.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1540597456182/BC_DAY_020_0264.jpg.jpg)
<figcaption>Julianne Moore and Ken Watanabe in *Bel Canto* (still courtesy of Pacific Northwest Pictures).</figcaption>
</figure>

The term *diva* has been somewhat hijacked in 21st-century North America; "Mostly now, it means bad behaviour," Fleming admits. Still, the character of Roxane has qualities that are charmingly familiar to those in the opera industry. Her ease in high-profile social situations, her ability to articulate what she does and does not want, her general fearlessness - these are the qualities of people like Sondra Radvanovsky, Anna Netrebko, and of course, Fleming.

"I love that about the book," says Fleming of *Bel Canto*'s moments of uncanny storytelling. "Ann has that ability to channel worlds, people, lives, that she personally has no experience with."

<figure data-type="video">
<iframe width="1280" height="720" src="https://www.youtube.com/embed/dBIQ0KFGn8M" frameborder="0" allow="autoplay; encrypted-media" allowfullscreen></iframe>
</figure>

>*Bel Canto* comes to Canadian theatres starting October 26.
