+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2016-06-15T22:51:00-06:00"
lastmod = "2016-06-22T11:15:00-06:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1466561457461/2016-06-22---Art-Matters.jpg.jpg"
publishDate = "2016-06-22T01:11:00-06:00"
related_articles = ["articles/in-review-quinn-kelseys-songs-from-the-heart.md","articles/forgiving-racism-onstage.md","articles/ian-smith-of-the-emc-we-unite-through-the-common-language-of-music.md","articles/heavy-scenes-the-fast-lane-to-a-great-rehearsal-room.md"]
short_description = "Ignorance like this is the real reason why art matters. Fixing this kind of problem is a more important and more universal benefit of the arts, moreso than honing your fine motor skills or learning a foreign language. Without the arts, people are left with an alarmingly low chance of understanding the world which they share with others."
slug = "being-a-nice-person-why-art-really-really-matters"
title = "Being a nice person: why art really, really matters"
+++

This month's [massacre of 49 people](http://www.cnn.com/2016/06/12/us/orlando-nightclub-shooting/) inside an Orlando gay club was the latest example of what ignorant, small-minded people living in small worlds can do with access to weapons. The shooter, Omar Mateen, had his own reasons for killing innocents, but whatever those reasons were, none of them were good or excusable. Though the details may vary, each case of violence against a group of people, apparently defined only by their sexual preferences or race or religion, is fueled by ignorance. Ignorance of this sort isn't benevolent at all; it results in some horrible, violent human who can't grasp the concept of a life lived differently than their own, and who takes their uninformed hate out on others.

Ignorance like this is the real reason why art matters. Fixing this kind of problem is a more important and more universal benefit of the arts, moreso than honing your fine motor skills or learning a foreign language. Without the arts, people are left with an alarmingly low chance of understanding the world which they share with others.

Exposure to the arts, be it as an eager consumer or as an inspired creator, puts under a microscope three big concepts that resist against violence and hate:

## Understanding villains

A villain is a relative thing; while most *Harry Potter* readers agree that Voldemort is a solid bad guy, Voldemort himself would find a villain in Harry. 

It doesn't mean that Voldemort and Harry have equally legitimate reasons for hating each other, but without understanding that hatred is largely about perspective, J.K. Rowlings' point about good and evil is entirely lost.

Theatre and opera give people the chance to pretend at being villains, and by extension, to understand them. What makes villains the most hateful is knowing that they think they're the good guy. Bad guys don't wake up and decide to be bad; they wake up and, like the rest of us, try to do what they think is right. That's why they're terrifying, and it's why the best villains are almost endearing. Theatre teaches us that bad guys are rarely sadistic robots, but full humans, with real motivation and reasoning behind their actions.

When someone massacres people at a gay bar, presumably *because* they're gay, they do it because they think they're righting some wrong. Similarly, no one convinces suicide bombers to blow up themselves and others by telling them to do an evil thing; they convince people to do it by telling them they're doing a good thing. They can't even be accused of lying, because they likely believe what they're teaching. 

It doesn't mean that the villains of real life should be excused of punishment; but understanding the "benevolent" motivation behind abhorrent behaviour is the only way to avoid an endless back-and-forth of an eye for an eye, which only means more and more people wil be hurt.

Maybe a violent bigot who sees the villains in his own life in the guise of the LGBT community, or anyone who isn't white, or every single Muslim person, could apply the same understanding. If Omar Mateen thought gay people were his villains, fine; but his killing 49 of them was the equivalent of taking an eye for an eye. Privately held bigotry isn't great, but at least no one can die from that alone.

## Getting to know LGBT people

In the world of theatre and music, there is a higher proportion of queer people who are comfortably out. Maybe it's not much higher than in other circles, but it's a given that if you work in the arts, or even simply consume a lot of art, you're interacting with a decent number of LGBT folks.

It sounds crass, maybe, and over-simplified; but frankly, the arts offers the opportunity to get to know queer people as individuals, and not just a faceless population. If you embrace the arts, you embrace the people that create it; if you're paying attention, you'll realize that there's more to a gay person than being gay. They make things, do things, they are people with opinions and aesthetics and ideas. 

It's harder to hate the thing you know than to hate the thing you don't.

## Not throwing the baby out with the bathwater

We'll focus more on opera for this one, but there are no doubt examples from all artistic disciplines. Operas like *Madama Butterfly*, *Lakmé*, *The Mikado*, and *Carmen* fall under the broad idea of "exoticism". Today, it's a little cringe-inducing to hear all those pentatonic scales in *Turandot* and *Butterfly*, or to meet characters named Yum-Yum, or to be inundated with that all-too-obvious harmonic minor motif (read: "Spanish") throughout *Carmen*. Today, plenty of people would apply to these operas terms like "cultural appropriation" or even "racism". They may not be wrong, but they'd be missing the point.

Maybe Puccini had a Western-centric view of Japan, and maybe Bizet made a slight mockery of Spanish dances by awkwardly setting them to a French libretto like a square peg in a round hole. But the stories that inspire these dubious details deserve survival. "Angry Moors" aside, Otello isn't the only guy who has suffered manipulation and lies. *Carmen* isn't simply about a woman getting the come-uppance for being a gypsy; it's about men with baggage, and women fighting for freedom.

The arts teaches us about shades of grey. Like works of art or big ideas, a person shouldn't be dismissed or deemed useless because they come with flaws. Seeing shades of grey, instead of black and white, comes in handy when it's time to sift through the mess that is a two-party election, or when you have to learn to play well with others.

***
Frankly, the arts make us better people. Operas, paintings, poems, they all let us see the world through the eyes of others; consuming art is like a social passport. It doesn't mean we need to agree with the sentiment behind every song lyric or every character trait, and even that is a larger point. 

We can learn to listen and not talk back, to look and not judge, to inquire and not react.
