+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2016-11-14T14:53:00+00:00"
lastmod = "2016-12-02T10:51:00+00:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1480605865859/2016-12-1---Hands.jpg.jpg"
publishDate = "2016-12-02T10:37:00+00:00"
short_description = "Our theory is that there&#039;s more nature than nurture in each pianist&#039;s preferred page-turning hand. For us, it&#039;s our left, because we find ease in a motion across the body, towards the bottom-right corner of the page; in turning the page, our left hand retracts swiftly back into playing position."
slug = "being-a-helpful-pianist-which-is-your-page-turning-hand"
title = "Being a helpful pianist: which is your page-turning hand?"

+++
Even though pianists can boast some level of extraordinary abilities when it comes to being ambidextrous, we too are subject to our natural tendencies to favour our right or left hand.

Let's set aside for a moment what our limb-favouring means for our technique at the piano. Instead, let's focus for a moment on that other tangential art to being a pianist - in particular, a pianist who works with singers - turning pages.

Our theory is that there's more nature than nurture in each pianist's preferred page-turning hand. For us, it's our left, because we find ease in a motion across the body, towards the bottom-right corner of the page; in turning the page, our left hand retracts swiftly back into playing position.

Other pianists like to turn pages with their right hand, simply because there's less distance to travel. 

Really, deciding how to turn pages is just [another decision that pianists have to make](/the-opera-pianists-list-o-priorities/) while they're playing a rehearsal, coaching, or even an audition. There's a time for one's left hand, and a time for one's right. 

You're correct, some examples *would* be helpful. 

## Team *destra*

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1480609472109/2016-12-1---Page-turn---Verdi-annotated.jpg.jpg)</figure>

This is a little snippet from one of the Duke of Mantua's arias from Verdi's *Rigoletto*. The page-turn (shown with dotten lines) happens right after the abruptly hyphenated, "il serto mio da-(rei)", and continues at "-rei per consolar quel cor"; here, it's a pretty clear example of prioritizing which hand can afford a short hiatus from the piano, and sacrifice its music for the sake of turning a page. 

The left hand is busy keeping the harmony, rhythmic pulse, and general flow of this part of the aria, and the right hand is simply adding light context to the voice line; it's likely that while the Duke is singing away, those right hand notes will be inaudible.

So, it's an easy choice: keep your left hand on the keys, and **turn the page with *la mano destra***.

## Team *sinistra*

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1480609517036/2016-12-1---Page-turn---Rigoletto-annotated.jpg.jpg)</figure>

From the same opera, here's Rigoletto's beautiful, raging outburst, "Cortigiani, vil razza dannata". Except in the middle of "dannata," there's a...[*dannata*](https://translate.google.ca/#it/en/dannata) page turn (sorry), shown again by the dotted lines. The orchestration is so great here, and it really is a shame to sacrifice anything\*; but if you look closely at this particular spot, the right hand is more vital than the left. The left hand is mostly giving us the broad harmonic progression with those angry bass notes; the right is playing the violin pattern (a rage motive, if you will) that guides the whole thing forward. 

Though the bass notes are important, they're quite non-descript, almost unhelpful without the rhythmic drive of what's in the right hand. Our vote: **turn this page with your left hand**, and keep that rage-motive continuing into the next measures (shown below)

\*Pro tip: since these two bars above are the last ones on their page, and there's a big pause that happens right before them, why not memorize the two bars and turn the page ahead of time? No sacrifice necessary.

## Team *destra*

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1480609546911/2016-12-1---Page-turn---Semele-annotated.jpg.jpg)</figure>

Handel arias can be a handful (hah!), and this fast-paced bit from *Semele* is a great example of rhythm and harmony taking seniority. Semele sings some zippy coloratura that continues over the page (shown below), and there's no time for the pianist to get bogged down in a page-turn. During coloratura licks like these, singers need support from their pianists in the form of a steady tempo and a clear harmonic progression.

Make your life - and your caffeinated soprano's life - simple by keeping your left hand confidently on the keys, and (quickly!) **turning this page with your right hand**.

## Team *destra*

<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1480611988408/2016-12-1---Page-turn---Boheme-duet-1-annotated.jpg.jpg)
</figure>

The right hand has the tune here, no doubt. Yet once Mimì joins in at "Sempre tua," it's a safe option for your right hand to switch over to page-turning duty. What's really important to keep are the chords under "tua" and then "vita" on the next page; you can do all of that with the left hand, which should give you plenty of time to **turn the page with your right**, before playing the little staccato echo in the first bar of the second line.

## Team *sinistra*

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1480613072986/2016-12-1---Page-turn---Boheme-2---annotated-.jpg.jpg)
</figure>

Ricordi sure is a jerk for putting a page turn here, in the middle of a big chromatic clarinet solo. We won't say that the moving chords in the left hand aren't important, but in that bar before the page turn, it's clear that the chromatic scale is what Puccini wants us to hear, and it's what propels the bar forward to "O buon Marcello". Without hearing that clarinet solo, it's musch more jarring to the singers than leaving out the left hand chords. 

So, after you give us the low B-flat on the downbeat, **use your *mano sinistra* to turn the page** while your right hand takes on the clarinet solo.

>Pianists, what are your page-turning tips? Leave them in the comments below, or get in touch at [hello@schmopera.com.](mailto:hello@schmopera.com)