+++
author = ["authors/sam-darling.md"]
categories = "Review"
date = 2020-03-03T05:00:00Z
disclaimer = ""
image_gallery = []
postamble = "The VAM Symphony Orchestra performance line-up is available [on their website](https://vancouveracademyofmusic.com/events/vamso-orpheum-series/)."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1583202618/media/2020/03/sqVAMSO-LindsayElliottPhotography_xynrf2.jpg"
primary_image_credit = "Photo: Lindsay Elliott Photography."
related_articles = ["articles/the-coughing-phenomenon.md", "articles/concert-etiquette-or-put-down-your-phone.md"]
related_companies = []
related_people = []
short_description = "Under the assured baton of conductor emeritus Leslie Dala, the program brought together the young professional-level orchestra with the veteran vocals of amateur Vancouver Bach Choir, along with four professional soloists, and featured a delightful performance of Concerto No. 4 by Ian Parker at the keys"
slug = "an-enduring-beethovens-ninth-with-the-vancouver-academy-of-music"
title = "An enduring Beethoven's Ninth with the Vancouver Academy of Music"
youtube_url = ""

+++
Vancouver Academy of Music celebrated its 50th-anniversary [season](https://vancouveracademyofmusic.com/events/vamso-orpheum-series/) with a special presentation in honour of late maestro Ludwig van Beethoven in the year of his sestercentennial with the program _Resounding Joy: Beethoven’s Ninth Symphony_ at the Orpheum Theatre.

Under the assured baton of conductor emeritus [Leslie Dala](http://www.lesliedala.com/about/), the program brought together the young professional-level orchestra with the veteran vocals of amateur Vancouver Bach Choir, along with four professional soloists, and featured a delightful performance of Concerto No. 4 by [Ian Parker](http://www.ianparker.ca/) at the keys. A merging of such varied talents sometimes achieved Beethoven’s vision but more often didn’t gel quite as well as the sum of its beautiful parts.

These Beethoven works are a common sound in our pop culture; Symphony No. 9's few famous measures in particular are now a ditty even the least music-savvy person will recognize. It is a work rarely staged due to the required size of the participants – sheer scale intended to convey grandeur and awe to the audience. In this staging the strings were sometimes a bit overwhelmed by other sections. This was an issue in the piano concerto in particular as Beethoven’s almost modern sense of sudden shifting dynamics couldn’t pop as it should with the sections not balanced and the brass sometimes entering the piece with hesitancy. Parker’s peppy performance would often save the orchestra by him attacking the molto vivace passages with a ferocity and joy that carried along both the audience and the participants. His full expressive performance seemed to be flawless to my ear but I must admit I was distracted.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1583258905/media/2020/03/VAMCollage-DalaParker_vdf2rg.jpg){{% /md %}}

<figcaption>(l-r) Leslie Dala, conductor, and Ian Parker, pianist.</figcaption>

</figure>

A word now on the audience, which is not something I would normally mention. Rarely have I thought the audience was amateur in comparison to a performance, but seated in the center of the theater I had a snoring woman to my left, a wrapper-crinkler to my right, and chatterers all around me. Throughout the show you could hear moments of “shhh!” pop up around the theatre, so I believe I was not the only one suffering the indignities of self-absorbed audience behavior. At one point, a woman behind me in the audience took a mobile phone call in the middle of the concert, and then proceeding to ignore everyone’s pleas to silence herself. And I lost count of the number of cell phone rings that went off in the audience but at least those were mercifully left unanswered or quickly silenced.

The concert was played to a packed house, which should have been heartening, but when so many people are making noise it leads to less-than-ideal listening conditions. Beethoven’s music depends as much on silences as it does on grand bombast; in order to transition from silky adagio to tremendous sound there must be uninterrupted silences.

> It is a testament to Beethoven’s enduring artistry and talent that despite all of my gripes I still enjoyed the performance.

And yet, at the end of the performance, this same audience gave a standing ovation to a very fine performance that I promise you did not merit it. Vancouver, please do better. This was only my second time seeing these works staged live and I was hoping for full immersion into the "Ode to Joy", but as you can surmise, transcendence was difficult to achieve under the circumstances.

The combined talent on stage did an admirable job with difficult works and showed more precise control and balance between sections in the second half. Soloists do not get a lot to sing in this work. Three of the four singers looked out to the audience and smiled, engaging us in enjoyment. [Martin Renner Wallace](https://martinrw.ca/)’s tenor and [Leah Giselle Field](https://leahgisellefield.com/)’s mezzo stood out as most suitable for cutting through the big sound of the orchestra and large choir.

It is a testament to Beethoven’s enduring artistry and talent that despite all of my gripes I still enjoyed the performance. The Bach Choir was good fun when they were able to unleash their full sound and the orchestra leaned into the whiz-bang fireworks nature of the final piece. There’s a reason why Beethoven is a favorite for musicians as it requires both technical prowess and a sense of movement and fun that music of his era sometimes lacked. It is always a pleasure to see musicians enjoying their craft and doing it well.