+++
author = ["authors/andrew-schneider.md"]
categories = "Review"
date = "2018-05-01T21:39:00-04:00"
lastmod = "2018-05-01T21:47:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1525224744278/sqhgo---norma---photographer-lynn-lane-50-3000x2000.jpg.jpg"
primary_image_credit = "Jamie Barton (Adalgisa) in Norma, Houston Grand Opera, 2018. Photo: Lynn Lane."
publishDate = "2018-05-01T21:47:00-04:00"
related_companies = ["scene/companies/houston-grand-opera.md"]
related_people = ["scene/people/liudmyla-monastyrska.md","scene/people/jamie-barton.md","scene/people/chad-shelton.md"]
short_description = "However, in spite of all the great music, I got a sense that the company radiated severe apathy about the sheer task of putting on &quot;yet another grand opera like this one because it is a classic which is, however, very boring.&quot; Combined with this aura, I got the sense that this production was blessed with a great many artists who only just failed, in their combined efforts, to make this production truly take off and maintain altitude."
slug = "bashful-bel-canto-norma-in-houston"
title = "Bashful bel canto: Norma in Houston"
+++

The island of Sicily has given to the world many important personages: Diodorus Siculus, Sigismondo d'India, Luigi Pirandello, Alessandro Scarlatti, Vittorio Orlando, Giovanni Verga, Giovanni Pacini, and, famously, Archimedes. It will be evident to those reading that I have left off this list the person who is, of course, my favorite Sicilian by far, Vincenzo Bellini. Certainly, as he has had his face on the Italian Republic's 5000 lira note, I should hope that my regard of this composer's craft is justified. After all, who am I to contradict Chopin's preferences?

Houston Grand Opera certainly attempted to make the case for this great Sicilian's *Norma*, a production for which I was justly excited, particularly given my familiarity with his eccentric, even Beethovenian use of harmony at several places. And the design of the set, which was relatively traditional compared to lots of the ones I have seen these days, with its use of bovine idols and distant mists, was quite calculated to evoke a sense of the otherworldly and nostalgic; indeed, as a corvine intruder flew in from the top of the stage, I actually got a sense that this production might be thoroughly impressive. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1525224828872/hgo---norma---photographer-lynn-lane-102-3000x2000.jpg.jpg)
<figcaption>Peixin Chen (Oroveso) and the HGO Chorus in *Norma*, Houston Grand Opera, 2018. Photo: Lynn Lane.</figcaption>
</figure>

However, in spite of all the great music, I got a sense that the company radiated severe apathy about the sheer task of putting on "yet another grand opera like this one because it is a classic which is, however, very boring." Combined with this aura, I got the sense that this production was blessed with a great many artists who only just failed, in their combined efforts, to make this production truly take off and maintain altitude.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1525224846817/hgo---norma---photographer-lynn-lane-57-3000x2000.jpg.jpg)
<figcaption>Liudmyla Monastyrska (Norma) and Jamie Barton (Adalgisa) in *Norma*, Houston Grand Opera, 2018. Photo: Lynn Lane.</figcaption>
</figure>

Throughout, Norma ([Liudmyla Monastyrska](/scene/people/liudmyla-monastyrska/)) showed herself entirely capable of maintaining the dignified posture that a tragic heroine like herself needs to effectively convey the multifaceted aspects of the Druid high priestess; her acting was based on gestures which remind one of the old French theatrical tradition on which Felice Romani's libretto is based. There could have been more contrast, however, in the more intimate scenes, particularly those involving her children. Her reserve, however, went a bit far when it came to singing. I enjoyed her pristine take on "Casta diva", certainly, which showed great use of breath control, but I got the sense that it would have been more opportune in a smaller theater, rather than in the Resilience Theater that has been used this season. Moreover, it highlighted the production's desire to not expend excessive energy in the beginning, a risky strategy at the best of times. "Deh, non volerli vittime", showed her at her very most compelling in the evening, as she clearly understood well how to thread Bellini's trademark ductile lines which we composers envy for their effortless versatility.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1525224900177/hgo---norma---photographer-lynn-lane-139-3000x2000.jpg.jpg)
<figcaption>Peixin Chen (Oroveso) and Liudmyla Monastyrska (Norma) in *Norma*, Houston Grand Opera, 2018. Photo: Lynn Lane.</figcaption>
</figure>

Ever since Bellini made a splash with *Il pirata*, bel canto opera routinely delighted in using self-destructive, adventurous Byronic characters whom parents would not want their children to take home, and Pollione is no exception. Tenor [Chad Shelton](/scene/people/chad-shelton/), as Pollione, showed himself to be especially focused on his character's development, at the regrettable cost of his declamation and vocalism. "Me protegge, me difende", was his one strong point, though even that showed less than a full vocal commitment. During his duet with Adalgisa (Jamie Barton), mirroring Bellini's agitated music which goes into many harmonically adventurous, yet unstable places, he could be seen pacing aimlessly around the stage, avoiding Adalgisa, but I found this to be more distracting than profound. His voice was also relatively stifled, sometimes muffled, during dramatic exchanges with other characters. This may well have been a dramatic choice to highlight Pollione's extreme sense of self-loathing and guilt, but I found it to get in the way of the tragic drama; in other words, it disrupted my focus.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1525224937563/hgo---norma---photographer-lynn-lane-9-3000x2000.jpg.jpg)
<figcaption>Yongzhao Yu (Flavio) and Chad Shelton (Pollione) in *Norma*, Houston Grand Opera, 2018. Photo: Lynn Lane.</figcaption>
</figure>

As Adalgisa, [Jamie Barton](/scene/people/jamie-barton/) showed her versatility in several registers of her voice, but most particularly the upper octave. It is exactly this trait that showcases how calling Adalgisa just another mezzo role is not telling the whole story; those of us who first encountered the role through the Orchestra La Scintilla recording will understand perfectly to what I refer. In general, Barton was the most dynamic actress of the bunch, displaying her internal conflict especially vividly and melodramatically. (I use the latter word in the context that makes for masterful Mexican cinema.) This production was notable for having her appearing in crowd scenes, even though the libretto does not specifically call for her to do so; I suspect that this was done to make her role in the community of Druids more visible generally. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1525224984768/hgo---norma---photographer-lynn-lane-22-3000x2000.jpg.jpg)
<figcaption>Liudmyla Monastyrska (Norma) in *Norma*, Houston Grand Opera, 2018. Photo: Lynn Lane.</figcaption>
</figure>

As Oroveso, [Peixin Chen](/scene/people/peixin-chen/) was possessed of a strongly authoritative voice and radiated dignity throughout, without being overly cumbersome. Yelena Dyachek in the role of Clotilde displayed a sympathetic and maternal air, combined with not excessively declamatory vocalism. Yongzhao Yu as Flavio showed himself to be dignified and patient with his commander Pollione's masochistic ravings, all the while sneaking in the occasional anguished grimace to signal that he is more than a mere spear-carrier. Clearly, his superior's self-indulgent narrations cause him to relive them, perhaps giving the audience an insight into "How many times has Pollione said these things?"

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1525225095715/hgo---norma---photographer-lynn-lane-80-3000x2000.jpg.jpg)
<figcaption>Liudmyla Monastyrska (Norma) and HGO Supernumeraries in *Norma*, Houston Grand Opera, 2018. Photo: Lynn Lane.</figcaption>
</figure>

The Houston Grand Opera Chorus was a mixed bag when it came to this production. While they showed trademark coordination, their sound seemed, as if a theme, to lack focus. Indeed, I had first come to know this opera through the treacherously seductive transcription that Liszt made of it, in which the superb choral numbers are the main focus. However, these were delivered with less vim and vigor, or even momentum, than one might be entitled to expect, and, with the exception of "Guerra" (during which the enormous pyre is rolled in, of taurine shape, to await its sacrificial victim), they all assumed a rather languid and melancholy tone inconsistent with their dramatic situation; I have known this ensemble to be capable of far more dynamic results than were on view here.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1525225090659/hgo---norma---photographer-lynn-lane-16-3000x2000.jpg.jpg)
<figcaption>The HGO Chorus in *Norma*, Houston Grand Opera, 2018. Photo: Lynn Lane.</figcaption>
</figure>

Nor was the orchestra, placed at the side this time around, as responsive as could be desired, despite Artistic Director Patrick Summers's histrionic gestures; in particular, the leggiero passages demanded of the strings were very difficult to keep lively in the cavernous space of the Resilience Theatre. The winds and brass were very much in top form, though I sensed that the strings were routinely apprehensive about overpowering them, when often the reverse ended up being the case. Still, this was a case of the orchestra gradually getting more able of achieving dynamic contrast over time, particularly in small ensembles: throughout, the focus was on monochromatic blocks of sound, rather than dynamic arcs that allow otherwise simple harmonic accompaniments to work alongside a singer, rather than merely to be subservient to said. However, the offstage banda, led by Geoff Loff, had its own atmosphere that was allowed to contrast with the orchestra very effectively. 

My overall impression, therefore, is that this production as a whole seems to have surrendered to the self-defeating notion that bel canto opera is "formulaic and therefore necessarily boring". The word that I would use of the production as a whole would fall somewhere between "disingenuous" and "anodyne", but Bellini keeps this production from being soporific. However, to combat this notion, I solemnly promise that I shall endeavour to learn the masterful and forceful transcription Liszt made of this work, so that Houston might more readily know why I love it so much.

>Houston Grand Opera's production of *Norma* runs through May 11. For details and tickets, [click here.](https://www.houstongrandopera.org/norma)
