+++
author = ["authors/john-hohmann.md"]
categories = "Review"
date = 2023-05-17T03:00:00Z
disclaimer = ""
image_gallery = []
postamble = "Coming up on the Recital Series is the compelling American soprano Julia Bullock, September 11 & 13. UK based mezzo-soprano, Kate Lindsey, who wowed audiences in the title role of Olga Neuwrith's Orlando at the Vienna State Opera ([reviewed here](https://www.schmopera.com/orlando-gender-bending-and-the-sound-of-androgyny-in-vienna/) in April, 2020) follows on October 16 & 17. Jonas Kaufmann comes to the Wade Thompson Drill Hall in the Armory commissioned Doppelgänger, a staged theatrical event/art installation based on Schubert's Schwanengesang September 26 through 28. For ticket information: Armoryonpark.org."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1684464940/sqStephaneDegout.jpg"
primary_image_credit = "Baritone Stéphane Degout in recital in Park Avenue Armory's Board of Officers Room. Photo by Alexander Sargent, courtesy of Park Avenue Armory."
related_articles = ["articles/michael-spyres-the-baritenor-difficult-to-compartmentalize-but-spectacular-85-min-listen.md", "articles/eden-stuns-and-the-astonishing-joyce-didonato-is-out-to-save-the-world.md"]
related_companies = []
related_people = []
short_description = "Puccini considered Suor Angelica his favorite work; it was also his most personal, inspired by his sister who was an actual nun. The music is all pleasingly lyrical but it's all a slow set-up for the eventual entrance of La Zia Principessa (as mentioned, portrayed here by the highly talented Ms. Lewis.)"
slug = "baritone-stephane-degout-triumphs-in-the-park-avenue-armorys-board-of-officers-room"
title = "Baritone Stéphane Degout triumphs in the Park Avenue Armory's Board Of Officers Room"
youtube_url = ""

+++
Hearing Stéphane Degout in the Park Avenue Armory's baronial Board of Officers Room was to witness the exquisite union of voice and environment. The French baritone's sonorous voice, at once majestic and warm, and the extraordinarily supportive accompaniment of pianist Cédric Tiberghien, produced a performance of musical and emotional commitment that might not have availed itself so fully outside the Armory's salon-like setting.

With his ruminative demeanor Degout could easily be taken for a singer devoted solely to song recitals, but he balances a flourishing international career on the operatic stage as well. His roles including Figaro's Count Almaviva, Pelléas in _Pelléas et Mélisande_ and most recently the title role in _Wozzeck_ signal not only vocal dexterity but an ability to create richly drawn characters. To the Armory he brought these talents along with a refreshing humanity that were expertly tailored to the recital featuring works by Schubert, Fauré, Berg, Ravel and Debussy. 

Schubert found that delicate balance between words and music that hadn't been a priority of predecessors like Haydn and Mozart. Degout injected a modern, indeed empathetic sensibility into the composer's sustained melancholy. Opening with _Der Wanderer_ with text by Georg Lübek, the songs would profile the endless aspects of misery with nary a trace of relief and then only in a delusional or isolated state. Degout found the fleeting irony in the first verse of Johann Wolfgang von Goethe's _Schaffer's Klagelied_ when the shepherd reminisces about the valley he is gazing upon before he confesses to his flock of sheep that he is in a wretched state. Tiberghien accompanied the shepherd's descent with similarly intensified playing. Degout closed the Schubert with Matthäus von Collin's subtly provocative verse _Nacht und Träume_, sung so beautifully and with such fervor that it was tempting to ignore the truth of it and simply glide, however sadly, on its thwarted romance.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1684464941/StephaneDegout_Cedric.jpg){{% /md %}}

<figcaption>Pianist Cédric Tiberghien in Park Avenue Armory's Board of Officers Room. Photo by Alexander Sargent, courtesy of Park Avenue Armory.</figcaption>
</figure>

The French composers, amidst personal and professional relationships and rivalries, managed to establish their own distinct sound. Fauré, a dexterous composer who worked with the florid poetry of La Baronne Antoine de Brimont and the brisk verse of Charles Grandmougin, played a major role in the process. His compositions evoked fundamental but internalized emotions and eschewed the pervasive isolation common to Schubert's choice of poets.

There was a remarkable transformation in Degout's voice as he launched into the Fauré's cycle, _Mirages_. From his stolid resolve in the Schubert emerged a hint of air in the voice producing a languid and finely grained sound that mitigated Brimont's rather lush imagery. Rapid-fire shape shifting marked Fauré's setting of Grandmougin's Poéme d'un jour in which a man meets the love of his life, is rejected and bids farewell, all in three short, neatly delineated songs.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1684464940/Stephane-degout_cedric-tiberghien.jpg){{% /md %}}

<figcaption>Baritone Stéphane Degout and pianist Cédric Tiberghien. Photo JB Millot.</figcaption>
</figure>

Debussy and Ravel were another matter altogether. Debussy treated poetry, to point Chansons de France with text by Charles d'Orleans, as little more than spoken word while creating moody and cascading undercurrents. Ravel, fond of sourcing material from other cultures, wrote two arrangements for Jewish melodies, _Kaddisch_ a solemn prayer and _L'énigne éternelle_, a seemingly light-hearted song that offers a foundational spiritual message, both from anonymous sources. Degout's interpretative prowess and his superb diction created vivid sound pictures in the Debussy as Tiberghien displayed his own deep identification with the music and superb technique. Degout provided nuanced and culturally sensitive readings in Aramaic and Yiddish respectively to the Ravel while Tiberghien captured their spiritual intentions and flavor.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1684464941/StephaneDegout_Cedric_wideshot.jpg){{% /md %}}

<figcaption>Baritone Stéphane Degout singing Vier Gesänge by Alban Berg accompanied by pianist Cédric Tiberghienin at the Park Avenue Armory's Board of Officers Room. Photo by Alexander Sargent, courtesy of Park Avenue Armory. </figcaption>
</figure>

Until Berg appeared in Degout's recital German lied and French art songs shared a certain penchant for self-absorption. This mainstay of the Second Viennese School awakened new expressionistic possibilities, replacing reflection with anguished proclamation. The baritone captured Berg's burgeoning abstraction in voice and in physical posture, tilting his body towards the piano as if to confront the instability of the ground beneath him and acknowledge the uncertainty of existence. In the process he offered hints of his triumphant Wozzeck at Théâtre du Capitole de Toulouse. Launching into _Schlafen, Schlafen_, with text by Christian Hobbel, the first of Berg's _Vier Gesänge_, Degout vocalized to the concept of sleep as escape. Two additional "sleep" songs with text by Alfred Mombert, each more restive and resigned than restful, and lastly another Mombert text, _Warm die Lüfte_ in which Degout harnessed its theatricality, romance and haunting paradox.

We want to hear more from Degout who was so at home in the Armory's Board of Officer's Room.
