+++
author = ["authors/john-hohmann.md"]
categories = "Review"
date = "2024-12-30T00:00:00-00:00"
lastmod = "2024-12-30T00:00:00-00:00"
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1735584415/sqHannigan_2.jpg"
primary_image_credit = "Soprano Barbara Hannigan in recital at the Park Avenue Armory. Photo: Stephanie Berger Photography, courtesy of Park Avenue Armory."
publishDate = "2024-12-30T00:00:00-00:00"
related_articles = ["articles/hannigan.md", "articles/michael-spyres-at-the-park-avenue-armory-big-voice-in-an-intimate-room.md"]
related_people = ["scene/people/barbara-hannigan.md"]
related_companies = [""]
short_description = "Hannigan, as the musical world knows, divides her time between singing and conducting, a second and impressive discipline that it seems is never far away from her singing."
slug = "barbara-hannigan-and-bertrand-chamayou-at-the-armory-the-only-place-to-be"
title = "Barbara Hannigan and Bertrand Chamayou at the Armory: the only place to be"

+++
In New York, a city bursting with musical choices, the only place to be on a recent Thursday evening was the Park Avenue Armory. In the salon-like setting of its newly restored Veterans Room the extraordinary Canadian soprano (and conductor) Barbara Hannigan, accompanied by esteemed pianist Frenchman Bertrand Chamayou, presented a breathtaking program of works by Olivier Messiaen, Alexander Scriabin and John Zorn.

The evening was at its core a revelatory musical adventure. Marked by intellectual aspirations of the highest order, it offered one brilliant musical coup de théâtre after another. And throughout it maintained an aura of thrilling spontaneity. Messiaen's "Songs of Earth and Heaven" opened the program, a six-song cycle set to his own text and written after the birth of his son. It employs a harmonic language steeped in teeming cords and interchanging pitches. The demanding vocal line requires power in the upper register as well as flexibility and expressivity across the entire vocal range. Hannigan, looking goddess-like in a dark flowing gown, complimented by the opulent hues of the room, summoned almost superhuman vocal prowess as she journeyed through this passionate, religious and mystical cycle. In the final song her "Alleluias" evoked something of a Gregorian chant, albeit a Messianic one. The
audience was enthralled and Hannigan appeared to be genuinely exhilarated by the cycle's end. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1735584413/Hannigan_1.jpg){{% /md %}}
<figcaption>Soprano Barbara Hannigan and pianist Bertrand Chamayou perform John Zorn's Jumalattaret in the Veterans Room at the Park Avenue Armory. Photo: Stephanie Berger Photography, courtesy of Park Avenue Armory.</figcaption>
</figure>

The piano score is no less demanding than the vocal line. Chamayou's technical acuity enabling his moves between the boldly atonal and nuanced minimalist accompaniment, created and sustained a supporting framework for this amorphous piece. Chamayou has achieved global renown on the concert stage and garnered international awards for his recordings, notably Ravel's complete works for solo piano and Saint-Saëns' Piano Concertos No. 2 and No. 5. Mindful of his most recent recording, pairing the works of two idiosyncratic composers, Eric Satie and John Cage, I eagerly awaited his take on two works by Scriabin representing his transitional period and emerging atonality.

It is fair to say that Chamayou brings to mind French filmmaker, Francois Truffaut and by extension Charles Aznavour in the New Wave master's _Shoot the Piano Player_. What emerges from his deft and compact demeanor is an intense focus, nothing showy here, simply a relentless and unfaltering concentration. Chamayou captures the sensual and intriguing atmosphere of Poem-Nocturne op. 61, replete with its textures reminiscent of Chopin and Debussy and works his way through a vast lexicon of ornamental effect with elegant ease. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1735584414/Hannigan_3.jpg){{% /md %}}
<figcaption>Pianist Bertrand Chamayou performed Alexander Scriabin's Poème-nocturne and Vers la Flamme. Photo: Stephanie Berger Photography, courtesy of Park Avenue Armory.</figcaption>
</figure>

_Vers la Flamme_ Op. 72 is another story. Vladimir Horowitz said that Scriabin was inspired to write the piece because of his then eccentric belief that an accumulation of heat would lead to the earth's destruction. Notoriously difficult from the start, it grows more so in its final pages when enormous leaps and double-note trills present daunting challenges, all adroitly negotiated.

When Hannigan reappeared to perform John Zorn's _Jumalattaret_ she had retired the goddess look in favor of a bold and decidedly modern garment. But she was ready to sing, and in this case chant, shout, howl and engage in all manner of sound, in praise of Finnish goddesses with text derived from _Kalevala_, the Finnish national epic. If Zorn's work has the initial impact of an abstract expressionist painting, his compositional technique, typically eschewing any musical category, and quest for innovation and discovery soon avail themselves. This is a monumental work; wholly original, philosophical and a spectacular sonic journey. 

Much of the piece is vocalise. It starts with a lovely vocal line then rapidly begins to support the notion that it might be unsingable. But as a result of prolonged practice and close collaboration with Zorn, Hannigan proves that it is not. Passages of the piece however, are whispered and require possessed laughs, hand clapping and the conquering of an extended cadenza that is a maze of intonations and shifting techniques.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1735584415/Hannigan_4.jpg){{% /md %}}
<figcaption>Pianist Bertrand Chamayou and soprano Barbara Hannigan with composer John Zorn closed the Park Avenue Armory's 2024 Recital Series in the newly restored Veterans Room. Photo: Stephanie Berger Photography, courtesy of Park Avenue Armory.</figcaption>
</figure>

By design Chamayou is often at odds with Hannigan, his playing providing counterpoint to the swings and dives from simple folk tunes to complete vocal abstraction. He works the keyboard with strenuous exactness and plays the piano's strings with gusto. There is a point where he and Hannigan literally find themselves face to face under the lid, an amusing if intense moment, visualizing a meeting of the minds, as it were.

Hannigan, as the musical world knows, divides her time between singing and conducting, a second and impressive discipline that it seems is never far away from her singing. Like Betty Carter and Anita O'Day, great jazz singers who led their bands, Hannigan's gestures, even the most delicate, and her body language reveal that she is conducting herself and perhaps the audience as well.

Zorn, who was in attendance, shared in the bows, basking in the camaraderie of his fellow artists and the appreciation of an ecstatic audience. In a brief chat after the recital, he said it best. "There's no one like Barbara Hannigan." And that's why the Armory was the only place to be on that Thursday evening.