+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2015-04-10T23:53:00-04:00"
lastmod = "2015-04-10T23:53:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428724175857/Notation_Fotor.jpg.jpg"
publishDate = "2015-02-23T08:53:00-05:00"
short_description = "When I was thinking about pursuing a Doctorate degree in Collaborative Piano, I had a germ of an idea for a thesis project: to create a piano-vocal score of a standard opera (Le nozze di Figaro, or La traviata, for example) that would be designed for pianists who didn’t necessarily have a strong operatic background. These scores would be edited so that a pianist could play everything they see, and it wouldn’t sound stupid (which is what happens if you play every note you see in, say, a Bärenreiter edition of anything). "
slug = "bad-editions-and-the-limits-of-the-notes"
title = "Bad Editions and the Limits of the Notes"
+++

<p>
	When I was thinking about pursuing a Doctorate degree in Collaborative Piano, I had a germ of an idea for a thesis project: to create a piano-vocal score of a standard opera (<em>Le nozze di Figaro</em>, or <em>La traviata</em>, for example) that would be designed for pianists who didn't necessarily have a strong operatic background. These scores would be edited so that a pianist could play everything they see, and it wouldn't sound stupid (which is what happens if you play every note you see in, say, a Bärenreiter edition of anything). I came up with the idea after working on my first few operas, and learning to recreate the orchestra at the piano with a combination of scores and recordings. Piano-vocal reductions of opera scores are always either incomplete (missing vital melodic lines), or redundantly difficult (fast passages in thirds, which sound great on two flutes, and pretty terrible on one piano). For more examples, I suggest checking out the PV scores of "Celeste Aida", or anything by Richard Strauss.
</p>
<p>
	I thought to myself, it can't be that difficult to write something that will <em>actually</em> sound correct. Schirmer, mark those string tremolos as <em>pianissimo</em>, and the oboe lines as <em>mezzoforte</em>, so that the balance is correct. Bärenreiter, get rid of all the unnecessary octaves that cost a pianist accuracy, and just write a damn legato line. Boosey, stop showing me all the inner lines that no pianist could ever play, and that obscure the bits that are actually important.
</p>
<p>
	I still might come up with the Douglas edition of the Mozart/DaPonte operas, or something, because I feel strongly about this subject. But the real issue isn't that these piano-vocal scores are cryptic, it's that musical notation must be, and has always been, taken with a grain of salt.
</p>
<figure data-type="image"><a href="https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428724253039/early-music-notation_Fotor_Collage.jpg"><img data-resize-src="http://lh3.googleusercontent.com/IPaei0MLxTC3D8j8-_xs5VKYpdKEeklNGDhdwxYRersVByotAmK2Rvn2sbE9koKY1i4MxksqUzGFYnvIO8ptLpd1qMq8" src="http://lh3.googleusercontent.com/IPaei0MLxTC3D8j8-_xs5VKYpdKEeklNGDhdwxYRersVByotAmK2Rvn2sbE9koKY1i4MxksqUzGFYnvIO8ptLpd1qMq8=s1200"></a><figcaption>Top: 12th century notation from the Schøyen Collection. Bottom: from George Crumb's <em>Star-Child</em> (1977).</figcaption></figure>
<p>
	I'm not equipped to give you a history lesson in musical notation, but here's the short version: notation started with suggestive dots and lines above the text, showing the reader the intended shape of the melody. This minimal system evolved to accommodate more specific rhythms and keys, and eventually composers could notate the <em>way</em> to play a note, not just which note and for how long. Accents, <em>staccati</em>, slurs, <em>fermate</em>, etc., are now just as commonplace on a page of music as are the notes themselves. But no matter how specific a composer may be, they can't dictate everything.
</p>
<figure data-type="image"><a href="https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428724323278/Screen-Shot-2015-02-22-at-2.11.30-PM.png"><img data-resize-src="http://lh3.googleusercontent.com/pUAfNpJfkmWUH4s1Eb40voxJ1kf_OFjyXKO262RjYPAVVKewvxZZE_58Bawkx8NWh51dwlhkzGg6cnQ-xJkveJpDSgM" src="http://lh3.googleusercontent.com/pUAfNpJfkmWUH4s1Eb40voxJ1kf_OFjyXKO262RjYPAVVKewvxZZE_58Bawkx8NWh51dwlhkzGg6cnQ-xJkveJpDSgM=s1200"></a></figure>
<p>
	These are the first four bars of Pamina's aria, "Ach, ich fühl's", from the manuscript of Mozart's <em>Die Zauberflöte</em>. Look at the beginning of the third measure: two eighth notes, each on a syllable (the last two in the word, "verschwunden"). How is a singer really supposed to know that those two eighth notes aren't actually equal? That the first note gets a bit of a lean, and the second note needs to be the release of tension (basically, sung softer and a bit shorter)? Without the context of musical style and the tendencies of the German language, this score doesn't say anything about uneven eighth notes.
</p>
<figure data-type="image"><a href="https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428724353434/CheGelida.jpg"><img data-resize-src="http://lh3.googleusercontent.com/xhgl82A7XEQwbXG6Q0gAbW8bNFd2NR0nWXtCGYz_-WcA_JmHKUjKzgRZk_xSJHakTTvCbYuC5pIwe-EoW6BhhmOBbCZM" src="http://lh3.googleusercontent.com/xhgl82A7XEQwbXG6Q0gAbW8bNFd2NR0nWXtCGYz_-WcA_JmHKUjKzgRZk_xSJHakTTvCbYuC5pIwe-EoW6BhhmOBbCZM=s1200"></a></figure>
<p>
	This famous bit from <em>La bohème </em>is another great example. Puccini sets the text under even eighths once again, and if a tenor actually sang this line as written, I would be concerned. The syllables on the downbeats of Rodolfo's first four bars are the true points of stress in this Italian sentence (che <strong><em data-redactor-tag="em">ge</em></strong>lida ma<strong><em data-redactor-tag="em">ni</em></strong>na, se la <em><strong data-redactor-tag="strong">la</strong></em>sci riscal<strong><em data-redactor-tag="em">dar</em></strong>"), and Puccini made a fair assumption that the language would inform the small differences in stress (rhythm, really) that are almost impossible to notate.
</p>
<p>
	Even when musical notation gets to a level of almost unquestionable clarity, there's still a missing piece. That piece is the performer's being aware of the reason, the significance of the notation. A good example is this moment in Britten's <em>The Turn of the Screw</em>.
</p>
<figure data-type="image"><a href="https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428724386022/Screen-Shot-2015-02-22-at-9.50.30-PM-1024x130.png"><img data-resize-src="http://lh3.googleusercontent.com/a5NavIJDeXOzJ8tPEbHQF5F6ZB8B34Lg_AdFpTL2B7apUG9-OacbFtU4e0DrjiV5yzXUlXQFk2MrNsCguyRnKsfDvePi" src="http://lh3.googleusercontent.com/a5NavIJDeXOzJ8tPEbHQF5F6ZB8B34Lg_AdFpTL2B7apUG9-OacbFtU4e0DrjiV5yzXUlXQFk2MrNsCguyRnKsfDvePi=s1200"></a></figure>
<p>
	Peter Quint is a ghost, haunting a boy named Miles; in this scene, he's trying to lure Miles towards him, or away with him, or wherever ghosts go. It's an incredible scene, and Britten does a pretty damn good job of giving the performer <em>everything</em> he needs. He writes an octave leap for Quint, and puts a <em>diminuendo</em> to <em>pianissimo</em> on the way up, all over "long sighing"; a singer can easily see from the notation that the idea is to sing "long sighing" in a long, sighing way. That's what I mean when I say the performer needs to be aware of the reason for the notation. It's one thing to do everything on the page, and it's another to understand why it's all on the page to begin with. It reminds me of that George Carlin quote about the playing the blues: "I'll give you a little tip about the blues, folks: it's not enough to know which notes to play. You need to know why they need to be played."
</p>
<p>
	When we're talking about music for singers, the text rules all; when it comes to language and music, one is an extension of the other, and <a href="https://www.psychologytoday.com/blog/your-musical-self/201209/which-came-first-music-or-language" target="_blank">there are a few theories</a> about "which came first." The funny thing is, musical notation is a lot like an alphabet. Letters and phonetic symbols notate language with a certain amount of specificity, but no alphabet (not even the <a href="http://en.wikipedia.org/wiki/International_Phonetic_Alphabet" target="_blank">International Phonetic Alphabet</a>) can capture things like inflection or minor variations in pronunciation. Like how the phrase "don't you" has a bit of a "ch" sound in it.
</p>
<p>
	When you consider how important it is for humans to be able to communicate with each other, I think it's fascinating that it's so difficult to record or represent language. Artists are used to the fact that, on their own, text and music present a lot of questions. When text and music are combined, the list of questions can be significantly smaller. I like this dichotomy, where music and language complete each other, yet still have their own vague corners that can't quite be objectively understood. Those unanswerable questions are what will keep the arts entirely human, and perhaps exempt from our tendency to quantify and define. The limits of musical notation show us exactly where the lines become blurred, where we rely on insinuation and assumption, and where individuality reigns.
</p>
