+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2015-09-01T11:06:00-04:00"
lastmod = "2017-08-09T19:15:00-04:00"
preamble = "The summer winds down, and school and other seasonal activities (like opera!) are soon back in session. In anticipation of a brand new season of opera-going, I figured a practical crash-course was in order. For some of the basics, I can direct you to a few posts:\n\n- [Operatic Voice Types](/fach-isms-stereotypes-for-a-reason/)\n- [What Conductors Really Do](/spotlight-on-christopher-james-ray/)\n- [What a Répétiteur Is](/star-repetiteur-there-is-such-a-thing/)\n- and [How Singers Do Some of Their Tricks](/claire-de-sevigne-sing-fast-high/)\n\nSince this crash-course is indeed practical, I've chosen a few terms from the opera dictionary you'll need to have in your back pocket as you check out upcoming opera, 2015/16-style."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1502320517718/2017-08-10---Glossary.jpg.jpg"
publishDate = "2015-09-02T07:30:00-04:00"
related_articles = ["articles/opera-in-summer.md","articles/the-future-of-opera-is-indie.md","articles/in-review-jenufa-czech-philharmonic.md","articles/falstaff-in-cambridge.md","articles/a-faq-checklist-for-opera-newbies.md","articles/shades-of-opera-how-to-tell-your-buffo-from-your-bel-canto.md","articles/5-reasons-to-get-your-drama-fix-from-oratorio.md","articles/shorthand-ii-proben-facher.md","articles/in-review-the-mississauga-symphony-presents-carmen.md","articles/dont-miss-schoolyard-carmen-at-tsmf.md"]
related_companies = ["scene/companies/voicebox-opera-in-concert.md","scene/companies/canadian-opera-company.md","scene/companies/opera-da-camera.md","scene/companies/cowtown-opera-company.md","scene/companies/myopera.md","scene/companies/essential-opera.md","scene/companies/against-the-grain-theatre.md","scene/companies/the-bicycle-opera-project.md","scene/companies/stujess-productions.md","scene/companies/opera-by-request.md","scene/companies/indie-opera-to.md"]
related_people = ["scene/people/joel-ivany.md","scene/people/geoffrey-sirett.md","scene/people/claire-de-sevigne.md","scene/people/christopher-james-ray.md","scene/people/natalya-matyusheva.md"]
short_description = "The summer winds down, and school and other seasonal activities (like opera!) are soon back in session. In anticipation of a brand new season of opera-going, I figured a practical crash-course was in order."
slug = "back-to-school-opera-a-practical-glossary"
title = "Back to school opera: a practical glossary"
+++

### In-Concert

In-concert means simply that an **opera is presented without sets, costumes, or intricate staging** from a director. The usual set-up is the cast and orchestra or pianist onstage, in black-tie dress that may or may not be suggestive of their respective characters. Often the singers will use their music, and good in-concert singers know how to keep a pesky music stand from hindering your enjoyment of their performance. In-concert performances are great for focusing right in on the music, and I like the opportunity to watch singers work without the added layers of costumes and sets (which can also mean greater distances). Bonus: operas that can be expensive or risky to put up in full production often get heard in-concert.

Toronto is home to two great places to catch in-concert performances and hear some of Canada's serious operatic talent. [VOICEBOX: Opera in Concert](/scene/companies/voicebox-opera-in-concert/) starts its season with Borodin's [*Prince Igor*](http://www.operainconcert.com/PrinceIgor_syn.html) on November 22nd, featuring soprano Natalya Matyusheva and baritone Geoffrey Sirett. If you can't wait that long before your in-concert fix, head over to hear [Opera By Request](/scene/companies/opera-by-request/)'s production of [*Der Freischütz*](http://operabyrequest.ca/wordpress/) on September 18th, featuring Schmopera contributor and baritone [John Holland](http://www.schmopera.com/don-giovanni-at-the-estates-theatre/) as Kaspar.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1441131852326/WrittenonSkinConcert.jpg.jpg)
<figcaption>Barbara Hannigan in the Toronto Symphony Orchestra's in-concert production of *Written on Skin*. Photo: Malcolm Cook.</figcaption>
</figure>

### Triple Bill

The next generation of the double bill, a triple bill is fairly self-explanatory: **three shows in one night**. Opera's most notorious triple bill is Puccini's *Il trittico* (*The Trilogy*), which includes *Il tabarro*, *Suor Angelica* and *Gianni Schicchi*. Today, the individual operas are extracted from the trilogy, with companies often presenting just one or two of them, or combining them with works by other composers, as did the Canadian Opera Company in 2012 with its double bill of *Gianni Schicchi* and Zemlinsky's *A Florentine Tragedy*. My favourite part of double and triple bills is spotting the theme that brings the individual pieces together. Sometimes it's clear, often it's a more mysterious game.

You can catch a real live triple bill at the [COC this October](http://www.coc.ca/PerformancesAndTickets/1516Season/PyramusandThisbe.aspx), as they present Monteverdi's *Il combattimento di Tancredi e Clorinda* and *Lamento d'Arianna* with Barbara Monk Feldman's much more recent *Pyramus and Thisbe*.

### Oratorio

Oratorio has all the same musical ingredients as opera, like solo singers, a chorus, an orchestra, arias, *recitatives*, an overture, the whole deal. The difference is that **oratorio uses sacred texts instead of secular**. If you listen to oratorio by Handel, Rossini, Mozart, even Bach, it's not hard to hear that storytelling and drama is at the forefront of oratorio, just as it is for opera. A common quip among opera folk is about how "Verdi's best opera" is really an oratorio: his stunning, edge-of-your-seat *Requiem*.

Thanks to people like Peter Sellars and other thinkers-outside-the-box, the staging of oratorio is becoming more and more popular. Proof: Against the Grain Theatre is reviving its successful production of [*AtG's Messiah*](http://againstthegraintheatre.com/shows/atgmessiah), staged and choreographed by [Joel Ivany](/scene/people/joel-ivany/) and [Jennifer Nichols](https://twitter.com/JennEMethod). Shows are in December, dates and locations still TBA. To stay in the loop, follow them on Twitter, [@AtGTheatre](https://twitter.com/AtGtheatre).

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1441131357087/SellarsStJohnPassion-pc-MonikaRittershaus.jpg.jpg)
<figcaption>A scene from Peter Sellars' staged version of J.S. Bach's *St. John's Passion*, 2014. Photo: Monika Rittershaus.</figcaption>
</figure>

### Indie Opera

This one is a biggie for current opera-goers. As opera in its traditional, grand form, comes under pressure for relevance, interest, and financial prudence, small companies are popping up everywhere. These compact companies work on a shoestring budget and they're often synonymous with presenting creative second-glances at operatic repertoire, new and old. Canada is home to [Cowtown Opera Company](/scene/companies/cowtown-opera-company/), [Stu&Jess Productions](/scene/companies/stujess-productions/), [Opera da Camera](/scene/companies/opera-da-camera/), [Metro Youth Opera](/scene/companies/metro-youth-opera/), and [Against the Grain Theatre](/scene/companies/against-the-grain-theatre/), to name a few among the Indie Opera scene today; they may have small stature in common, but they each bring an unique spin on opera to their ever growing audiences. In Toronto, 12 of these companies have banded together to form [Indie Opera T.O.](/scene/companies/indie-opera-to/), a collective of like-minded opera and theatre producers. A quick look at some upcoming indie events:

- Toronto, September 3-6: [The Bicycle Opera Project](/scene/companies/the-bicycle-opera-project/)'s touring production, [*shadow box*](http://bicycleopera.com/tickets-ontario/)
- Calgary, September 24-27: Cowtown Opera's new commission, [*Annie Davidson*](http://www.eventbrite.ca/e/annie-davidson-tickets-17974222383)
- Montréal, October 17-24: Opera da Camera's [*Hänsel and Gretel*](http://www.operadacamera.ca/2015-16/hansel-und-gretel)
- Ottawa, October 16-18: Essential Opera's double bill, [*Etiquette/Regina*](https://operalyra.ca/etiquette-regina/) with Opera Lyra Ottawa.
