+++
author = ["authors/rich-coburn.md"]
categories = "Editorial"
date = "2015-12-16T13:06:00-05:00"
lastmod = "2015-12-16T15:29:00-05:00"
preamble = "This is a post by guest contributor Rich Coburn, a pianist and organist based in Montréal. If you like what you read, head over to Rich's [blog](http://www.richcoburn.com/blog/) to find the original article and more."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1450292192541/2015-12-16---Bach.jpg.jpg"
publishDate = "2015-12-16T14:24:00-05:00"
related_articles = ["articles/the-ghost-of-christmas-carols-past.md","articles/the-score-how-to-see-what-a-composer-sees.md"]
short_description = "It is not possible to overstate how crazy it would be to hear infrasounds in music for the first time. It would be like if tomorrow we discovered a new colour of visible light that we’d been overlooking since the beginning of time. A completely new response from a sense that had been giving you exactly the same feedback for decades. This sound, and therefore the music it&#039;s a part of, would make a huge impression on you."
slug = "bach-was-all-about-that-bass"
title = "Bach was all about that bass"
+++

If you're serious about music, as an amateur or a professional, you have spent time agonizing over a score. Finding the best place to breathe when there is no good place to breathe. Wondering what would happen if you started just 4bpm faster. Deliberating exactly how far you can stretch this phrase and get away with it. We all know that the smallest details can be of paramount importance.

Except when they're not. When every detail of phrasing and articulation is almost trivial in comparison to larger hidden forces.

Imagine a situation where you understand the composer's every intention and instruction perfectly. Performance conditions are absolutely ideal. You've studied, you've practiced, and as you walk on stage you believe that you can create for your audience exactly what the composer had in mind for his. The thing is that, despite your perfect preparation, you're not going to come close. In fact, you're going to be laughably far from what his audience experienced.

To illustrate why this is true, we're going to take a little trip back in time to northern Germany during the Baroque era.

## Willkommen in Deutschland.

The Baroque organs of northern Germany were the first to systematically include a keyboard for the feet which played very, very low notes. They often included a 32’ rank ("32 foot") that produces notes two octaves lower than written. The lowest note of that rank sounds at about 16Hz.

Just for comparison, if you’ve spent $500 on a subwoofer, it may still bottom out around 50Hz. A really expensive one will take you down to 20Hz, which is generally considered the bottom of the range of human hearing. Everything below b1 — which at 61Hz is just over an octave above the bottom of the piano and almost two octaves higher than the low c of the organ — is considered part of the sub-bass range of frequencies. These pitches become increasingly hard to hear as you descend. Below 20Hz — the E-flat below the bottom of the piano — we enter the realm of **infrasound**, or sound that we can’t really hear, but we can feel.

Now imagine that you live in a rural area in Bach’s time. Your small local church doesn’t have a technologically advanced 32’ rank on its organ, only a 16’ which sounds one octave higher. One day, you decide to make a journey into a larger centre for the first time (remember that people didn’t travel much). Since your trip includes a Sunday, you attend a service and maybe even hear Bach himself playing. You’ve never heard the bass sounds of a modern cityscape or of club music. Up to this point, you have never in your wildest dreams imagined infrasound as being part of a highly organized structure like music. The only times you have ever been exposed to sounds in this range are perhaps at a large waterfall, or during extreme events like storms, avalanches, earthquakes, explosions etc.

It is not possible to overstate how crazy it would be to hear infrasounds in music for the first time. It would be like if tomorrow we discovered a new colour of visible light that we’d been overlooking since the beginning of time. A completely new response from a sense that had been giving you exactly the same feedback for decades. This sound, and therefore the music it's a part of, would make a huge impression on you.

Even if you regularly attended church and heard 16Hz frequencies, this would still be the only place that you were regularly exposed to that range within the realm of organized sound. You’d get a couple dozen minutes of those frequencies per week. Imagine if you only had internet access on Sunday mornings. It is ubiquitous today, but do you remember how special it was when it was rare? Sunday mornings would quickly turn into a pretty special occasion for you. 

So fine, we can play an imaginary game and hypothesize about how people in another time felt about certain music. It seems like a reasonable imagination, butcan we know how people react to infrasound? 

It turns out we can. We have science! And it supports my point perfectly. 

In 2003, 700 people were experimented on in a concert setting. They heard four pieces, two of which were underpinned by an inaudible 17Hz frequency (essentially the same as the bottom of the organ range). The concert was later repeated and the infrasound was added to the other two pieces instead. 22% of respondents reported feeling anxiety, fear, chills down the spine, etc., during the pieces with infrasound. Don’t forget that this is in a world saturated with the bassy sounds of passing 18-wheelers, the music blasting from cars, movie theatres, construction sites, and those sweet headphones you wear every morning on the subway. Infrasound has a strong effect on people today; we can only assume that it had a much stronger effect on people who rarely or never heard it. 

In fact, I think that the effect of infrasounds on the Baroque listener would outweigh by an order of magnitude or two any artistic choices the organist may make in terms of the overall effect of the piece. His subtle deliberation of tempo or 
articulation is tantamount to choosing whether to sit in the 4th or the 6th row for a concert; that’s not what you’re going to remember about your experience, and it’s not what you’re going to tell your friends about.

"Ok, so you've found one super specific example where your point is valid, Rich."

## "Does this principle apply in any other music?"

Let's look at it this way. A large part of the impact that this music had on the first people to hear it comes not from the beauty of the music, but from the intersection of culture and technology where the music was created. The cultural context (church) associated the music with God. And the music in that form was possible only because of a fairly recent technological breakthrough. 

Both the cultural and technological contexts have changed drastically today. If we are interacting with the music via these contexts, as our long-dead audience must have been, then our interaction can't help but change along with the contexts through we which we are interacting. 

Of course, there is beauty in Bach just because it's Bach. People can't have liked it only because is was associated with a religion that was built into the fabric of their lives, or because infrasound was a new musical experience for them. But it seems clear to me that drastic cultural or relevant technological changes must, in this case, result in reasonably drastic changes in our relationship to the music.

If you accept that our interaction with music is, to some extent, dependant on the cultural constructs through which we experience that music, then we can broaden the scope of this argument. Our culture is still very different from Chopin's Paris, Brahms' Vienna or Shostakovich's Moscow. I'm sure that I can't imagine many of the differences. That means that, logically, I can't imagine many of the different ways audiences in those times and places interacted with the music that we have both heard. 

## "So what do you do with this information?"

I’m not an anthropologist, and I don’t have a thorough enough understanding of the societies of any of my favourite composers to do an exhaustive analysis in this vein. So I’m not in a position to give definitive, concrete suggestions. And the point of this post is certainly not to discourage anyone from studying or from crafting details beautifully. But the music industry is undergoing a lot of change, and I think some or even many of the problems driving that change are related to the point I make above. 

*Of course* classical music is relevant to a 21st century audience! But that doesn't mean that every aspect of it can be appreciated, or is as powerful, as it was when the music was written 100 or 300 years ago. I've found that looking for problems of this nature allows me to try to solve them.

As I consider what small contributions I want to make to my artistic community, I think it's prudent to consider what elements of classical music I think can't be beat by anything anywhere, and which ones might be based on outdated assumptions and old fashioned models. Assuming that every detail of the composers' score is still relevant in 2015 may leave hidden problems unsolved.
