+++
author = ["authors/anonymous.md"]
categories = "Op-ed"
date = "2016-10-08T14:23:00-04:00"
lastmod = "2017-08-02T21:42:00-04:00"
preamble = "This is a guest submission by an author who is a current figure in the operatic industry. Due to the significant professional risk associated with the topic, the author wishes to remain anonymous."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1501724548681/2017-08-02---Shattered.jpg.jpg"
publishDate = "2016-10-11T04:00:00-04:00"
related_articles = ["articles/in-defence-of-singers.md","articles/new-opera-honest-marketing.md","articles/artists-administration-reputations.md","articles/when-lost-find-roots.md","articles/the-time-i-spilled-some-secrets-into-a-microphone.md","articles/why-we-must-keep-on-keepin-on.md","articles/i-didnt-get-in-a-short-story-about-clarity.md","articles/stop-shaming-adele.md","articles/no-opera-is-not-misogynist.md","articles/4-unwritten-skills-professional-singers-need.md","articles/music-degrees-expectations-4-tips-for-new-students.md","articles/some-uncomfortable-questions-about-the-levine-business.md","articles/milan-milisavljevic.md"]
short_description = "The business of opera is at times wonderful and at other times loathsome. It is, sadly, mostly run by the ill-informed and the ill-equipped. It is therefore oftentimes arbitrary and frivolous though it can sometimes be sublime."
slug = "audition-season-or-the-annual-festival-of-shattered-dreams"
title = "Audition season, or the annual Festival of Shattered Dreams"
+++

Should I stay or should I go now...

It's the most wonderful time of the year! All about the continent, young artist singers are engaged in the annual process of auditioning for young artist programs at major and not so major opera companies. Though it's been nearly a decade since I myself entered one of these hallowed sanctums of operatic learning, it seems to me as though this process has been in a perpetual state of motion since the very beginning of time.

And how could it feel any different?

From the moment any aspiring singer, stage director, coach or conductor leaves (at bare minimum) their bachelor's degree training or (much more likely) their masters or post-graduate training, so begins a life of continuous uncertainty and endless searching for the next great opportunity. 

And what are we all in search of, exactly? 

Those still youthful enough to possess any sense of optimism whatsoever will answer that they seek a career in opera, big roles, big houses and big paycheques. The rest of us simply hope for some sort of meaningful musical pursuit, and perhaps even a little financial security.

Regardless of the state of your hopefulness or one's cynicism, the fact of the matter is that most people who work professionally in opera will have gone or will eventually go through one or multiple opera training programs. And given this fact - one that might perhaps come third only to those other two certainties: death and taxes - it seems quite a whimsical notion to expect that this path could be, forevermore, substantively altered. 

Though there may be many good reasons to abandon the whole business of young artist programs and really reconsider, totally and organically, the entirety of our education process (from undergraduate training onward), for the purposes of this specific article, let us take the state and circumstances of our situation as read.

And so you currently find yourself involved in the elaborate process of registering and preparing for innumerable auditions. 

Have you requested your recommendation letters? Do you sing well in your recording? Did you choose the right repertoire? Is the recording quality high enough? Did you wear the right clothing, take the shot properly, introduce your pieces effectively?

In short, have you properly demonstrated your ability to balance a beachball on your nose at the whimsical request of unknown forces who hold your future in their hands? 

Before we progress any further on this point it is worth noting that the audition process, as organized by these various institutions which you all know, is not wholly arbitrary. The fact of the matter is that there are many singers (and to a lesser extent coaches, conductors and stage directors) to hear and only so much time and effort that can be exerted by those who make these kinds of decisions- many of whom have very taxing and multi-faceted jobs (the problems of opera administrations and their frequent dysfunctions must be dealt with separately, I'm afraid). 

It is therefore quite sensible, from a certain point of view, that various time saving efficiencies be enacted with the hope of streamlining what is, ultimately, a time consuming enterprise.

But notwithstanding a token expenditure of sympathy for some of my colleagues in administration, it is my belief that - for the most part and with few exceptions - the entirety of this young artist selection process is fundamentally flawed. 

And while I do not think it sensible to believe any such venture could be refined to a state of utter perfection, it pains me to see, time and again, the hopes and desires and, indeed, lives of good people ruined in a pursuit of a folly perpetrated, often, by people scarcely qualified to render an opinion on basic musical or vocal matters.

But we get ahead of ourselves.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1476175882149/2016-10-08---Chess.jpg.jpg)
</figure>

It seems to me that the most fundamental problem in the young artist program selection process begins in that oh-so-brilliant double whammy of bureaucracy and laziness: the prescreening recording. This issue can be dispatched with quickly and effectively:

If you are not willing to take the time to listen to a singer perform at least two arias live, in a proper space with good acoustics and, at bare minimum, with a decent pianist in support, then it is my belief that you are not in possession of enough information to make  significant assessments on the quality of a voice. It is, moreover, snobbish to assume that you could make such an assessment, given all of the inherent variables. Lastly, it is just plain rude to not offer an equal opportunity for all persons to be heard. 

But it is frivolous to speak of equal opportunity in opera, and this brings me to the very heart of the matter.

At this most wonderful time of the year, it is not uncommon to encounter friends in tears, colleagues who consider leaving opera in search of greener occupational pastures, and to feel in the air a general sense of desperation. It is the annual festival of shattered dreams.

On the one hand, no one should be foolish enough to think that everyone who wants to work in opera, in whatever capacity, can actually succeed at it. Some of you who read this truly are just not good enough. There are certain quantifiable and objective standards which can indicate whether one is fit to sing in a major house, to coach, to conduct or to direct. 

But on the other hand it is often too easy to fall prey, after the poignant sting of rejection, to that excessive doubt which leads to hasty conclusions. The fact of the matter is, while you may be utterly unfit to be an operatic professional, it is almost equally likely that you *are* fit, or at least that you might be. And this is where the pitfalls and problems of YAP selection come into play. 

While you consider quitting singing because you did not receive a call back, have you considered the fact that the program you auditioned and sang so beautifully for had no openings for your voice type?

Have you considered what time of day you sang, who came before you, what your past relationship with one of the panellists was and whether or not every member consumed a proper lunch?

The real truth of the matter, and one which is quite hard to accept but is utterly true, is that the people in whom you place great importance, power and who, to a certain extent at least, define your self worth as a performer in an audition, are just people. 

Some of them did not sleep well last night, need a break, need a snack. Some of them are petty and manipulative. Some of them are quite rotten people, if we're being honest. And some are, perhaps even more unsettlingly, not particularly well equipped to understand what it is that you are actually doing.

It is a fact that in this country, artistic decisions at major opera companies are often made by people who have little (or at best peripheral) experience and absolutely no education in the field whatsoever. You might, after the fact, analyze the various possible reasons why a given panelist would have chosen this or that aria. Often, they didn't know your first aria, and might not know anything else on your list. 

You would be dismayed or heartened, depending on your point of view, to know that some of the people behind those desks across the audition room - he who cavalierly banters amongst his colleagues about the product of your many years of musical study - might once have been a stage manager, a movie producer, a marketing manager or, and heaven help you if this is case, a failed singer. 

In short, they might not have any idea what it takes to be a singer, could not articulate how to accomplish such a miraculous feat as even singing a little bit well, and could not tell you what makes a stage director good or a conductor qualified to lead an orchestra. 

In slightly better circumstances, the panellist in front of you is a successful or not-so-successful director, latter-day singer, conductor, or pianist. All of these individuals, the qualified and not so much, truly believe that they have an opinion which should count for something and that, by virtue of that magical word which erases all other inadequacies, "experience," they are entitled to their jobs (and salaries) as heads of companies and arbiters of quality. With few, and I think obvious, exceptions, this is simply not the case.

Alas, the state of classical music management is in a grave state in this country and elsewhere. Too seldom do commentators look at the real problem of classical music: that her institutions have been run by a generation of individuals who have outlived their time, have grown too little and spent too much.

But that is also a topic for another time.

An important takeaway from all of this, however, as you struggle along this year and indeed even if you succeed this year, is that the whole lot of it is founded upon the notions and actions of imperfect people. It is a lottery where talent and merit only occasionally matter and where success is sometimes ephemeral and almost always a doubled edged sword. There is no example of a success attained by anyone who would not subsequently have given it all up, or deemed it not worthy of the sacrifice, at least in their darker hours. Anyone who talks the nonsense of continual gratitude is simply lying. 

A more important takeaway is this: there is no person who has any business, regardless of their alleged eminence, determining for you whether or not you should be pursuing a career in opera.

Ultimately, it seems to me that the question to ask is not whether you are doing the right thing, singing the right repertoire or if you're good enough. What is much more important is if the daily pursuit of singing and all of the business that goes along with it, makes you happy. As is so often the case, little decisions in life bear within them issues of cosmic significance - to you, at least.

If it satisfies to continue along this path, go forth and let none of the idiots hold you back. Similarly, why feel compelled by guilt or a misplaced sense of shame to stay in the hunt when in brings about nothing but misery? Quit with pride and do something better for the world and for yourself.

Whatever you do, you oughtn't give a damn about a callback.

The business of opera is at times wonderful and at other times loathsome. It is, sadly, mostly run by the ill-informed and the ill-equipped. It is therefore oftentimes arbitrary and frivolous though it can sometimes be sublime. 

What it should never be is your whole life. 

At this time of year, regardless of what happens, it's worth remembering that and finding a little bit of perspective.
 
Happy Feast of the Shattered Dreams to you all.

