+++
author = ["authors/jenna.md"]
categories = "Op-ed"
date = "2015-11-23T15:36:00-05:00"
lastmod = "2015-11-24T15:11:00-05:00"
preamble = "I've written before about the [psychology of an opera singer's audition](/psychology-of-an-audition/), and playing a strategic game with your aria package. Singers learn the rules of said game through audition experience. So, what if you don't have any?\n\nI was recently asked about what comes even before the decision to start with *bel canto*; young singers, when you're getting ready for your first audition, how do you compile your aria list? You're familiar with the basic idea: collect five arias that you can sing really well, and make sure you vary the language and style. When you're young and still discovering what your voice does well, there's good news, and there's bad news. The bad news is that adhering to audition requirements can be a tricky task. The good news? Your young auditions can be your first opportunities within the opera industry to think outside the box."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1448388192121/2015-11-24%20-%20Stacks.jpg.jpg"
publishDate = "2015-11-24T13:15:00-05:00"
related_articles = ["articles/psychology-audition.md","articles/5-tips-for-university-auditionees.md","articles/risky-opinions-there-are-2-types-of-singers.md"]
short_description = "I&#039;ve written before about the psychology of an opera singer&#039;s audition, and playing a strategic game with your aria package. Singers learn the rules of said game through audition experience. So, what if you don&#039;t have any?"
slug = "audition-arias-101-the-young-singers-guide"
title = "Audition arias 101: the young singer&#039;s guide"
+++

## You don't really need five arias

Not yet, anyway. It's always more important to have quality of arias, not quantity; in the case of young singers, you will inevitably have fewer options of available operatic arias. Your first couple of auditions will likely be for a summer opera workshop or something similar, and not for an opera company or an agent. This means that you're not yet presenting yourself as a full professional, and that allows you freedom from industry conventions (like having five contrasting pieces to sing).

Three arias that you're comfortable singing go much farther than a padded aria package of five, which includes a couple choices that you hope they don't pick. 

The same goes for languages, I think. If out of your three arias, two are Italian and one is English, I'd consider that a good amount of variation. Young mezzo-sopranos might have a hard time finding anything to sing in Russian, and young tenors will find a dearth of German options; this is all alright, because singing the right kind of repertoire is more important than covering all the language bases. Speaking of appropriate repertoire...

## Show that you're young, but not ignorant

I've heard eighteen-year-old sopranos offer up *Turandot* for their audition, and twenty-year-old basses sing *Der Freischütz*. Now, you may not be presenting yourself as a pro quite yet, but you have intentions of doing so soon; at any age, you can be smart about what you choose to sing for an audition. There are many young singers who have some serious sound, and the breadth of Wagner and Verdi might feel luxurious. In your voice lessons and coachings, there can be a lot to learn from so-called "stretch arias", but it's irresponsible to audition with them, since you're suggesting you're not aware of your stage of vocal development.

Singers under 25, you will have a *very* hard time convincing an audition panel that your voice suits the Countess but not Susanna, that you're an Edgardo and not an Arturo. A better strategy: choose the Morgana, the Cherubino, or the Papageno, and let the audition panel mumble among themselves about whether or not you're an Alcina, a Sesto, or a Count. (In other words, make it *their* idea.)

## Look harder for your arias

It's funny how the current edition of a Schirmer aria anthology can decide audition choices for years to come. I'm not saying they're bad picks, but it's just scratching the surface of available options. You can go the extra mile and show that you're actively making artistic choices for yourself by being a bit of an aria detective. An easy way to start is by finding older editions of aria anthologies; it'll still be a convenient source, but the contents will vary and give you a few more ideas. 

One thing I notice in a lot of young singers' auditions is a sense that they're singing repertoire that was chosen for them. That's not in itself a bad thing, and young singers are wise to take advice from their teachers who know more. But if you don't care about the character, or find the aria boring, those sentiments will show up when you sing it. So, if you don't like an aria you've been told to sing, you have the right to speak up about it, but only after you've done some research of your own.

Not sold on "V'adoro, pupille"? Have a look at the full score of *Giulio Cesare*, and see what else is there for Cleopatra to sing (hint: she has a lot). Follow the trail of composers and their other operas, or characters and their other arias; you'll have found out more about your repertoire, and you'll be able to present a few educated choices to your teacher.

>Have questions? Tips of your own? Leave them all in the comment section below!
