+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2016-09-21T10:33:00+01:00"
lastmod = "2016-09-21T19:24:00+01:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1474451690599/2016-09-22---Pub-2.jpg.jpg"
primary_image_credit = "Photo: Denny Wu via Flickr."
publishDate = "2016-09-21T18:54:00+01:00"
related_articles = ["articles/in-review-ayre.md","articles/success-hype-the-first-season-of-opera-pubs-in-toronto.md","articles/i-think-it-takes-a-brave-artist-to-do-something-like-an-opera-pub.md","articles/sunday-funday-a-dontmissit-operatic-doubleheader.md","articles/appetizers-arias-popera-at-the-drake-one-fifty.md"]
related_companies = ["scene/companies/against-the-grain-theatre.md"]
related_people = ["scene/people/joel-ivany.md","scene/people/christopher-mokrzewski.md"]
short_description = "Opera Pubs accommodate the kind of listeners who simply enjoy the sound of operatic singing, and who aren&#039;t necessarily itching to know the details of the story. Even better, the common ground of a pub environment allows listeners to feel as though they&#039;re among the group of singers, rather than watching from afar."
slug = "atgs-opera-pubs-it-can-all-get-a-bit-wild"
title = "AtG&#039;s Opera Pubs: &quot;It can all get a bit wild.&quot;"
+++

Exciting announcements seem to be the norm at [Against the Grain Theatre](/scene/companies/against-the-grain-theatre/), and so far, they're on schedule for their 2016/17. 

AtG has unveiled a [two-year residency with the Canadian Opera Company](http://againstthegraintheatre.com/season-announcement-2016-2017/), the first go at a program designed to support a growing opera company during the first five years of production, arguably the most difficult period for any fledgling arts organization. The COC's General Director, [Alexander Neef](/alexander-neef-listening-to-music/), calls it a "formalization of a long-time mentorship that has existed between the COC and Against the Grain Theatre," and this new connection between two of Canada's iconic producers of opera is an important form of artistic symbiosis. 

AtG gains from the COC stable artistic and administrative resources, and the possibility for mentorship and job shadowing. The COC gains from AtG an aesthetic that looks boldly forward, in a way that only a compact and malleable company can. There's a real opportunity for the COC to become complementary to the mission of AtG and other independent opera companies, to foster a mix of experience and risk and produce art that's both novel and well done.

One of those bold glances forward is in Against the Grain Theatre's Opera Pubs. The company has always enjoyed a healthy relationship with pubs, starting with its inaugural [*La bohème*](http://againstthegraintheatre.com/la-boheme/) at Toronto's Tranzac Club. When AtG began spending its summers at The Banff Centre, Artistic Director Joel Ivany brought the singers and pianists to the Royal Canadian Legion for [impromptu nights of operatic hits](/opera-karaoke-night-2015/) for (mostly) unsuspecting listeners.

"My first experience of Opera Pub was in Oslo, Norway," recalls Ivany. "There's an Underwater Pub that is nautical-themed, but also, often it's transformed into Opera Pub where singers from the Norwegian National Opera join forces with singers at the Conservatory and sing arias, duets and ensembles in a very relaxed environment. The owner of the bar has only one rule: when they sing, you listen. If not, they ask you to leave the bar. It's such a fun, safe way to hear snippets (they do 15 minute sets) of awesome classical music and have a beer in hand."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1474476771438/tkAFwm738zeUMAb1ad5QCPpd0GMBieNl8sE4SDVaE8UGYfboLwLawz1zIvQMX1V3IbrBe1uxgtYENt-SY50g_DVuoI6w%3Dw1360-h1360)<figcaption>AtG Music Director Christopher Mokrzewski at the piano with baritone [Brent Calis](/scene/people/brent-calis/) at an Opera Pub at the Royal Canadian Legion, Banff, AB, 2015.</figcaption>
</figure>

Now, Against the Grain Theatre is starting a **series of Opera Pubs at Toronto's Amsterdam Bicycle Club**; they'll happen on the first Thursday of each month, starting on October 13.

"There are times when we might begin," says AtG Music Director [Christopher Mokrzewski](/scene/people/christopher-mokrzewski/), "and a few bar regulars, who may not have known this was going to happen, find themselves totally absorbed by the spectacle. Or they hate it and leave. Either outcome is okay, as far as I'm concerned."

It's a simple idea, and one that could be a fantastic introduction for an opera newcomer. In the familiar environment of a pub, with no oppressive silence or close-quarters seating, people can enjoy opera in short bursts. Listeners have a drink in hand, they can get up and leave whenever they want, and they're essentially left wanting more. Opera truly is best consumed live, and it's hard to get more real-life than in a cozy pub.

Ivany has seen the results for himself in Oslo, and more recently in Banff. "One of my most memorable Opera Pubs was hearing [Caitlin Wood](/scene/people/caitlin-wood/) singing an aria from *Giulio Cesare*," he says. "It was exciting, it was electric and the audience was cheering and clapping DURING the aria. It seemed that she was fueled by the energy and put it into each ornament. Was very cool."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1474476867427/MoqdnW2NsNdpwXcGCwkttLdcS9LlC1mkBsEcSOgkVAVFoW0sf0bxHXQwN-03zr0LSt0At8x_-3TiSDzdwq_xr20w4vA%3Dw1360-h1360)<figcaption>Soprano Caitlin Wood and tenor [Pasquale d'Alessio](/scene/people/pasquale-dalessio/) at the Royal Canadian Legion, Banff, AB, 2015.</figcaption>
</figure>

Singers take the opportunity to try out their musical theatre chops, their "stretch" arias, improvised duets, and gender reversal. "It can all get a bit wild," agrees Mokrzewski.

Opera Pubs accommodate the kind of listeners who simply enjoy the sound of operatic singing, and who aren't necessarily itching to know the details of the story. Even better, the common ground of a pub environment allows listeners to feel as though they're among the group of singers, rather than watching from afar.

"It is a fact that there is less of a cultural awareness of what opera and classical music in general is," says Mokrzewski of the outreach possibilities inherent in Opera Pubs. "When we 'take it to the streets', as it were, people are able to have a no-bullshit, no-boundaries encounter with the art form in a manner which is straightforward and visceral."

"They have no idea what is going on, but they respect the voice," adds Ivany, who has seen the truly inclusive nature of Opera Pubs. "It's about slowing down, in some ways, and just listening."

Opera Pubs kick off **October 13 at 9pm** at [Amsterdam Bicycle Club](http://www.abclub.ca/), 54 The Esplanade, Toronto. Go, and enjoy some high notes with your drink of choice. 

***
Feature image: [Denny Wu](https://www.flickr.com/photos/126610523@N04/16251352250/in/photolist-qL5qQs-pwMoUP-9dEabt-6HQqcG-egf1nw-4mWw9Z-oVFJyc-9vBq3d-5qZrBN-pwMs4p-q9EZVE-a4ffYs-qKj2uC-6bCj8y-8MnjDc-pfh6qD-qbTUi5-qLFCFy-5mLwVt-infzz9-8AgcPf-6RwrDs-5RqSCx-4VWFFL-6spaDo-91pQUG-2YiEVD-dbnUZy-74NmNc-6TxLDW-S8DyU-9qvCSa-5uHqe1-7XXLUG-qWbnJN-7emecz-7kcdjT-pfhNko-n7gWvJ-nkU5HL-pfi9YM-oQBxR2-dSmWXE-94JiFu-byynuG-fPUARH-smm36-E3Hyyv-6rQW4j-nFwv1Z) via [Flickr](https://creativecommons.org/licenses/by-nc-sa/2.0/).

