+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2017-12-07T22:36:00-05:00"
lastmod = "2017-12-08T11:10:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1512703844661/2017-12-08---sq---BOUND_MEDIA_012.jpg.jpg"
primary_image_credit = "Topher Mokrzewski, Music Director, and Miriam Khalil, soprano, rehearsing BOUND, Against the Grain Theatre, 2017. Photo by Darryl Block."
publishDate = "2017-12-07T22:46:00-05:00"
related_articles = ["articles/art-is-not-action.md","articles/a-response-to-our-response.md","articles/equal-parts-stressful-and-reverent-atgbound.md","articles/transformation-bound-v-2.md","articles/unraveling-bound-v2-second-time-is-also-a-charm.md"]
related_companies = ["scene/companies/against-the-grain-theatre.md","scene/companies/canadian-opera-company.md"]
related_people = ["scene/people/joel-ivany.md","scene/people/christopher-mokrzewski.md","scene/people/miriam-khalil.md","scene/people/justin-welsh.md","scene/people/david-trudgen.md"]
short_description = "A certain type of demographic goes to the opera, and perhaps there&#039;s only a small amount of overlap between that demographic and those who may understand more clearly what it feels like to be detained, mistreated, or bound by others&#039; rules."
slug = "atgbound-a-shocking-immediate-connection"
title = "#AtGBound: &quot;A shocking, immediate connection.&quot;"
+++

"It'll be a shocking, immediate connection to what is going on in the world today," says Joel Ivany, Artistic Director of Against the Grain Theatre, on the company's upcoming workshop production, [*BOUND*](http://againstthegraintheatre.com/bound/). 

Ivany and AtG Music Director Topher Mokrzewski team up with composer Kevin Lau to pair - in true AtG fashion - the old with the new. The old is the music of Handel, and the new is an original English libretto by Ivany that explores the contemporary stories of people who are captive, mistreated, and dehumanized. "All the characters who are involved are fighting for a right of some kind," says Mokrzewski. "They're fighting for rights that have been taken away." 

The music of Handel's operas seems to strike a unique balance between storytelling at extremely high stakes, and laying out a blank-slate-like foundation for varied facets of a single emotional state. The stand-alone arias make for clean excerpts, and lend them well to re-organization and re-appropriation. "Handel is kind of like the human element in all of us," Ivany adds.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1512703705997/BOUND_MEDIA_411.jpg.jpg)
<figcaption>Justin Welsh, baritone, and Joel Ivany, Artistic Director, rehearsing *BOUND*, Against the Grain Theatre, 2017. Photo by Darryl Block.</figcaption>
</figure>

Against the Grain Theatre is no stranger to a mash-up - or "smash-up", as Mokrzewski calls it. In 2016 they workshopped *No One's Safe*, a "Mozart Murder-Mystery Mash-Up", that used fragments of Mozart arias in a choose-your-own-adventure-style piece of immersive music theatre. *BOUND* is in part a response to a Handel-focused challenge posed by Alexander Neef, General Director of the Canadian Opera Company, where AtG has begun a two-year residency.

Rehearsing a work like *BOUND* has taken a reciprocal approach to developing its characters. Ivany has worked with the cast of singers in advance of the formal rehearsal process, to discover their ideas and opinions on various current events and news stories. "It's more ownership on the performer's side," says Ivany, who in creating his libretto encouraged the singers to search out the journalism that pulls their attention on various topics. "They're sending me those links to comb through and find words that victims have said, and I'm putting that into the aria."

<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1512703769669/BOUND_MEDIA_118.jpg.jpg)
<figcaption>Miriam Khalil, soprano, and Kevin Lau, composer, rehearsing *BOUND*, Against the Grain Theatre, 2017. Photo by Darryl Block.</figcaption>
</figure>

Alongside more standard rehearsal-room practices, there is time reserved for talking about tough subjects - "intimate things," Mokrzewski calls it - and guest speakers who can help connect the fictional to the real world. Ivany's focus on the refugee crisis called for a Q&A session with an immigration laywer, who told stories of her clients' struggles with red tape, distrust for the system, and inhumane detainment.

If you go to see a performance of [*BOUND*](http://againstthegraintheatre.com/bound/) this month, you'll find yourself in the midst of AtG's ongoing exploration of the opera-goer's experience. You may find yourself in a dystopian version of your current world, even pulled aside by officials who encourage you to give up your ID and phone while you wait, separated from your party, for no clear reason.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1512703786853/BOUND_MEDIA_010.jpg.jpg)<figcaption>Miriam Khalil, soprano, rehearsing *BOUND*, Against the Grain Theatre, 2017. Photo by Darryl Block.</figcaption>
</figure>

A certain type of demographic goes to the opera, and perhaps there's only a small amount of overlap between that demographic and those who may understand more clearly what it feels like to be detained, mistreated, or bound by others' rules.

*BOUND* is the first step in what Ivany and Mokrzewski hope is a long-term, larger-scale project. It's a chance to see the genesis of a work that's designed to shift and transform to suit both its artists and its external influences.

"At any given moment, at any place, humans suffer tremendously. And we don't know about it, we don't feel it, sometimes we don't care," says Mokrzewski of the function of a piece like *BOUND*. "I think that being able to see these very real situations, heightened by a music that is very pure in its emotional clarity, should be able to elicit quite an emphatic response."

>[BOUND](http://againstthegraintheatre.com/bound/) runs December 14-16 at the Canadian Opera Company's Hal Jackman Studio. For details and ticket information, follow our box office links below.
