+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2016-02-04T11:54:00-05:00"
lastmod = "2016-02-05T00:03:00-05:00"
preamble = "Conductor and keyboardist [Jordan de Souza](/scene/people/jordan-de-souza/) is currently assisting maestro [Johannes Debus](/johannes-debus-falstaff-comedy-and-teamwork/) on the [Canadian Opera Company](/scene/companies/canadian-opera-company/)'s production of [*The Marriage of Figaro*](http://www.coc.ca/PerformancesAndTickets/1516Season/TheMarriageofFigaro.aspx), and he'll be taking the podium for two performances, February 23 and 25.\n\nHe talks with us about high pressure gigs, uncovering Mozart's meaning, and leading the fantastic Canadian Opera Company Orchestra.\n\n"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1454606608307/2016-02-04---Jordan-de-Souza.jpg.jpg"
primary_image_credit = "Photo by Brent Calis."
publishDate = "2016-02-05T08:03:00-05:00"
related_articles = ["articles/potential-orchestra-mutiny-and-conductor-envy.md","articles/spotlight-on-christopher-james-ray.md","articles/spotlight-on-christopher-allen.md","articles/he-saidshe-said-songbook-vi.md","articles/power-plays-and-crossing-lines-.md"]
related_companies = ["scene/companies/canadian-opera-company.md"]
related_people = ["scene/people/jordan-de-souza.md"]
short_description = "Conductor and keyboardist Jordan de Souza is currently assisting maestro Johannes Debus on the Canadian Opera Company&#039;s production of The Marriage of Figaro, and he&#039;ll be taking the podium for two performances, February 23 and 25. He talks with us about high pressure gigs, uncovering Mozart&#039;s meaning, and leading the fantastic Canadian Opera Company Orchestra."
slug = "at-the-podium-jordan-de-souza"
title = "At the podium: Jordan de Souza"
+++

## Do you feel hype or pressure for your performances of Figaro at the COC?

Funny you should ask: I hadn't thought about it once until now! We get so immersed in the rehearsal process and are fortunate to spend enough time with the superb casts that the act of a full performance is a natural progression. Part of the challenge in conducting these long, dramatic pieces is understanding the architecture, micro and macro, so that the pacing is natural and serves the drama; through the staging rehearsals, we get the chance to examine every corner of the piece with a microscope and put it back together gradually. By the time we're running acts, we know where the waves ought to crest and fall and have built up the necessary confidence through repetition.

## What do you love about Mozart’s score that might not be obvious to every listener?

The rebellion happening underground. The musical and lexical tokens which we discover through the scavenging of score study reveal Mozart's profound sense of dramaturgy and his ability to portray the richness of the human context. There's never black and white with Mozart. 

Take those back-to-back duets that open the opera with Figaro and Susanna: a cursory glance suggests that they're equal partners singing innocent music on the morning of their wedding, but Mozart's compositional choices have deeper implications. The first duet in G+ is actually in ritornello-form, in which Susanna's music provides a displaced ritornello that eventually takes over Figaro's theme; this modest gesture implies that Susanna is the smarter and stronger one. The second duet moves three slots to the darker left of the tonal spectrum: the dramatic intrigue begins and the relationship deepens. We see Figaro's ignorance to the Count's intentions demonstrated through his bumbling buffo melody whereas Susanna, in her delicate and cunning manner, shows how adept she is at navigating stormy waters with her g-minor response and inverting phrase structures. 

Every page of this score is that deliberate and, dry though it could seem outside of the rehearsal room, I think these type of compositional choices are Mozart's portal to immortality.

## What kind of role do you think "tradition" plays in performing Mozart? Where’s the line between research and overthinking it?

Great question. I approach score study with a simple (modified) axiom: "The unexamined note is not worth singing". We won't delve into the history of performance practice in Mozart here but, suffice it to say, I think that we're in a very fortunate period in which people are willing to try just about any idea borne of true musical and dramatic inspiration. As long as we keep the goal of research and score study in mind, which is to serve the act of performance and interpretation, I don't think we run the risk of overthinking it. Yeats wrote about the Grape of Joy having to be crushed in order to be tasted most fully. There's something to that...

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1454606709795/De-Souza.jpg.jpg)
<figcaption>Photo by [Brent Calis](/scene/people/brent-calis/)</figcaption>.
</figure>

## What’s it like to step into an ongoing production (musical and otherwise)? How do you balance your decisions versus some level of consistency?

This is always a tricky balance to find. Being the assistant conductor means that you're not ultimately making the decisions but you still have to lead your part of the process convincingly and with conviction in rehearsals. Singers don't get enough credit for the impressive musicianship they bring: to be eternally adapting to new influences and for knowing their roles so well that they could spin out hundreds of different colours on a moment's inspiration. 

The staging process is our chance to make sure that the musical gestures and dramatic choices reflect each other; this gives us conductors the necessary information to prepare the orchestra. Mozart has a gift for having the orchestra deliver subtext of real emotional depth: that which the characters leave unsaid is revealed underground in the orchestra.

## What do you look forward to most for these performances?

Living in the present. There are occasionally times when I feel like my whole life has been preparation for a single moment. Having the chance to lead my first two performances of Figaro with an incredibly talented team in my hometown is a gift. I'm looking forward to stepping into the pit for performances #10 and #11 of the run. I will have never conducted a minute of the opera with the orchestra before the downbeat of the Sinfonia on February 23 and I think that's an exciting and challenging parameter! The musicians will know the piece extremely well by this point and will undoubtedly be very aware and responsive and I'll do my best to support everybody and create an environment in which they can all thrive. 

>The Canadian Opera Company's production of *The Marriage of Figaro* runs until February 27th. For details and ticket information, follow our box office links below.
