+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2017-02-25T16:41:00+00:00"
lastmod = "2017-02-26T11:21:00+00:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1488043709244/DVSzPkL_LBhgb0ApqobAE8qnbneRS0pwhChWCSSr7kWCdc1a7NQQJvz6C3z1KjV2s1ocTbVnC-ZxGn5p0OysjcrWU_4%3Dw1360-h1360"
primary_image_credit = "Photo: Marco Borggreve."
publishDate = "2017-02-26T11:21:00+00:00"
related_articles = ["articles/in-review-jamie-barton-at-wigmore-hall.md","articles/in-review-tim-mead-james-baillieu-in-recital.md"]
related_people = ["scene/people/matthias-goerne.md"]
short_description = "Not only did Hinterhäuser make for an uncomfortable start to a recital, but he seemed to behave it poor, selfish taste. Goerne seemed prepared to continue singing, even if Hinterhäuser needed to scramble to save the missed page-turn; yet this pianist decided to stop the whole thing entirely, draw attention to the human error that may have happened beside him, and force Goerne to restart."
slug = "at-arms-length-goerne-hinterhauser-in-recital"
title = "At arm&#039;s length: Goerne &amp; Hinterhäuser in recital"
+++

German baritone [Matthias Goerne](/scene/people/matthias-goerne/) returned to Wigmore Hall on Friday evening, for a recital of Lieder by Gustav Mahler and Hanns Eisler with pianist Markus Hinterhäuser. Each time we've heard him, [Goerne brings *gravitas* to the stage](http://www.schmopera.com/recitals-that-stick-matthias-goerne-at-wigmore-hall/); he creates ingenious recital programmes and seems to deliver no note without great thought.

With selections from Mahler's *Des Knaben Wunderhorn* and *Das Lied von der Erde*, and Eisler's *Hollywood Songbook* and *Anakreontische-Fragmente*, Goerne and Hinterhäuser gave a recital centred on themes of war, homeland, PTSD, and death as an escape. The pondrous, spiritual texts set by Mahler were a heavy backdrop for the curious poems of the *Hollywood Songbook*. Largely by Bertold Brecht, the songs seemed to be a real, tangible experience of war and loss, a dose of seedy humanity next to the elevated texts in Mahler songs like *Urlicht* and *Abschied*. 

Their recital was packed with wonderful music and touching words, yet Goerne and Hinterhäuser seemed to hold the audience at arm's reach. Hinterhäuser stopped playing in the middle of the first song (Mahler's "Der Tamboursg'sell"), visibly frustrated with his page-turner; though we're not entirely sure where the confusion lay, it was clear that a page didn't get turned when it should have been. 

It's a situation in which most pianists have been before, which is why it was particularly stunning to see Hinterhäuser take his hands off the keys, to make a gesture that seemed to say, "I can't work like this." The three men had a quick onstage discussion, where Goerne reminded the page-turner of his duties; it struck us as odd, since out of all the reasons to make a mistake, it's very unlikely that the page-turner didn't understand the concept of turning pages.

Not only did Hinterhäuser make for an uneasy start to a recital, but he behaved in poor, selfish taste. Goerne seemed prepared to continue singing, even if Hinterhäuser needed to scramble to save the missed page-turn; yet this pianist decided to stop the whole thing entirely, draw attention to the human error that may have happened beside him, and force Goerne to restart.

It's one of those things that happens in live performance; no more incidents occurred, but we were certainly on edge each subsequent time the page-turner stood up. The two men made beautiful music together - Goerne's instrument is constantly beautiful, and Hinterhäuser was a sensitive partner - but little of it seemed in the vein of telling stories. There was a clear respect and love for this music, yet Goerne often turned away from the audience, seeming to take on a conductor-like role for Hinterhäuser.

It's hard to say whether we would have felt the same isolation from this recital, if the page-turning situation hadn't occurred. In the past, the seriousness with which Goerne approaches his work has been [something to admire](http://www.schmopera.com/recitals-that-stick-matthias-goerne-at-wigmore-hall/); in this latest Wigmore recital, it felt uncomfortable.

The Song Recital Series at Wigmore Hall continues on **February 26, 7:30pm** with [tenor Nicholas Phan and pianist Myra Huang](https://wigmore-hall.org.uk/whats-on/nicholas-phan-myra-huang-201702261500), and on **March 12, 3pm** with [tenor Ilker Arcayürek and pianist Simon Lepper](https://wigmore-hall.org.uk/whats-on/ilker-arcayuerek-simon-lepper-201703121500). For details and more listings, [click here.](https://wigmore-hall.org.uk/whats-on/whats-on)
