+++
author = ["authors/meghan-klinkenborg.md"]
categories = "Review"
date = "2017-11-20T11:00:00-05:00"
lastmod = "2017-11-21T11:45:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1511229977506/2017-11-20---square---DSC_5502.jpg.jpg"
primary_image_credit = "John Moore and Elise Quagliata in *As One*, Des Moines Metro Opera, 2017. Photo: Duane Tinkey."
publishDate = "2017-11-20T21:07:00-05:00"
related_articles = ["articles/moving-stories-as-one-at-chicago-fringe-opera.md","articles/confusing-creepy-proving-up.md","articles/a-nextlevel-fledermaus-in-des-moines.md"]
related_companies = ["scene/companies/des-moines-metro-opera.md"]
related_people = ["scene/people/elise-quagliata.md","scene/people/john-moore.md"]
short_description = "I was struck most in Hannah&#039;s story by how significant seemingly small things became. Her handwriting was the greatest example of this. It had never occurred to me that handwriting could be so gendered and a source of exposure for a trans person. Much of Hannah&#039;s childhood is spent trying to be the perfect boy, and even her handwriting has to fit the perception of masculinity."
slug = "as-one-they-both-took-risks-that-paid-off"
title = "As One: &quot;they both took risks that paid off.&quot;"
+++

Unlike the trajectory of many new operas, *As One* is already on track to become one of the most frequently performed modern works. The opera premiered in 2014, and since then it has been performed at an increasing rate. [Des Moines Metro Opera](/scene/companies/des-moines-metro-opera/) is the thirteenth company to produce [*As One*](http://desmoinesmetroopera.org/education-and-community/second-stages-series), and there are many more upcoming performances scheduled across the nation within the next year. (*Dead Man Walking* better watch its back. *As One* is coming for ya!)

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1511193410014/2017-11-20---DSC_5281.jpg.jpg)
<figcaption>John Moore and Elise Quagliata in *As One*, Des Moines Metro Opera, 2017. Photo: Duane Tinkey.</figcaption>
</figure>

Des Moines Metro Opera's timing of their production was perfectly planned, falling at the end of Transgender Awareness Week. Like many of the operas they choose for their [2nd Stages Series](http://desmoinesmetroopera.org/education-and-community/second-stages-series), *As One*'s subject matter hits the audience with a relevant topic and sparks a meaningful discussion. Opening night was made even more special by the presence of the creators of *As One*, composer Laura Kaminsky and co-librettists Mark Campbell and Kimberly Reed. 

After the performance, Des Moines Metro Opera in collaboration with [One Iowa](https://oneiowa.org/) facilitated a post show talkback with a panel consisting of the creators, performers, production team, and local trans and LGBTQ activists. The discussion brought another layer to the evening, prompting self-reflection and creating new dialogues for all involved. This post show talk back has become a regular part of the 2nd Stages Series experience, and in my opinion, it is a crucial part of giving the artistic message a fuller impact. This face-to-face interaction pushes the audience out of their comfort zone in the best way possible.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1511193501979/2017-11-20---DSC_5588.jpg.jpg)
<figcaption>John Moore and Elise Quagliata in *As One*, Des Moines Metro Opera, 2017. Photo: Duane Tinkey.</figcaption>
</figure>

*As One* tells the story of Hannah, a transgender woman on a journey to discover her true self. It is a vulnerable and intimate journey, and the entire production is stripped down visually, musically, and emotionally. Instead of a full orchestra and large cast, Kaminsky employs only a string quartet and two singers to convey Hannah's experience, and in this case, less is definitely more. The music gets to the core of Hannah's emotions, and Kaminsky manages to create a wide range of colors and textures with the four stringed instruments that add subtext to every moment. 

The opening of the opera features the string quartet alone on the stage, the viola playing a yearning theme, representative of Hannah, while the other three undulate beneath. (Finally the viola is getting a moment to shine!) The instrumentalists and conductor also get the opportunity to show off their vocal abilities, singing Christmas carols quietly in the background during some scenes. The conductor even interacts with Hannah as the stern school teacher during a poetry discussion. *As One* calls for every performer to push beyond their comfort zone, and it feels like a true ensemble piece because of that.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1511193513189/2017-11-20---DSC_5366.jpg.jpg)
<figcaption>John Moore and Elise Quagliata in *As One*, Des Moines Metro Opera, 2017. Photo: Duane Tinkey.</figcaption>
</figure>

The one and only character of the opera is portrayed by two singers, a baritone and a mezzo, Hannah (before) and Hannah (after) respectively. One might assume that the baritone would sing the first portion of the opera and the mezzo would take over after a point of transition, but the librettists stressed that this is not a story of Hannah changing into a new person but rather finding and becoming who she truly is. Thus, both vocalists sing throughout the opera, interacting with each other physically and musically. 

Singers [John Moore](/scene/people/john-moore/) and [Elise Quagliata](/scene/people/elise-quagliata/) bring Hannah to life as a team, and their voices naturally complement each other. While their ranges only line up for short segments, the style and tone of their performances make it clear that they are portraying many facets of the same person. I have seen both Moore and Quagliata in previous Des Moines Metro Opera productions, and while it could be argued that this piece does not display the vocal fireworks I know they are capable of, *As One* allows the two singers to flex their acting muscles in a big way. This production calls for emotional variety and power, and they both took risks that paid off. The roles are also incredibly physical, involving climbing over chairs and running around the performance space with no opportunity to step offstage and catch their breath. How they did this for 75 minutes without getting one drink of water, I cannot fathom.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1511193524183/2017-11-20--DSC_5371.jpg.jpg)
<figcaption>John Moore and Elise Quagliata in *As One*, Des Moines Metro Opera, 2017. Photo: Duane Tinkey.</figcaption>
</figure>

The creators of *As One* emphasize that they wanted Hannah to be relatable, and they accomplish this in many ways. As a transwoman, she experiences struggles and pain, but the overarching emotion of the opera is one of joy. There are moments of humor and freedom along the way to self-discovery in addition to the negative moments. The first scenario in which Hannah’s agitation becomes more potent is sex ed class, but alongside her distress, she is still giggling and whispering the scandalous word (sex!) Most of us can relate to that memory of being segregated by gender for the talk and the many emotions that come with it. 

I was struck most in Hannah's story by how significant seemingly small things became. Her handwriting was the greatest example of this. It had never occurred to me that handwriting could be so gendered and a source of exposure for a trans person. Much of Hannah's childhood is spent trying to be the perfect boy, and even her handwriting has to fit the perception of masculinity. When she finally lets go and writes naturally, the music becomes lyrical and joyful. Kaminsky carries this concept through the rest of the opera, and the vocal lines are always the most beautiful when Hannah is experiencing the freedom of being herself. Other scenes pack a negative emotional punch that is disorienting (when Hannah first takes hormones) or unsettling (when Hannah is assaulted by a stranger). Kaminsky's music is much more dissonant when Hannah is at odds with herself, and this musical contrast between the character's alternating emotions is effective.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1511193538974/2017-11-20---DSC_5471.jpg.jpg)
<figcaption>John Moore and Elise Quagliata in *As One*, Des Moines Metro Opera, 2017. Photo: Duane Tinkey.</figcaption>
</figure>

The final section of the opera takes place in Norway where Hannah isolates herself at a cabin and comes to terms with herself. Hannah repeatedly asks "Why am I here?" and I was similarly inquisitive. Why Norway? Is Hannah a big fan of fjords? Did she get an intense craving for lutefisk? It is unclear whether the specific location is significant or whether any isolated place would have worked just as well. 

The majority of the opera had both singers fairly equally involved, but this last portion was dominated by the mezzo, Hannah (after). The baritone was still physically part of the action, but he only sang at the very end of the scene. There may have been a specific reason why the composer chose to do this, but it felt contradictory to the rest of the piece. Both parts of Hannah were with her for her entire journey, so why was Hannah (before) deprived of a voice for this pivotal moment?

Kaminsky weaves many of the earlier themes of the opera into the Norway scene, connecting Hannah's journey conclusively. The opera ends with both voices combined in a sense of unified harmony (which is an oxymoron but somehow appropriate for this story). Hannah has found herself and with self-acceptance comes freedom. Next time you need to get your life figured out, just run away to Scandinavia!
