+++
author = ["authors/jenna.md"]
categories = "Op-ed"
date = "2015-05-16T13:38:00-04:00"
lastmod = "2017-09-13T21:25:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505351983918/2017-09-14---Administration.jpg.jpg"
publishDate = "2015-05-19T08:41:00-04:00"
related_articles = ["articles/tshirts-and-tender-artists.md","articles/why-this-opera-singer-took-a-nonsinging-job-at-an-opera-company.md","articles/tosca-the-nyco-renaissance.md","articles/musicians-sexual-harassment-blurred-lines.md","articles/new-roles-janaka-welihinda-of-myopera.md","articles/audition-season-or-the-annual-festival-of-shattered-dreams.md"]
short_description = "Artists are such neat people because they&#039;re a creative bunch, not an organized bunch. Good, employable artists know that they can&#039;t be flighty, or bad at returning emails, or constantly late; yet it&#039;s not hard for me to imagine the artist that, left to his or her own devices, would probably keep odd and inconsistent hours, a messy workspace, and they&#039;d occasionally get wrapped up in their work enough to forget to buy groceries. "
slug = "artists-administration-reputations"
title = "Artists, administration &amp; reputations"
+++

Everybody loves an artist in one way or another; they're such an alluring group of people because they're a creative bunch. Creative, absolutely; yet they're not often thought of primarily as an organized bunch, and there's some truth to that stereotype. Good, employable artists know that they can't be flighty, or bad at returning emails, or constantly late; yet it's not hard to imagine the artist that, left to his or her own devices, would probably keep odd and inconsistent hours, a messy workspace, and they'd occasionally get wrapped up in their work enough to forget to buy groceries. 

This is fine and often charming, since the creative work gets done all the same. But it's still important to talk about the administrative work that makes the creativity possible.

In the opera world, performance outlets like [schools](/entire-mfa-class-drops-out-of-usc/), summer programs, festivals and opera houses all have administrative departments of varying sizes. There's never enough money in the arts, so it can be considered somewhat luxurious to have a group of people dedicated strictly to administration. More often than not, artists are the ones who are inspired to start these performance outlets, and as a fledgling company is still growing, those artists are doing double duty as administrators and performers. 

So, take a dearth of money, a small but mighty leadership team, and probably very little real administrative training, and the results are unpredictable.

## The problems

This is all really only relevant because it can negatively effect the development of young singers, pianists, directors, and conductors. Perhaps not in the same way as a doing-more-harm-than-good-type of voice teacher, but it matters. It's not even about the staples like paying staff on time or adhering to contracts. 
- Small-seeming things like schedule conflicts can stress people out; singers might be double-booked for a rehearsal and a lesson, and they might or might not get to decide which one to attend. 
- Poor or little communication about accommodation and travel details aren't great either; artists can end up paying more for flights/trains, etc., waiting for the full picture and the go-ahead from Opera Administration. 
- Singers might not get the heads-up that they should have packed a tux, or *specifically not a tux*, or a towel, or flip-flops for the shower; these are avoidable annoyances that can translate into an artist's mood, which can bleed into their work, ultimately hindering the point of it all. (You may deem this bit babysitting, but it speaks to an administration's care and respect for its program employees or participants.)

Poorly organized administration in the performing arts is common, enough for frequent conversation material over drinks. Tight budgets are a constant hurdle, and on top of the obvious constraints that money presents, other problems come from artistic people doing work that a) they're not fully trained to do, and b) for which they're not really the type. It's not a matter of being ill-equipped, but it's often a matter of being stretched too thinly. 

The arts is a subjective business, but administration needs to stay objective; it's hard to stay objective when a) there's too much on your plate, b) you're fielding questions and complaints all day long, and c) you take problems personally and handle them defensively.

## The solutions

Personnel costs for an administrative department should hold a higher place in line when it's time to divvy up the company's expenses. Having a team of trained, objective administrators does arguably more good for young professionals than an expensive production in a pricey theatre, for example.\* 

It's understandable, the urge or perhaps the need for leadership to take on some of their own admin work, or for having a particularly organized friend take care of the schedule. But this stuff really matters, not only for the humane treatment of your artists' day-to-day life, but for the reputation of the company; "organized person" doesn't always equal "professional administrator". This world is small, and stories of poor communication and a few ignored emails in a row can result in some unofficial (but powerful) bad word-of-mouth.

What's to be done? Rearrange the frustratingly small amount of money available for the arts. Frankly, if you've run out of money for at least one professional, objective administrator, you went over budget a while back. Young artists in particular can be left with few good options for work; if singers don't want to work with disorganized bosses, that leaves a big leap to get gigs with larger, better-funded companies who have more pros on hand getting things done. 

Of course, if you're an artsy-type who really does have a handle on your admin duties, we applaud you for taking on two huge jobs. This is another reason that arts administration is gaining more value in post-secondary music education, because as an individual entrepreneur or as a company, the music has to stop once in a while in order to raise money and deal with your crowded inbox.

\*Whether we're talking about a places to create opera, professional or otherwise, there could be a few financial/artistic trade-offs that could help the artists without hurting the artistic experience; community outreach performances, for example, could make use of (read: employ) more artists while keeping overhead and production costs lower with smaller, pared down, portable shows.


