+++
author = ["authors/vanessa-chumbley.md"]
date = "2016-12-11T17:07:00+00:00"
lastmod = "2016-12-14T09:31:00+00:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1481476776187/2016-12-11---Help.jpg.jpg"
primary_image_credit = "Photo by Michael Wacker."
publishDate = "2016-12-14T09:31:00+00:00"
short_description = "This field is small, it is competitive. I understand the urge to protect your job(s) and hold onto employment you’ve worked hard to get. This is a deeply rooted urge, grown from the subconscious fears that &quot;I am not good enough&quot; and &quot;Maybe this other person could do it better&quot;. In some people, this manifests into a refusal to help others up the ladder, an inability to send the elevator down for someone perceived as a threat."
slug = "artistic-success-pay-it-forward"
title = "Artistic success: pay it forward"
+++

Kevin Spacey has been quoted as saying, "If you're lucky enough to do well, it's your responsibility to send the elevator back down." This sentiment actually did not come from Spacey directly; he credits it to Jack Lemmon, an actor whom Spacey met in his early career and who later became a life long mentor. It was Lemmon who first instilled the idea of "sending the elevator back down" for future generations in a young Kevin Spacey.

He is taking the advice to heart; he has developed the [Kevin Spacey Foundation](http://www.kevinspaceyfoundation.org/), his [Masterclass](https://www.masterclass.com/classes/kevin-spacey-teaches-acting) lessons are extremely popular and he frequently visits the drama students at his alma mater, Juilliard. It is clear that Spacey feels indebted to not only Jack Lemmon, but all of the mentors throughout his career who helped him along the way, and now feels strongly about paying it forward. (Coincidence that he starred in a movie titled *Pay It Forward*? I think not.)

This idea of helping those below you on the proverbial “ladder” is something I have been thinking about a lot lately. I still greatly rely on those above me to lend a helping hand, but I’m also entering a phase of my career where I am in a position to help those just beginning their climb. 

I have been very fortunate in my own ascent within this career to know multiple people who have taken a chance on me, given me opportunities when there was no guarantee of my success or abilities, and sent the elevator down for me. I have also known a handful of people whom, for whatever reason, have made it clear that they have no intention of holding the doors for me. 

This field is small, it is competitive. I understand the urge to protect your job(s) and hold onto employment you’ve worked hard to get. This is a deeply rooted urge, grown from the subconscious fears that "I am not good enough" and "Maybe this other person could do it better". In some people, this manifests into a refusal to help others up the ladder, an inability to send the elevator down for someone perceived as a threat. 

Despite those few, I believe the majority of people out there are committed to educating and supporting the upcoming generation of artists, designers, stage managers, etc. Those bright spots are strewn across my career, making up the constellations that foretold my arrival to today. For better or for worse, I would not be where I am today without the people who sent the elevator back down for me, as well as those who did nothing as they watched me frantically running towards the closing doors – and thereby forcing me to find an alternative route. 

It may be that for some, the wording of Spacey’s quote is off putting – "lucky" implying that success was achieved through chance rather than years of dedication and hard work, and "responsibility" implying an obligation. I truly believe he used the word "lucky" to mean that there are countless people in this business who put in the same years of sweat, tears, and work as others and still did not achieve success, and therefore there is an element of luck when one of these people becomes successful over another. In other words – being in the right place at the right time, and knowing the right people – particularly those who will give you a foothold as you climb. 

While there is an argument for ushering in the new generation being an obligation, maybe "privilege" is a better way to think of it. *{Privilege: noun: A benefit enjoyed only by a person beyond the advantages of most.}* If you are advantageous enough to be in a position to help those beginning their climb up the career ladder, is it not a privilege to be looked up to as a mentor and teacher? Is it not a privilege to teach those just starting out what you were once taught? To help guide the new generation as you were once, inevitably, guided?

As I grow in this career and begin to find myself in positions to help those just starting out – I too have been guilty of falling into the void of insecurity and self-doubt at times. When that happens, I remind myself of my mentors during those crucial early years as a young stage manager, and how they taught and guided me with discipline but also with patience. I hope to be that person for others someday. And if you find yourself too stuck and bound by fear to lend a helping hand, I urge you to remember the reasons you got into this field in the first place, and the people that helped you along the way. No one becomes successful in a vacuum.
***
Photo: [Michael Wacker](https://www.flickr.com/photos/michael_wacker/) via [Flickr.](https://creativecommons.org/licenses/by-nc-nd/2.0/legalcode)
