+++
author = ["authors/christopher-mokrzewski.md"]
categories = "Editorial"
date = "2016-11-10T10:56:00+00:00"
lastmod = "2017-01-17T11:35:00+00:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1478805992437/2016-11-10---Action.jpg.jpg"
publishDate = "2016-11-11T11:00:00+00:00"
related_articles = ["articles/why-we-must-keep-on-keepin-on.md", "articles/things-more-important-than-opera.md", "articles/a-response-to-our-response.md", "articles/arts-money-waste.md", "articles/arts-education-teaches-better-manners-more-preaching-to-the-choir.md", "articles/dont-miss-id-please.md", "articles/when-art-is-not-enough-opera-activism.md", "articles/in-review-sweat.md", "articles/getting-vexed-over-wagner-other-narcissisms.md", "articles/atgbound-a-shocking-immediate-connection.md", "articles/greg-jennas-roundup2017.md", "articles/leaning-into-the-discomfort.md", "articles/wherefore-art-thou-opera.md"]
short_description = "If you seek change, do more: engage, vote, donate and work for your political party, protest, write petitions, run for office, do not take money from dubious sources out of alleged necessity and do not support or enlist those artists who do. It is our duty, as artists, and as citizens, the be a part of the process."
slug = "art-is-not-action"
title = "Art is not action"

+++
When is the last time you felt this badly?

It's been less than twenty four hours (at the time of writing) since Il Duce (aka Donald Trump) went from seemingly impossible presidential hopeful to president-elect, and still, for the most part and for so many of us, the shock has not worn off.

We're so often told, usually in the spirit of affirmation and hope, that anything is possible. Indeed, the impossible is very possible and there's no good reason, in considering history or recent events, to believe that such a truth works solely to the benefit of progress. It pains me to say so, but after many, many centuries of human existence, it seems as though the prospect of a better tomorrow remains still a notion as far away from realization as it was fifty, one hundred and five hundred years ago.

And so, we grieve today.

For those who had hopes of a different future for the most prominent democracy that has ever existed in the world, these days are ones of sadness and of coming to grips with reality. This process is natural and manifests itself in various forms. Many have taken, for their own sanity no doubt, an optimistic stance. Despite, they say, all evidence to the contrary, perhaps some sort of order will be re-established. To those people I can say, only, that I hope you're right and that I cannot share your enthusiasm, though I appreciate your capacity to do so.

For those of us involved in artistic pursuits there is an additional aspect of this optimism. Many of my colleagues have taken to social media, or have said to me in person, that these types of unprecedented moments in history bring to light more fervently than usual the need for the arts to serve as a force for good in society. It's a kind of doubling down on the "when they go low, we go high" trope so oft cited in these last days of the election. On principal, and because I am a person involved in that artistic realm, I'm inclined to agree.
But I cannot help, at the same time, feeling a certain degree of resistance to the notion that art, in and of itself, is a suitable answer to the problems we experience in our times.

>Art, in its various guises, is an essential means of examining and reflecting back the climate from which it is born.

At this moment I am in the process of preparing a production of _Die Fledermaus_ at [Calgary Opera](/scene/companies/calgary-opera/). Last evening, as I watched the election results unfold via an NBC live stream as we rehearsed (shameful, I know, to have not been present in the moment) I could not help chuckling to myself at the irony of working on this cynical, though fun, piece of fin de siècle puff pastry amidst global events of a much less cheery variety. History really does repeat itself, doesn't it?

Indeed, inherent in a piece like _Fledermaus_ is the dualism of gay frivolity and shameless self deception. It is a piece of moral decay and, at the same time - and happily so, for too much moralizing can grow quite tiresome - an exercise of laughing in the face of the meaninglessness of existence. Social strictures are ridiculed, the order of things redrawn. At the end of the piece, despite the consistent laugh track, no one is left intact. Like any great work, it means more than it presents on first glance and adapts well to the cultural notions of multiple epochs.

And so, with this in mind, we come to the fundamental pillars of the belief that Art Matters. By virtue of being a reflection of the obvious or subtle cultural currents at play in society at large, art, in its various guises, is an essential means of examining and reflecting back the climate from which it is born. At the same time, and to a greater or lesser degree, it is almost always, in a Western capitalist sense, a form of entertainment. Ideally, at times, it might even be fun. These facts are all worth keeping in mind.

>We so often preach to the choir, to put it simply. And this is not necessarily a crime - when such a luxury is possible.

When Shostakovich wrote his symphonies, or Kundera wrote his early works (before his exile in France) these creative ventures not only served as reflections of the events happening at the time, but were also acts of self expression and protest in a situation where no more overt or explicit means were possible. In the current climate few, though not all, of us endure such struggles. We are free to write, compose and critique at will. This freedom, which we take very sorely for granted, has the capacity to leave us quite removed from certain very essential touchstones of reality.

>Art is an imperative force and an essential part of the human experience. We need it vitally. Yet the notion that it can solve complex global problems, in and of itself, seems to me both misguided and self involved.

It is so very easy, in the land of the free, to say whatever I wish, and for it to resonate with those who agree with me, free as they are to consume it if they have the means and will to do so. We so often preach to the choir, to put it simply. And this is not necessarily a crime - when such a luxury is possible.

Yet there are moments, and we are encountering such an instance it seems, when this kind of active complacency is no longer a viable option. When we are faced with the vilest aspects of our own nature - with tyranny, bigotry, racism, misogyny, cruelty, violence and ignorance - we as artists must at once rise to the occasion, find new and impactful ways in which to speak out and be heard and to affect change in our communities, in our countries and globally. At the same time we must also recognize the inherent limitations of art's capacity to shape the world around us.

Art is an imperative force and an essential part of the human experience. We need it vitally. Yet the notion that it can solve complex global problems, in and of itself, seems to me both misguided and self involved.

>At this critical juncture I can proudly proclaim my belief that art, in all its forms, can have a profound effect upon humanity.

In light of recent events and the response of many of my colleagues, I am reminded of a scene from _Manhattan_, one of Woody Allen's most famous films. Early in the film, Woody's character attends a Metropolitan Museum gala fundraiser in support of some cause or other. Here assembled are the crème de la crème of the liberal elite and the intelligentsia. Socializing in a smaller group of writers and filmmakers, Woody's character jokingly suggests that they might, armed with some bats and bricks, assemble together to break up a Neo-Nazi parade set to occur in the streets of Manhattan some time in the near future. One other member of the group mentions "a devastating satirical piece" on the subject which he read in some periodical. Really hard hitting stuff. In response, Woody, and I paraphrase, states that satirical pieces are one thing, but bats and bricks have the capacity to really bring the point across.
I'm not stating that bats and bricks - violence, in other words - are the answer. And nor was Woody. This scene, instead, is meant to highlight the fact that the opposing values at play in any given political circumstance are concrete and related to, more so than just the world of ideas, the real world of action and events.

And this is precisely where the mostly laudable sentiment that Art Matters can become problematic. It's a warm security blanket that protects us from the outside world. It seems to me that too many of us are inclined to participate in a circular dialogue that so often bears no effect upon the community around us. We're too busy worrying about affirming our own ideology and value (and funding it!) that we do not recognize that our work sometimes leaves no mark in the arena that really matters: the broader sphere of culture and of public discourse. We are not, in other words, fully engaged in the process of our democracy.
At this critical juncture I can proudly proclaim my belief that art, in all its forms, can have a profound effect upon humanity. In moments of tragedy, a public performance of the Mozart Requiem or a Mahler symphony can serve as catharsis. Indeed, when confronting our own demons, alone at night, who has not found some manner of peace or a moment of joy through Beethoven or Louis Armstrong or The Beatles?

A great work of literature helps us to understand the human condition and, indeed, our own feelings as persons living in this time. When you read Tolstoy, you know that people have felt the way you have since time immemorial. Our human existence is essentially, and no matter what our time and place, the same. We'd do well to remember that in our darkest hours, both personal and communal.

>No more passivity, no more intellectual recalcitrance, no more separation of art and state. We need a little less warm and fuzzy and a little more grit.

At the same time, art is fundamentally not an end. It can be used for any number of purposes, serious or comic, frivolous or important. It need not only be purely utilitarian. But it is too easy for us to retreat to the cloudy realm where we engage with each other and no one else. We write words of tremendous import, maybe, but they echo around us and are not heard by those for whom they should matter most.

It should not be forgotten, therefore, that our acts of creativity are an additional benefit and privilege of living in the time and place that we do, and cannot be a passive substitute for real engagement in the political process, or for action in the real world.
I hope we will all continue to write, to compose, to contest and to speak out, but we must find ways to do so not only within but also without our own sphere. I implore you not to retreat but to make an impact in a context broader than your own. And, more importantly, I ask that we all not forget our duties as members - although somewhat tenuous, it seems at times - to society proper.

Do not mistake your personal artistic work with the fundamental requirements of citizenship. If you seek change, do more: engage, vote, donate and work for your political party, protest, write petitions, run for office, do not take money from dubious sources out of alleged necessity and do not support or enlist those artists who do. It is our duty, as artists, and as citizens, the be a part of the process. It is only through participation that we can adequately work to make substantive change. No more passivity, no more intellectual recalcitrance, no more separation of art and state. We need a little less warm and fuzzy and a little more grit.

Above all, be confident in your convictions and fight - because it really is always going to be a duel of ideas - for the causes in which you believe and for the values which you hold dear. It is only by these means that art, and artists, can really make a difference.
Feel better soon, and good luck out there.