+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2016-06-19T16:57:00-06:00"
lastmod = "2016-06-22T11:16:00-06:00"
preamble = "Canadian composer [Jeff Smallman](http://www.jeffsmallman.com/)'s chamber opera, [*Pat & Emilia*](http://patandemilia.wix.com/opera), tells a story that cuts to the quick about the lives of artists. Based on the lives of photographer Pat Sturn and opera singer Emilia Cundari, both from Windsor, Ontario, *Pat & Emilia* is the story of two women who make decisions about their artistic careers, and how they find balance between their work and their family life. Pat turned down a marriage proposal in order to focus on her career, while Emilia chose her family over her singing.\n\nThe choice isn't always binary, and we've met plenty of singers who refuse to make an \"either/or\" decision about work and family. Still, it's one of the biggest points of crisis for a working artist, and there's something fascinating and meta about how Smallman's opera, and the singers in it, unpack this familiar story. We had the chance to ask Smallman about the positive reception of *Pat & Emilia*, and what he and the creative team learned from its creation."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1466379204824/2016-06-20---Pat-and-Emila-Opera-EVENT-POSTER.jpg.jpg"
publishDate = "2016-06-21T20:08:00-06:00"
related_articles = ["articles/childfree-opera-singers-happiness.md","articles/arianna-zukerman-youve-got-to-live-your-truth.md"]
short_description = "The choice isn&#039;t always binary, and we&#039;ve met plenty of singers who refuse to make an &quot;either/or&quot; decision about work and family. Still, it&#039;s one of the biggest points of crisis for a working artist, and there&#039;s something fascinating and meta about how Smallman&#039;s opera, and the singers in it, unpack this familiar story."
slug = "art-imitating-life-pat-emilia"
title = "Art imitating life: Pat &amp; Emilia"
+++

## Can you tell us about the performance history of *Pat & Emilia*? 

*Pat & Emilia* is a chamber opera with texts by Tara Sievers-Hunt and Marty Gervais.  It was begun as a song cycle commission (more on that later) in 2013 and slowly developed into its current form. 

The opera was premiered at Willistead Manor in Windsor, ON on March 15, 2015, and then received its US premiere the next day at Marygrove College in Detroit.  Including the premiere, it's been performed 11 times so far, with a good balance between the States and Canada.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1466380568300/2016-06-20---pat-n-emilia1.jpg.jpg)
</figure>

## In writing this opera, what have you discovered about the artist's common challenge of "choosing" career or family?

That it really is a common challenge!  I know it's not the only one, but making a career as a musician is something that takes a lot of time and even more dedication.  Every musician that I've spoken to about the opera has said the same thing, that they relate to the story specifically because of the choices that each woman made.  It's rare that someone has success from the beginning and then sees that success continue throughout their career.  When success is happening in a person's life, the choice is an easy one.  But, it's when the harder times start happening that your confidence in the process (or even your own ability) can be shaken, and then the "choice" starts staring you in the face, demanding to be acknowledged. 

Finding a balance between career and family can be tricky.  As a composer, I've tried to find the best times for writing that interfered the least with my "family time."  Even then, there have been the inevitable conflicts.  I would think life as a performer would be even harder.  For some (as with Emilia in the opera) the choice can boil down to a "black & white" question of do I want a career OR a family.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1466380590142/2016-06-20---Jeff-Smallman.jpg.jpg)
<figcaption>Composer Jeff Smallman.</figcaption>
</figure>

## How do you think this choice is different for women versus for men?

That's a tricky one.  I guess one of the most obvious ways would be when the question comes down to whether or not to have kids.  I know artists who have been married to other artists and have had to spend a lot of their time apart.  That causes its own stresses and takes a lot of work to make successful.  But to be a musician with children trying to maintain this type of schedule while keeping a healthy home life is something else again.  And I would think that, for example, being a female singer who becomes pregnant could result in difficulty finding available roles during the later part of the pregnancy.

## What kind of connection did you perceive between the story and the singers who sang the roles of Pat and Emilia?

It's funny.  The original project was to be a song cycle.  The soprano who was brought into the project (Tara Sievers-Hunt) was researching the character of Pat Sturn (a 100-year-old photographer who was the subject of the text) and started digging into finding out more about a woman who was referenced in the lyrics.  This woman turned out to be Emilia Cundari (an opera singer & the second character in the opera).  As the research progressed, the project transformed into a chamber opera.  The original plan had been to have Tara sing the part of Pat, but as the project developed, she realized that it was Emilia she should be singing instead, which is what happened.  Even more interesting is the fact that Tara currently has the exact same job at Marygrove College that Emilia had years ago! 

The other soprano brought in to sing the role of Pat is Jocelyn Zelasko.  She modelled her portrayal of Pat on her own grandmother.  (Sadly, her grandmother passed away immediately before the premiere.  Jocelyn is a trooper, though, and did an amazing job of performing!)  Jocelyn obviously connected with the character because there have been several people who knew Pat Sturn when she was alive who have commented that they would have believed it was Pat on stage herself.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1466380599256/2016-06-20---Pat-n-Emilia2.jpg.jpg)
</figure>

## What kind of reception has the opera had so far?

Better than I could have ever expected!  The premiere received a 5-minute standing ovation.  Several performances have been sold out, and there have been requests to have the work performed in other places.  I think the audiences' comments say the most, though.  Here are some that we've received…

- "It was well performed, enchanting, lovely, unique."

- "Sometimes you go to a new opera expecting great music and you leave with your mind blown from the great music and the touching and powerful message. Beautiful singing and such a meaningful performance in so many ways!"

- "Tonight a page was turned in the history of Canadian music. The chamber opera, "Pat and Emilia" had its premier this evening at Willistead Manor. It is an inventive and provocative collaboration of music, poetry, journalism and personal monologue for two sopranos and chamber ensemble of violin, clarinet, cello and piano. The audience is dramatically led through the lives of two women, two Windsorites, and the hard decisions they each had to make.

- "It is a musical drama that must be experienced. Tonight was the culmination of years of work but truly it is the beginning of something quite special. Thank you to all those creative spirits who gave wings to tonight's offering."

- "That was truly spectacular!"

And I received this in an email from one of the chamber musicians:

"There were a few colleagues from the orchestra in the audience as well as a nice young woman who came to me to tell me how much she liked our performance. They all had very interesting things to say, mostly how moving the story and the music were. A violinist (a man) admitted that he cried during the second act. Stephanie from the Windsor Symphony Orchestra told me that last night she watched the faces of 2 of the musicians who had stayed (2 men) and they looked so moved."

Moving an audience is really a sign of good writing and composing.

This young woman tonight said that she had rarely seen an audience so absorbed by the story. She wanted to know more about Pat. 

We, musicians, also really appreciated our WSO colleagues' positive comments. It meant a lot to us, they were not just polite.
