+++
author = ["authors/joshua-borths.md"]
categories = "Editorial"
date = "2015-06-05T16:02:00-04:00"
lastmod = "2015-06-11T18:44:00-04:00"
preamble = "This is a piece by written Josh Borths, Education Manager at [Arizona Opera](http://www.azopera.org/), for AO's great [blog](http://www.azopera.org/blog/). To read the original article, [click here](http://www.azopera.org/blog/what-traditional-opera)."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1433558423137/ArizonaFlute.jpg.jpg"
primary_image_credit = "Photo by Tim Trumble, from Arizona Opera's 2015 production of The Magic Flute"
publishDate = "2015-06-11T18:37:00-04:00"
related_articles = ["articles/who-cares-what-bring-on-the-why.md","articles/opera-for-firsttimers-thinking-outside-the-box.md"]
related_companies = ["scene/companies/arizona-opera.md"]
short_description = "“Is this going to be a traditional production?” As the Education Manager at Arizona Opera, this is the question I am asked most about operas in our upcoming seasons, and I must confess, I don’t really know how to answer it. After all, what tradition are we talking about?"
slug = "arizona-opera-on-tradition"
title = "Arizona Opera, on tradition"
+++

“Is this going to be a traditional production?”

As the Education Manager at Arizona Opera, this is the question I am asked most about operas in our upcoming seasons, and I must confess, I don’t really know how to answer it. After all, what tradition are we talking about?

I struggle with what is really meant by the question. Here are some possibilities: Will it be performed as it was at its original premiere? Will it be performed in the style of a certain opera company? Or will it have grand, opulent sets and costumes?

I often reply, “Why yes, *Don Giovanni* will be set in the time of Mozart,” or “Yes, we are setting it in the Renaissance,” or “No, it is set in 2015.” However, I don’t think I’ve actually answered the question correctly, because I think the real question being asked is this:

“Is the production going to be how I remember it when I first saw and fell in love with opera?”

If this is actually the question being asked, then my previous answers are null and void. My answer should be—unconditionally— “No.” Truly though, this is the best answer to the question, because it means opera is alive and well, as it continues to evolve:

When opera was created, people talked and gambled throughout the performance.
Baroque gesture was created to bring emotional and visual clarity to a stage lit only by candlelight. 19th century sets were all 2-dimentional. Realistic acting wasn’t utilized until the 20th century. Minimalistic productions were vogue in the 1950s because of economic hardship after WWII. Opera productions in the 1970s were revolutionary. Before that, the productions of the 1950s were revelations. And before that, and the time before that… You get the point.

You see, the great thing about theater (opera is a form of theater) is that it is always modern—no matter what the performers are wearing. As the great director Robert Carsen said, “You can recreate everything about a baroque opera production except the audience.” In other words, opera can never go back in time.

What makes opera so special is that the masterpieces which make up the canon are so beautiful, so transcendent, and so eternally true, they still they speak to us, even today. These operas remain relevant after World Wars, technological revolution, and societal change.

So, from now on when I am asked the question, “Is this going to be a traditional production?” My answer will be something like this:

Opera productions only exist to tell the story that the composer and librettist wrote. Our choices are made to connect the audience to the themes of the piece and reveal something about what it means to be human. We believe that the production you are about to see will tell that story through the sets, costumes, lighting, choreography, acting, and power of the human voice.

With your support and feedback, the “tradition” of opera remains in good hands.
