+++
author = ["authors/hannah-de-priest.md"]
categories = "Review"
date = "2019-03-06T16:53:22+00:00"
disclaimer = "_Be advised that there may be elements of this production, (especially in Act II), that may be distressing to some individuals, as the action includes a depiction of sexual assault._"
image_gallery = []
postamble = "_Ariodante_ runs at Lyric Opera of Chicago through March 17. For details and tickets, [click here](https://www.lyricopera.org/concertstickets/calendar/2018-2019/ariodante-opera-tickets)."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1551891487/media/2019/03/sqBrendaRaeKyleKetelsenARIODANTET8A1874.jpg"
primary_image_credit = "Brenda Rae and Kyle Ketelsen in Ariodante, Lyric Opera of Chicago, 2019. Photo: Cory Weaver."
related_articles = ["articles/pass-the-tissues-a-beautiful-new-bohme-in-chicago.md", "articles/ariodante-or-the-hebridean-handel.md"]
related_companies = ["scene/companies/lyric-opera-of-chicago.md"]
related_people = ["scene/people/iestyn-davies.md", "scene/people/heidi-stober.md", "scene/people/kyle-ketelsen.md", "scene/people/alice-coote.md", "scene/people/brenda-rae.md"]
short_description = "This Ariodante exemplifies what I hope to see more of from the Lyric in future seasons: creative, specific staging performed by committed and compelling singer-actors, with top-notch direction in the pit."
slug = "chicago-ariodante-pulses-with-emotion-and-suspense"
title = "Chicago Ariodante pulses with emotion and suspense"
youtube_url = ""

+++
Though some will apparently never recover from the "indignity" of watching [Danielle de Niese slide off a pair of knickers](/pass-the-tissues-a-beautiful-new-bohème-in-chicago/) during "Quando m'en vo" last fall, I for one was eager to see Richard Jones' production of [_Ariodante_](https://www.lyricopera.org/concertstickets/calendar/2018-2019/ariodante-opera-tickets), a four-way co-production between Aix-en-Provence, Canadian Opera Company, and the Dutch National Opera that shifts the plot to a Scotland village in the 1960's, replete with ruddy-cheeked, red-haired villagers bedecked in thick wool sweaters and all the requisite flannel. A clever set design by ULTZ, (who also designed the costumes), gives us a three-way cross-section of a building, meaning disparate action can occur in three different spaces simultaneously: a kitchen/ante-room, an all-purpose village meeting room, and Ginevra's bedroom.

Like virtually all of Handel's works for the stage, _Ariodante_ is a rumination on deception, heartbreak, and—perhaps most of all—the pain of women in traumatic circumstances. In the hands of Richard Jones, (with director Benjamin Davis helming this revival), _Ariodante_ additionally becomes an illustration of the many, wretched ways a woman's sexuality is controlled, denied, or weaponized for the benefit of men. The claustrophobic, patriarchal village is the vise that grips Ginevra, played to plucky perfection by [Brenda Rae](/talking-with-singers-brenda-rae/), in her Lyric debut.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1551893744/media/2019/03/ARIODANTE37A1615.jpg){{% /md %}}

<figcaption>A scene from Ariodante, Lyric Opera of Chicago, 2019. Photo: Cory Weaver.</figcaption>

</figure>

Rae's sparkly, endlessly expressive soprano makes a great fit for this role, which requires vacillating from exuberantly joyful coloratura to some of the most languid vocal lines Handel wrote. A compelling actress, Rae gamely took on the challenges of this physically-involved production, (take note: she's leaping onto tables, running around the stage, getting manhandled by Polinesso, all while firing off stratospheric coloratura oh, _and_ _she's six months pregnant_.)

Singing opposite Rae is [Alice Coote](/scene/people/alice-coote/), who just earlier this season treated Chicago audiences to another of her signature roles: Prince Charmant in Massenet's [_Cendrillon_](/actual-magic-in-chicago-lyrics-cendrillon/). A pre-show announcement intimated that Coote is still rallying from the flu that prevented her from singing the show's _prima_ on Saturday night, but she nevertheless sounded great, imbuing every line of recit and ornament with drama. As always, she's an exciting singer to hear and to watch. Wishing her all the best for a continued recovery!

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1551893788/media/2019/03/AliceCooteBrendaRaeKyleKetelsenHeidiStoberARIODANTET8A0339.jpg){{% /md %}}

<figcaption>Alice Coote, Brenda Rae, Kyle Ketelsen, and Heidi Stober in Ariodante, Lyric Opera of Chicago, 2019. Photo: Cory Weaver.</figcaption>

</figure>

Ariodante's brother Lurcanio was gamely sung by current Ryan Opera Center tenor [Eric Ferring](/scene/people/eric-ferring/). Ferring has an easy, warm tone and handled the coloratura of his bravura aria "Il tuo sangue" with a natural aplomb.

As an absolutely revolting iteration of Polinesso, (here a corrupt priest crowned with an oily ponytail and circle-framed specs), [Iestyn Davies](/scene/people/iestyn-davies/) was so convincing as to elicit boo-ing at the curtain call. The only counter-tenor in the cast, Davies' pretty tone had the bizarre effect of making Polinesso's machinations feel all the more sinister. His seduction and rape of Dalinda, (sung by an excellent [Heidi Stober](/scene/people/heidi-stober/)), was performed with such dramatic intensity that I felt my fists clench.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1551893834/media/2019/03/AliceCooteJoshLovellEricFerringKyleKetelsenARIODANTET8A0552.jpg){{% /md %}}

<figcaption>Alice Coote, Josh Lovell, Eric Ferring, and Kyle Ketelsen in Ariodante, Lyric Opera of Chicago, 2019. Photo: Cory Weaver.</figcaption>

</figure>

Stober's dusky tone and thrilling coloratura, (especially in her deeply-felt rage aria "Neghittosi, or voi che fate," which I bet she could sing even faster…) were utterly captivating. Her heartbreaking rendition of "Se tanto piace al cor" was a poignant highlight of Act II.

The opera's _denouement_ is meant to end with the blissful union of Ariodante and Ginevra—a formulaic quirk of the _seria_ genre. For modern audiences, such a happy ending feels unearned, like the unwelcome intrusion of an unprepared picardy third. Particularly in this production, Ginevra staying to become Ariodante's wife is unthinkable. Instead, she packs her bags and steps outside the picture-box style set, breaking through set's boundaries in a moment that simultaneously recalls Ibsen and _Pippin_. It was a gratifying change, one that saves the opera from slipping into a mere fetishization of her pain.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1551893946/media/2019/03/HeidiStoberARIODANTE37A1566.jpg){{% /md %}}

<figcaption>Heidi Stober in Ariodante, Lyric Opera of Chicago, 2019. Photo: Cory Weaver.</figcaption>

</figure>

With specialist Harry Bicket conducting, the Lyric Orchestra achieved commendable textural clarity. The sound was stylish and relatively fleet, despite wayward intonation and occasional hesitancy emanating from the violins, (presumably a result of playing with markedly less vibrato than usual). The balance between singers and instrumentalists improved over the course of the first act, allowing for moments of pure baroque magic later in the opera, when singers were given ample space to try out gorgeous vocal effects—I'm thinking especially of Brenda Rae's spine-tingling rendition of "Mi palpita il core," in this production played for maximum horror, sung as she awakes from a dream-state after being drugged by Polinesso and Dalinda.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1551894788/media/2019/03/IestynDaviesKyleKetelsenBrendaRaeARIODANTET8A1893.jpg){{% /md %}}

<figcaption>Iestyn Davies, Kyle Ketelsen, and Brenda Rae Ariodante, Lyric Opera of Chicago, 2019. Photo: Cory Weaver.</figcaption>

</figure>

All in all, this _Ariodante_ exemplifies what I hope to see more of from the Lyric in future seasons: creative, specific staging performed by committed and compelling singer-actors, with top-notch direction in the pit. Especially when compared with [_Idomeneo_](/glamour-fury-idomeneo-in-chicago/) and [_La Traviata_](/left-wanting-more-la-traviata-in-chicago/) this season, in which singers with few observable dramatic instincts were set adrift in productions that felt half-baked, [_Ariodante_](https://www.lyricopera.org/concertstickets/calendar/2018-2019/ariodante-opera-tickets) pulsed with emotion and suspense—no small feat for a lesser-known Handel opera clocking in at around the four-hour mark.