+++
author = ["authors/greg.md"]
categories = "Review"
date = "2016-10-17T10:06:00+01:00"
lastmod = "2016-10-17T13:29:00+01:00"
preamble = "Above: Jane Archibald as Ginevra (on bed) with Alice Coote as Ariodante and Johannes Weisser as the King of Scotland (in front row) in the Canadian Opera Company's production of *Ariodante*, 2016. Photo by Michael Cooper."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1476703260380/2016-10-17---Square---Ariodante-MC-1727.jpg.jpg"
primary_image_credit = "Photo by Michael Cooper."
publishDate = "2016-10-17T13:29:00+01:00"
related_articles = ["articles/review-sondra-slays-in-bellini-masterwork.md","articles/in-review-the-marriage-of-figaro.md","articles/spotlight-on-owen-mccausland.md","articles/in-review-der-rosenkavalier-at-roh.md","articles/coc1718.md","articles/in-review-an-evening-with-the-ensemble-studio.md","articles/in-review-solts-canadian-doublebill.md","articles/dynamic-and-physical-rinaldo-at-oper-frankfurt.md","articles/littleknown-gems-ariane-et-bachus.md","articles/opera-is-artifice-giulio-cesares-conquest-of-houston.md","articles/eugene-onegin-or-the-time-tatyana-dodged-a-bullet.md"]
related_companies = ["scene/companies/canadian-opera-company.md"]
related_people = ["scene/people/alice-coote.md","scene/people/jane-archibald.md","scene/people/ambur-braid.md","scene/people/owen-mccausland.md","scene/people/johannes-debus.md","scene/people/johannes-weisser.md","scene/people/varduhi-abrahamyan.md"]
short_description = "As Dalinda, Ambur Braid delivers the most nuanced and moving performance. As the meek and quiet and withdrawn maiden, you&#039;re drawn in to her from the moment the curtain rises. Then she sings, and she pours every ounce of Dalinda&#039;s yearning, innocence, and devotion into every note she sang. She had the remarkable ability to blend into the scenery and be all you can see at the same time."
slug = "ariodante-or-the-hebridean-handel"
title = "Ariodante, or the Hebridean Handel"
+++

Rounding out my Canadian Opera Company [double header](/review-sondra-slays-in-bellini-masterwork/) this weekend, I took my seat to take in Richard Jones's production of Handel's [*Ariodante*](http://www.coc.ca/PerformancesAndTickets/1617Season/Ariodante.aspx). Sunday matinee crowds are a neat mix, but I love when a show is so engrossing that you forget you're in a crowd at all. 

Telling the story of a young Scottish princess's trials and struggles on the way to marrying her love - to whom, for once in a blue moon in the opera world, her father his given his blessing for her to marry - the setting is a remote Scottish island in the late 1960s, which reminded me a lot of my own home. The orchestra, led by music director Johannes Debus played a spritely, complex, and clean Handel that danced with the singers on the stage. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1476703452525/2016-10-17--Ariodante-MC-0907.jpg.jpg)<figcaption>Alice Coote as Ariodante in the Canadian Opera Company's production of *Ariodante*, 2016, photo: Michael Cooper.
</figcaption>
</figure>

Singing the title role is the remarkable [Alice Coote](/talking-with-singers-alice-coote/). Her solid tone and quick action was more than equal to the task of the heroic coloratura Handel wrote. Ariodante's music stretches the range from the fireworks and fury to the long, sensual adagios and Coote owns them all. There's a brightness in the colour of her tone that sparkled. 

Speaking of sparkle, if you could represent that word in a human voice it would be [Jane Archibald](/scene/people/jane-archibald/) singing Baroque music. Her Ginevra was vibrant, hearty, womanly and powerful. There's an ecstasy in her portrayal that almost lends Ginevra a mystical quality that was quite enchanting. Archibald and Coote have the most beautiful marriage of tones. Their colors twinkled and swirled around each other like the bubbles in a glass of Veuve Clicquot.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1476703468204/2016-10-17---Ariodante-MC-0093.jpg.jpg)
<figcaption>(l-r) Varduhi Abrahamyan as Polinesso (in background), Jane Archibald as Ginevra and Ambur Braid as Dalinda in the Canadian Opera Company's production of *Ariodante*, 2016, photo: Michael Cooper.
</figcaption>
</figure>

Singing the role of Polinesso was mezzo [Varduhi Abrahamayan](/scene/people/varduhi-abrahamayan/). She sang with a dark tone and a quick action, with some of the fastest triplets I think I may have ever heard. Pollinesso was a predator of the first order. Abrahamayan brought us a villain who driven by lust will use whatever means he can to achieve his goals.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1476703527868/2016-10-17---Ariodante-MC-0926.jpg.jpg)
<figcaption>Varduhi Abrahamyan as Polinesso and Ambur Braid as Dalinda (in background) in the Canadian Opera Company's production of *Ariodante*, 2016, photo: Michael Cooper.
</figcaption>
</figure>

As Dalinda, [Ambur Braid](/talking-with-singers-ambur-braid/) delivers the most nuanced and moving performance. As the meek and quiet and withdrawn maiden, you're drawn in to her from the moment the curtain rises. Then she sings, and she pours every ounce of Dalinda's yearning, innocence, and devotion into every note she sang. She had the remarkable ability to blend into the scenery and be all you can see at the same time.

Singing Lurcanio, Ariodante's brother, [Owen McCausland](/spotlight-on-owen-mccausland/) gave some fantastic vocals. His heroic tone has a flexible, fluid sensibility that lets him sail through some really tricky coluratura passages. His chemistry with Braid's Dalinda was palpable. It gave every scene they had together a sense of doom - in the classical sense - like it was meant to be.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1476703548473/2016-10-17---Ariodante-CH-264.jpg.jpg)
<figcaption>(l-r) Alice Coote as Ariodante and Owen McCausland as Lurcanio in the Canadian Opera Company's production of *Ariodante*, 2016, photo: Chris Hutcheson.</figcaption>
</figure>

Norwegian baritone [Johannes Weisser](/scene/people/johannes-weisser/) sang the role of Ginevra's father, the King of Scotland. He had a wild full tone that had an inherently boomy and authentic intensity to it. COC Ensemble Studio member [Aaron Sheppard](/scene/people/aaron-sheppard/) was pulling comprimario duty and did a fine job at what can be a thankless position sometimes. They're important to every show, but that importance is not always incredibly obvious.

The trimmed-down COC Chorus of twelve singers, led by Chorus Master Sandra Horst, was incredibly well used. They sang delightfully and the voices danced through the hall and never missed a step. I particularly enjoyed how much *tableau vivant* was used - not something I'm used to seeing a lot of on the Four Seasons Centre stage, but it made probably the most intelligent use of the dances in the absence of a *corps de ballet*. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1476703591077/2016-10-17---Ariodante-MC-0711.jpg.jpg)
<figcaption>A scene from the Canadian Opera Company's production of *Ariodante*, 2016, photo: Michael Cooper.
</figcaption>
</figure>

The production by Richard Jones is gorgeous, and is presented in an almost two-dimensional style. The singular set could have been a replica of any number of homes I knew very well back on the east coast of Canada. I loved how they created walls in the space by having a free-standing, swinging doorhandle. There were some incredibly creative turns where the set is concerned. 

My only grievance with the show had to be its length. While I appreciate trying to keep the piece intact, a few judicious cuts would have gone a long way. I felt like the only aria without at *da capo* was Dalinda's, after she is raped by Polinesso (which is done very artistically during Lurcanio's aria). It felt like a record skip, considering how many *da capos* (*da capi*?) we were getting all around. Also, the balance of riding the audience reaction was also a bit off-kilter. Sunday matinee audiences are notoriously hard to read, even though they are some of the most appreciative crowds you'll draw. Honestly, all that Handel is great, but four-plus hours is pushing it.

The two shows running at the COC right now - the other being Bellini's *Norma* - are a brilliant way to start off the season. Two beautiful works sung by otherworldly singers. 

SPECIAL MENTION: The dope puppeteering. It was awesome! I've seen this used at the Four Seasons Centre before, but I think this is probably my favourite application. 
