+++
author = ["authors/jenna.md"]
categories = "How-To"
date = 2020-06-21T04:00:00Z
disclaimer = ""
image_gallery = []
postamble = ""
preamble = "I kind of can't believe we haven't done an Aria Guide for this bread-and-butter pick for trouser role mezzos. This aria is such a great moment in Mozart's _Le nozze di Figaro_; it's meant to be a stand-alone tune, as Cherubino is giving an impromptu recital (read: Susanna told him to) of the new song he wrote. The dramatic tension comes out of the fact that Cherubino is singing for the Countess, on whom he has a hopeless, teenage crush. \n\n\"Voi che sapete\" is about puberty, becoming girl-crazy, and involuntary bodily functions that are fun but also difficult to hide. It's one of those Mozart arias that seems simple, but demands a lot in the details. With your teacher and coach, this Aria Guide can help Cherubinos-to-be get started:"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1592005825/media/2020/06/sqAriaGuide-VoiCheSapete_rbqtge.jpg"
primary_image_credit = ""
related_articles = ["articles/aria-guides-una-voce-poco-fa.md", "articles/aria-guides-parto-parto.md", "articles/aria-guides-didos-lament.md"]
related_companies = []
related_people = []
short_description = "\"Voi che sapete\" is about puberty, becoming girl-crazy, and involuntary bodily functions that are fun but also difficult to hide. It's one of those Mozart arias that seems simple, but demands a lot in the details. With your teacher and coach, this Aria Guide can help Cherubinos-to-be get started:"
slug = "aria-guides-voi-che-sapete"
title = "Aria guides: Voi, che sapete"
youtube_url = ""

+++
* This first phrase **(1)** is simple and straightforward, and leaves you lots of room to decide on how confident a performer Cherubino is. The first two bars can easily pass for mechanical or unmusical, if your Cherubino is a shy starter; if he's on the braver side, there's a bit of machismo in this angular, swaggery beginning. You can do a lot with the \[v\] in "Voi", giving it some spin and pitch ahead of time so your vowel lands right on the downbeat. (Conductors love that.)

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1590609091/media/2020/05/AriaGuide-Voi-p1-annotated_fzvxq3.jpg){{% /md %}}

</figure>

* It's easy to slide out of tune here **(2)**, so make sure you're vibrating each note in this chromatic bit. The E-flat usually has to be lower than you think, the E-flat deserves some spin, and don't neglect the D-natural in the next bar. As a bonus, consider the comma in "donne, vedete". When you sing "vedete", it's a new phrase, so it could use some new energy. That'll also keep you engaged and in tune.
* This is a spot **(3)** that looks simple but it's totally not, and mezzos know this. It's a tricky tessitura, easy to get fatigued, so lightness and large beats are your friends. Try singing these two bars of "donne vedete" as though it's one bar of a sustained F, and then one bar of a sustained E-flat. What Mozart wrote with these wavering thirds is just a decoration of that basic tune, and if you keep the broader shape in your ear, you'll sing these bars with more ease. Also, imagine that you're conducting one big beat to each bar.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1590609101/media/2020/05/AriaGuide-Voi-p2-annotated_pzewwp.jpg){{% /md %}}

</figure>

* This might be a moment **(4)** where Cherubino's nerves settle and he finds his groove as a performer. The melody gets more inventive here, so be precise with some of these surprising notes, like the E-natural in "provo". There's a bit of melodrama in "è per me nuovo", so don't be afraid to let the voice bloom and vibrate in this trip from D to F.
* Make a bit of a meal out of the F on "affetto" **(5)**; see how it feels to get there a bit early, so you have time to really sing that top note. There's something cute in how Mozart writes "un affetto pien di desir", starting sort of shy and sweet, and then at "pien di desir" ("full of desire"), the tune gets lower and a bit more lustful.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1590609114/media/2020/05/AriaGuide-Voi-p3-annotated_ybwhyp.jpg){{% /md %}}

</figure>

* I always like to think of these two bars **(6)** as Cherubino's little _pièce de résistance_ in writing this song. It's textbook word painting: "ch'ora é diletto" ("now, it's a delight") gets a frilly, major tune, and "ch'ora è martir" ("now, it's torture") gets a stark, minor treatment. Experiment with how much you can exaggerate the contrast between these two mini-phrases; you can get away with more hamming it up than usual, since this scene is all about Cherubino trying too hard to win a woman who's out of his league. (Of course, as Beaumarchais fans will know, it [eventually turns out](https://en.wikipedia.org/wiki/The_Guilty_Mother) that she's not out of his league after all.)

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1590609126/media/2020/05/AriaGuide-Voi-p4-annotated_iist15.jpg){{% /md %}}

</figure>

* Beware of intonation here **(7)**; there's something about this sustained C-natural that tends sharp. As you deal with this wide-ranging phrase, spend time figuring out the balance of chest voice for that low C on "l'alma avvampar". Keep in mind that you've just got to head back up into that tiring tessitura for "e in un momento". It's fun and often exciting to really give those low notes a good dose of Ewa Podleś contralto-ness, but only if you can pop back up to the high E-flat without extra effort.
* These bars **(8)** are a lesson in raising the dramatic stakes. I imagine that by this time, Cherubino has almost forgotten his audience, so wrapped up is he in his lovesick crooning. The tune becomes tragic at "ricerco un bene", and it's almost aching for an extra-long phrase, so see if you can go right to the end of "fuori di me" before you breathe.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1590609138/media/2020/05/AriaGuide-Voi-p5-annotated_qrqupv.jpg){{% /md %}}

</figure>

* The idea here **(9)** is to show Cherubino basically panting with puberty, but don't tire yourself out in real life. Practice singing these bars without the rests, to find out where you truly need to breathe; it's easy to snag little breaths each time you have a rest, and that can quickly turn into stacking your air. Uncomfortable. And finally, when you make it to "ma pur mi piace", release any tension you might have built up in the panting bit. This might be another spot for a long phrase, too; some mezzos like to go all the way through "ma pur mi piace languir così", and others like to breathe before "languir", and then dovetail into the return of "Voi, che sapete" without a breath. In either case, let it be a bit of a trick up Cherubino's sleeve, something to really make the Countess swoon.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1590609157/media/2020/05/AriaGuide-Voi-p6-annotated_uoxfkm.jpg){{% /md %}}

</figure>

There you have it, it's just that easy. (It's not, I know.) For some inspiration, here's Isabel Leonard singing "Voi, che sapete":

<figure data-type="video">{{% md %}}<iframe width="1280" height="720" src="https://www.youtube.com/embed/mNRF-SEl27o" frameborder="0" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>{{% /md %}}

</figure>