+++
author = ["authors/jenna.md"]
categories = "How-To"
date = "2019-09-22T04:00:00+00:00"
disclaimer = ""
image_gallery = []
postamble = "If you have an aria you'd like to see featured in our Aria Guides, let us know at [hello@schmopera.com](mailto:hello@schmopera.com)."
preamble = "This aria of Zerlina's, from Act II of _Don Giovanni_, is a prime example of how Mozart lays out a scene that looks simple, until you dig through the subtle layers. Zerlina and her fiancé, Masetto, have had a tough go since the start of this opera, and the latest is that Masetto has gotten beaten bloody by the Don. Zerlina finds him after the fact, and offers, essentially, to kiss it better. Sexual healing. TLC.\n\nThe plot thickens when we consider that earlier in the opera, Zerlina nearly left Masetto for a tryst with the Don, and pouted her way out of getting caught by basically daring Masetto to spank her for being bad. This \"Vedrai, carino\" can be taken as genuine love from Zerlina, or it can be a gross display of emasculation, the operatic equivalent of saying, \"Aw, did Masetto get a boo-boo?\"\n\nAlong with the work you'll do with your teacher and coach, our tips will help you peel back the layers:"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1569086919/media/2019/09/sqVedrai_xq45w0.jpg"
primary_image_credit = ""
related_articles = ["articles/aria-guides-parto-parto.md", "articles/aria-guides-quando-men-vo.md", "articles/aria-guides-deh-vieni-non-tardar.md", "articles/aria-guides-je-suis-encor.md"]
related_companies = []
related_people = []
short_description = "The plot thickens when we consider that Zerlina nearly left Masetto for a tryst with the Don, and pouted her way out of getting caught by basically daring Masetto to spank her for being bad. This current aria can be taken as genuine love from Zerlina, or it can be a gross display of emasculation, the operatic equivalent of saying, \"Aw, did Masetto get a boo-boo?\""
slug = "aria-guides-vedrai-carino"
title = "Aria Guides: Vedrai, carino"
youtube_url = ""

+++
* Something to keep in mind right from the start **(1)**: Zerlina has grown up a little since the last aria she sang ("Batti, batti"). She's lived more, and likely learned a bit about her body since her encounter with the Don. It's a bit similar to what a Susanna would feel in _Le nozze di Figaro_, when she arrives at "Deh vieni, non tardar". Zerlina's aria too has a nobility and a maturity about it, a roominess that we don't often associate with soubrette roles. The 3/8 time will give the tune a swinging feel of 1, but stay on the voice as you sustain each pitch. There's time to be deliberate, even with the grace notes in the melody.

  <figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1569086353/media/2019/09/AriaGuide-Vedrai-p1_cdqjnb.png){{% /md %}}

  </figure>


* Super connected legato here **(2)**. Give a bit of a double N to "naturale", to help with the language. In the next bar, make a clear choice to sing the E more loudly than the D - essentially, a really obvious diminuendo.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1569086368/media/2019/09/AriaGuide-Vedrai-p2_ttuuyk.jpg){{% /md %}}

</figure>

* There's something about this phrase **(3)** that makes people sing sharp. Often, the issue is that you're breathing before "non dà..." and then again before "e lo...", so you're uncomfortably stacking air. You can likely do with just one breath before "non dà", and you'll make it if you bring your vibrato around to every note. When you get to that "no" at the end of the line, give it a double N.
* A lot of singers like to take one breath before this "far" **(4)**, and aim at least for the end of "balsamo" before they breathe again. You might think that's too long a phrase, but give it a try - and plan accordingly with your breath and vowel placement. It sometimes helps to imagine, in the word "far", that the \[a\] vowel happens in the same place as the letter F.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1569086379/media/2019/09/AriaGuide-Vedrai-p3_s6sbfz.jpg){{% /md %}}

</figure>

* Text makes this spot **(5)** fun to sing. There are rhythmic shifts and neat hemiolas to be found if you really prioritize the rhythm of the Italian, which puts the stress on the first syllable of "dove". Really try overdoing the difference between the stressed and unstressed syllables, and you'll find the coy cleverness that Mozart gives to Zerlina. One last note: the fermata on the last "sta?" is only written for the first note (E), not the D in the next bar.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1569086391/media/2019/09/AriaGuide-Vedrai-p4_knbreq.png){{% /md %}}

</figure>

* This entrance **(6)** is in the middle of an ongoing phrase with the orchestra, and all of you resolve at "quà". It can be really effective (and affective, even) to start "Toccami" gently, joining the melody already in place. Then, at all her shouts of "sentilo battere", lean again on the Italian rhythm to make this phrase exciting. Italians say, "**Sen**-ti-lo", so try putting that into Mozart's rhythms - it'll be fun, trust me.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1569086405/media/2019/09/AriaGuide-Vedrai-p5_yskzdu.png){{% /md %}}

</figure>

* This line **(7)** is melodramatic, maybe even hilariously so. But there's huge tension in this tritone that keeps repeating, so really sing through the stress. Be clear with your intonation on the first B-natural, and then sing through the leap back up to the F. At all the times she says "quà!" ("here!"), you get to infuse them with subtext.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1569086419/media/2019/09/AriaGuide-Vedra-p6_viitsf.jpg){{% /md %}}

</figure>

* This bit **(8)** is tricky to maintain without getting heavy or out of tune. Focus on the D-natural that anchors the coloratura, and be as light as you can on everything else. Bring your legato back at the end of "battere" to help you up to the F on "toccami". With each bar of "quà, quà!", give a bit more to the second "quà".
* This is noble-lady singing, here **(9)**. Be brave on the leap from D-G, and sing through each note as you come back down. Enjoy the grace note before the last "toccami quà", and give it some vibrato and time. Finally, sing a nice, long final note, like a grand pass-off to the orchestra. (If it were me, I'd try to get away with singing for a few extra beats.)

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1569086433/media/2019/09/AriaGuide-Vedrai-p7_oqcm3g.png){{% /md %}}

</figure>

***

Have a listen to Cecilia Bartoli's rendition here:

<figure data-type="video">{{% md %}}<iframe width="1011" height="758" src="https://www.youtube.com/embed/IZM1WEm9nKw" frameborder="0" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>{{% /md %}}

</figure>