+++
author = ["authors/jenna.md"]
categories = "How-To"
date = 2020-06-25T04:00:00Z
disclaimer = ""
image_gallery = []
postamble = "Have a suggestion for a future Aria Guide? Let us know in the comments below, or get in touch at [hello@schmopera.com](mailto:hello@schmopera.com)."
preamble = "This aria from the final act of _La bohème_ is two pages of what's stunning about a great bass. Colline, the philosopher among his band of bohemians, is doing his part after Mimì shows up at his apartment, looking for his friend Rodolfo and dying of tuberculosis. He decides to pawn his coat to help pay for a doctor, and because he's a philosopher, the decision is a weighty one. Along with your teacher and coach, this Aria Guide can get you off to a good start with the short and sweet \"Vecchia zimarra\":"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1592334304/media/2020/06/sqAriaGuide-VecchiaZimarra_dsml07.jpg"
primary_image_credit = ""
related_articles = ["articles/aria-guides-aprite-un-po-quegli-occhi.md", "articles/aria-guides-schweig-damit-dich-niemand-warnt.md", "articles/aria-guide-o-du-mein-holder-abendstern.md"]
related_companies = []
related_people = []
short_description = "This aria from the final act of La bohème is two pages of what's stunning about a great bass. Colline, the philosopher among his band of bohemians, is doing his part after Mimì shows up at his apartment, looking for his friend Rodolfo and dying of tuberculosis. He decides to pawn his coat to help pay for a doctor, and because he's a philosopher, the decision is a weighty one"
slug = "aria-guides-vecchia-zimarra"
title = "Aria guides: Vecchia zimarra"
youtube_url = ""

+++
<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1590606094/media/2020/05/AriaGuide-Vecchia-p1-annotated_ldonn6.jpg){{% /md %}}

</figure>

* I find it so incredibly touching that Colline, the philosopher who overthinks by trade, finds such gravitas in the selling of his coat. It's not a small gesture, of course; it's cold out, and Colline is poor, so sacrificing his coat is a big deal. But I think it helps to sing this aria to a friend, not a garment. It's a bit overdone, a bit exaggerated in sentiment, but that's who Colline is; he overthinks his own facial hair, so of course he'd made a ponderous moment out of trying to help save a life. That's all to say that the stakes need to be high, here **(1)**. This is a goodbye aria - almost a funeral dirge, really - to a living, generous being that just happens to resemble a coat. Oh, and when you get to the _poco rit_ at the end of the first line, make sure you sing right through the space between C-sharp and B-natural; it's easy to fall flat if you let your energy go too soon.
* A lot of basses find this tessitura tricky here **(2)**. Be specific with the two vowels in "mai", and make your life a bit easier by turning "non curvasti" into "nong curvasti"; it's easier to keep the legato with that \[ŋ\] sound. Also, be diligent and sing a good \[u\] vowel in "curvasti", even though it's a short note. And as you finally relax at the end of the phrase, think ahead and keep some height in your sound. You just have to pop right up to the high E-flat on "Passar", which is a task on the best of days. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1590606111/media/2020/05/AriaGuide-Vecchia-p2-annotated_aeugy4.jpg){{% /md %}}

</figure>

* Enjoy this portamento on "come" **(3)**. Puccini asks for it specifically, and this is Colline's moment to remind the audience that he's more than a tenor's bearded buddy. Be exact about tempo when you get to the "filosofi e poeti" bit; the _a tempo_ is important to a conductor, so save your stretchiness for the stuff before.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1590606127/media/2020/05/AriaGuide-Vecchia-p3-annotated_lv0ncq.jpg){{% /md %}}

</figure>

* Vowel, vowel, vowel, here. Puccini gives you time with his _rallentando_, so take the space and spin three great \[i\] vowels to get you through "ti dico". Basses often find the ascent the hard part, but don't let up before you've sung the B-natural at the end of the word. 
* This phrase isn't much to look at **(5)**, but it's a heartbreaker if you commit to that long note on "mio". If it were me singing this (if only) I'd try and get away with holding that note for as long as a conductor would let me; however long you have, spend the note actively renewing and renewing that \[o\] vowel, so it stays energized and in tune. Finally, for the two "addios", it's your moment of tragedy, so don't let anyone rush you; technically, you get to decide on the first one, and the conductor gets to dictate the second one. Don't put up a fight - you're not the tenor, after all. (Tenors, I jest, mostly.)

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1590606140/media/2020/05/AriaGuide-Vecchia-p4-annotated_sr8jjb.jpg){{% /md %}}

</figure>

To cap it off: I like how James Morris sang this aria, back in 1982 at the Met.

<figure data-type="video">{{% md %}}<iframe width="901" height="676" src="https://www.youtube.com/embed/ArYceMAJiH8" frameborder="0" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>{{% /md %}}

</figure>