+++
author = ["authors/jenna.md"]
categories = "How-To"
date = "2015-10-14T07:51:00-06:00"
lastmod = "2017-06-20T22:50:00-06:00"
postamble = "Want to request an aria? Get in touch at [hello@schmopera.com](mailto:hello@schmopera.com)!"
preamble = "For the next in our series of [Aria Guides](/aria-guides-the-counts-aria/), we're nodding to all the mezzos (and a few sopranos) with \"Una voce poco fa,\" from *Il barbiere di Siviglia*. This is a cornerstone aria for many young mezzos, and one of the few chances they have to show off coloratura *and* play a girl. It's also an aria full of options. Ornamentation, cadenzas, high or low keys; there's no \"right way\" to sing rep like this. I can offer up a few tips based on common traps and hurdles I've noticed as a coach. \n\nFollow along on page 82 of [this score](http://javanese.imslp.info/files/imglnks/usimg/1/1a/IMSLP41530-PMLP07237-Rossini-BarbiereVSlucca.pdf), or use the excerpts below. For suggestions, or to request an aria, get in touch at [hello@schmopera.com](mailto:hello@schmopera.com).\n\n"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1553353173/media/2019/03/sqVoce.jpg"
publishDate = "2015-10-19T06:47:00-06:00"
related_articles = ["articles/aria-guides-una-furtiva-lagrima.md", "articles/aria-guides-quando-men-vo.md", "articles/song-guides-die-nacht.md", "articles/aria-guides-je-veux-vivre.md", "articles/aria-guides-o-sleep-why-dost-thou-leave-me.md", "articles/aria-guide-dies-bildnis-ist-bezaubernd-schon.md", "articles/aria-guides-va-laisse-couler-mes-larmes.md", "articles/aria-guides-insert-christmas-carol-here.md"]
short_description = "For the next in our series of Aria Guides, we're nodding to all the mezzos (and a few sopranos) with \"Una voce poco fa\" from Il barbiere di Siviglia. This is a cornerstone aria for many young mezzos, and one of the few chances they have to show off coloratura and play a girl. It's also an aria full of options. Ornamentation, cadenzas, high or low keys; there's no \"right way\" to sing rep like this."
slug = "aria-guides-una-voce-poco-fa"
title = "Aria guides: Una voce poco fa"

+++
### The slow part

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1445003070138/Aria-Guide---Una-voce---p1---Annotated---Cropped.jpg.jpg) {{% /md %}}</figure>

1. Rhythm matters. Be precise, and be brave with these double dotted figures. Practice subdividing into thirty-second notes to feel how long the "u-" of "una" really is. The trick is in making continuous sound _through_ the double dotted figure, without anticipating the short note. Although they're more precise than grace notes, the thirty-second notes will feel attached to the long notes in a similar way; it's a "ta-DA" figure. Bonus tip: be very careful not to double the N in "una"; this often gets related to rhythmic precision, so be sure you're not counting with consonants.
2. Singing through the V in "voce" brings the text to life. It's not quite a double V, but it's giving the word some attention.
3. There's a tendency for the E natural on "il **mio** cor" to be sharp; take care with intonation as you get this aria into your body.
4. That C-natural on the name "Lindoro" should really mean something. Sing the "Li-" fairly long, as though it has a tenuto marking; if the \[i\] vowel is in a good spot, you'll also be able to sing on the N in his name.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1445003139199/Aria-Guide---Una-voce---p2---Annotated---Cropped.jpg.jpg)
   {{% /md %}}</figure>
5. This is a strangely written lick downward, and it's easy to get tied up with rhythm and notes. Take note of the repeated note pattern (circled); you don't actually have to think about singing a pitch twice in a row. You can get the right effect by placing the text with the grace notes (before the beat), and singing through any repeated notes like they're one long pitch instead of two. It'll be easier, and it will sound more legato than yodel-like.
6. I've noticed a habit of singing in straight tone for this descending triplet under "lo giurai". At the very least, give some attention (read: vibrato) on the "giu-" to keep the _bel_ in _bel canto_.
7. The little rising passage on "la vincerò" has repeated notes in it, similar to the grace notes earlier. Let each pair meld into one note, divided only by a change in text. The frame of this melisma is really in the first of each triplet, a rising B-C#-D# pattern (circled). Keep hearing this hidden melody so you stay grounded instead of frantic.
8. There's another one of these hidden melodies in the big melisma down from the G# on "Si, Lindoro mio sarà"; the starts of each group of four thirty-second notes outlines the descending G#-E-C#-A frame in eighth notes. As you practice this melisma, use this larger tune to stay organized technically and harmonically. Sounds boring, but it makes your job a lot easier.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1445003216808/Aria-Guide---Una-voce---p2---Annotated---Cropped2.jpg.jpg)
   {{% /md %}}</figure>
9. This section is about text, not singing; for that reason, you should feel free to take Rossini's rhythm with a grain of salt. The ebb and flow of the Italian should take precedence over even sixteenths, and it's a dead giveaway that you're not comfy in the language if it's robotically even.

\*As this section repeats and you add your ornaments, your to-do list should be fairly short: choose ornaments that show off what you do well (in reality, not wishful thinking), and don't overthink your choices. Opinions are abundant, and if you're hired by someone with strong enough thoughts on how to jazz up this aria, they'll tell you what they want to hear anyway. Go nuts, have fun, but don't give yourself a chore to do each time you sing it.

### The fast part

\*As we get into the coloratura bits, I can offer some general, if incomplete, advice. Help yourself by always finding the larger tune within the string of sixteenth notes, and stay nice and light. For more specifics, get thee to thy voice teacher.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1445003475817/Aria-Guide---Una-voce---p4---Annotated---Cropped-Pt1.jpg.jpg)
{{% /md %}}</figure>

 1. Give yourself lots of room to sing the 5-note figure (4 sixteenths and a grace note) on "sono", by starting the "S" nice and early.
 2. Be sure that you're singing (read: vibrating) on the "ci-" of "docile." It's a tiny detail, but that little C-sharp can have a lot of character. Like a wink, but musical.
 3. Double check your intonation on the low G# of the triplet passage under "rispettosa" (it's a tuning trap!).
 4. Be sure you can sing the N in the word "ubbediente" (in some scores it's "obbediente"). If the \[ɛ\] vowel isn't in a great spot, that N won't come out; it's a nice test of your technique, and you'll sing right in the centre of that beautiful B-sharp.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1445003272272/Aria-Guide---Una-voce---p4---Annotated---CroppedPt2.jpg.jpg)
    {{% /md %}}</figure>
 5. This scale is tricky, considering the octave leap involved and not much room for rhythmic flexibility. If you double check the D# (circled), just as you begin the descent, you'll find you'll be more accurate, and less likely to "fall" down the scale.
 6. In these low E's on "mi lascio reggere," imagine you're singing 2 beats to the bar rather than 4. There's a tendency to make these eighth notes heavy and to chew the text; a feeling of 2 will help lead you to downbeats, rather than sit heavily on each syllable.
 7. Like earlier in the aria, there's another large-frame melody hidden in this melisma on "mi fo guidar." Let the descending third pattern (C#-A-F#, circled) ground you and organize this bit of technique into something musical.
 8. It's pretty fun to do a portamento up from the low B natural, and make a whole thing out of the rolled R in "guidar". I feel like this is one of those things that non-Italian speakers do, and I wouldn't assume that it's as funny for native speakers as it is for us. Whatever effect you want to do on "guidar", make sure you could also deliver the same subtext without relying on the R sound.
 9. The accented notes on "trappole" and "cedere" should be singing accents, not pressing accents. They should allow you to let your voice ring (read: vibrate) for a moment, like a release of any tension that might come out of the small place your coloratura lives.
    <figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1445037814823/Aria-Guide---Una-voce---p5---Annotated---Cropped1.jpg.jpg)
    {{% /md %}}</figure>
10. This scalar passage doesn't have a hidden tune in the way that previous melismas do, but there's still the opportunity to anchor yourself in the midst of all the notes. Use the notes on the big beats (circled) as checkpoints to keep you on track.
11. This section is full of personality, with all its sliding chromaticisms. Be _very_ picky about intonation here, especially when it comes to showing a minor versus a major mode.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1445038343531/Aria-Guide---Una-voce---p5---Annotated---cropped2.jpg.jpg){{% /md %}}</figure>
12. When you ornament that same figure in the dotted rhythms, pay attention to how you sing the long note. In this rhythm it's easy to lean on the short note, decay on the long, and then forget about it. Without getting heavy, make sure that the long note is flexible and truly in your voice (rather than simply intoning a pitch).
13. As you do this pattern of descending scales, it's easy to get tired and fall down from the top note, like in the "amorosa" bit earlier. I've found that pinpointing the intonation of the second note of the scale helps a lot. So, the F# in the first scale, the E-natural in the second, etc. (Circled for clarity.)
14. This next bit is where you can coast. It's all about the orchestra's Rossini crescendo, and Rosina's interjections aren't worth trying to cut over all that noise. Take the opportunity to deliver these short lines in a _parlando_ way, resting up for the grande finale to come. <figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1445030595704/Aria-Guide---Una-voce---p6---Annotated---Cropped.jpg.jpg) {{% /md %}}</figure>
15. More coasting here. The orchestra is getting excitable (read: louder), and Rosina's line is more functional harmony than _bel canto_. It's an easy line to sing and you'll probably be full of adrenaline by this point; all you really need to think about is staying light and staying high in your placement. There's a high B coming up (or C, if you're high-keying it)!
16. It's common performance practice to tacet for one or both of these bars of quarter notes. Most singers come back in at the start of the measure with the high B, on "ah"; the orchestra usually cuts out after the last chord of that bar, and waits for Rosina to sing the big high note. It's up to you whether you want to sing the last "farò giocar" as written, or with ornaments, or simply pop the high note out of the blue. Whatever you choose, make sure it's something you could do under pressure.