+++
author = ["authors/jenna.md"]
categories = "How-To"
date = "2015-10-20T15:55:00-06:00"
lastmod = "2017-06-20T22:37:00-06:00"
postamble = "Want to suggest or request an aria for our Aria Guides? Let us know at [hello@schmopera.com](mailto:hello@schmopera.com)!"
preamble = "Tenors, we haven't forgotten about you. Continuing our series of Aria Guides, we're focusing on Nemorino's very lovely, very popular aria from _L'elisir d'amore_, \"Una furtiva lagrima\". It's one of those arias that can show a lot, and if you sing it well, it's great for auditions and crowd-pleasing concerts alike. It's not a easy feat to pull off this _bel canto_ staple, but here are a few tips meant to help."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1498019845898/2017-06-21---Lagrima.jpg.jpg"
publishDate = "2015-10-22T06:00:00-06:00"
related_articles = ["articles/aria-guides-deh-vieni-non-tardar.md", "articles/aria-guides-the-counts-aria.md", "articles/aria-guides-una-voce-poco-fa.md", "articles/aria-guides-quando-men-vo.md", "articles/aria-guides-aprite-un-po-quegli-occhi.md", "articles/aria-guides-dalla-sua-pace.md", "articles/aria-guides-je-veux-vivre.md", "articles/aria-guide-dies-bildnis-ist-bezaubernd-schon.md", "articles/aria-guides-o-wie-angstlich.md", "articles/talking-with-singers-andrew-haji.md"]
short_description = "Tenors, we haven't forgotten about you. Continuing our series of Aria Guides, we're focusing on Nemorino's very lovely, very popular aria from L'elisir d'amore, \"Una furtiva lagrima\". It's one of those arias that can show a lot, and if you sing it well, it's great for auditions and crowd-pleasing concerts alike. It's not a easy feat to pull off this bel canto staple, but here are a few tips meant to help."
slug = "aria-guides-una-furtiva-lagrima"
title = "Aria guides: Una furtiva lagrima"

+++
<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1445465677598/Aria-Guide---Una-furtiva-lagrima---p1---Annotated---Cropped.jpg.jpg)
{{% md %}}</figure>

 1. This is a surprisingly difficult start to the aria. The combination of \[u\] vowel and the starting pitch in _passaggio_-land can make a tenor feel like he's walking on eggshells. It's all about the way you place that first B-flat, on the "-na" of "una". That little portamento (which you should do because it's beautiful, and Donizetti took the time to write it in) can make it easy to fall down from the F; that will give it a heavy accent that you don't want, and you might get flat in the B-flats. Since there are a few phrases that start like this, it's something you want to get into your muscle memory early on.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1445465748904/Aria-Guide---Una-furtiva-lagrima---p2---Annotated---Cropped.jpg.jpg) {{% /md %}}</figure>
 2. Let the "la-" of "lagrima" vibrate under that accent. It should help you ricochet the "-grima" away from the downbeat, and imitate the rhythm of the word.
 3. These little graces notes can be sung either before or on the beat. It's up to you (and sometimes you music director)!
 4. Be sure not to drive the sound under "quelle". You're on your way to an A-flat, so the first half of that bar should stay light and vibrating. The E-natural makes people want to sing straight-tone here, but I'd resist that urge.
 5. Watch the rhythm here, since it's slightly different in the second verse. There's something very specific about the way Donizetti has set the word "invidiar", and I think it's a moment of giddy excitement for Nemorino in the middle of this really romantic aria.
 6. Remember that the stress would be on "che _più_", not "_che_ più"; that means the first note shouldn't get more weight than the second note. You can get that effect by imagining a crescendo out of nothing into "più".<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1445465812459/Aria-Guide---Una-furtiva-lagrima---p2part2---Annotated---Cropped.jpg.jpg){{% /md %}}</figure>
 7. Some tenors breathe before "io vo", some don't. The point is to be completely comfortable at "M'ama", so you do what you need to make that happen. Whatever happens, stay light in the notes leading up to the long F, so you leave yourself somewhere to go with the crescendo. It helps to think of the crescendo in measured dynamic steps (terraced dynamics) rather than a gradual increase in volume; you'll be able to pace your sound, and take stock of any vowel modifications you might need, depending on how softly you started.
 8. See how much of a double M in "M'ama" you can comfortably sing; it's a nice language touch. The big thing to remember is to enjoy this portamento from F to D-flat. Stay on your voice, stay on a vowel, and give it a rhythm if it helps your pacing. Then, get thee to thy voice teacher.
 9. It's common to relax the tempo in this bar; be sure that as you do, the structure of the written rhythm is still there. Basically, remember that slowing down doesn't mean the absence of pulse.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1445465891974/Aria-Guide---Una-furtiva-lagrima---p3---Annotated---Cropped.jpg.jpg){{% /md %}}</figure>
10. Here's that place in the second verse where the rhythm is different than before. Sing actively through the length of "-fon-" in "confondere," and enjoy that last tie.
11. Take note that "confondere" starts with an eighth note pickup, and not a sixteenth note.
12. If you listen to a lot of recordings of this aria, you'll hear a good amount of them add a portamento on that long F, moving up to the G just before "Cielo". This is a choice the tenor gets to make, depending on whether or not that portamento really adds anything to the moment. If it makes the step up to the G easier, go for it. If not, don't. In either case, the "Cielo" should come easily out of the sound and placement of "sospir". It's a happy moment, not a tragic high note.
13. Be clear about this B-natural, by allowing it and the scale afterwards to vibrate. This figure returns a little later, a written a little differently, and you want to show your attention to detail.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1445466146578/Aria-Guide---Una-furtiva-lagrima---p4---Annotated---Cropped.jpg.jpg){{% /md %}}</figure>
14. It's easy to feel crowded in this bit, with weird notes and busy text underneath. Take the time to include the commas in the text, which will help organize it musically for you. There's a mini phrase separation between each "si può," and you have more time than you think to articulate that.
15. This is where that bit in #13 is slightly different, so be very picky about your tuning for the C (it's common for that B-natural earworm to slip in).
16. The cadenza you see written is rarely done without a little jazzing up. The common thing is to extend the cadenza so it goes up to a, A, and the end is mostly re-written. [Here's Pavarotti](https://www.youtube.com/watch?v=2J7JM0tGgRY) singing the aria, with today's most familiar version of this cadenza starting [here](https://youtu.be/2J7JM0tGgRY?t=237).