+++
author = ["authors/jenna.md"]
categories = "How-To"
date = "2017-08-17T20:41:00-04:00"
lastmod = "2017-08-22T13:17:00-04:00"
preamble = "Our latest wave of Aria Guides wouldn't be complete without a nod to tenors. Mozart's *Così fan tutte* - that weird mix of romantic comedy and relationship commentary - is one of the most common picks in the operatic canon; yet for many tenors, Ferrando's first aria, \"Un aura amorosa\", tends to come with a bit of jitters and baggage. It's fairly slow, and sits in an exposed and tricky range of the voice. When it's done well, all the technical feats go largely unnoticed, overshadowed by the beauty of Mozart's writing.\n\nIt may not be the perfect fit for every tenor, but it certainly comes with oodles of learning opportunities. Along with the work you do with teachers, coaches, and in the practice room, we can help you get started on making some tough Mozart sound, well, breezy."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1503017729342/2017-08-18---Aura.jpg.jpg"
publishDate = "2017-08-22T13:01:00-04:00"
related_articles = ["articles/aria-guides-dalla-sua-pace.md", "articles/aria-guides-il-mio-tesoro.md", "articles/aria-guides-o-wie-angstlich.md"]
short_description = "Mozart's Così fan tutte - that weird mix of romantic comedy and relationship commentary - is one of the most common picks in the operatic canon; yet for many tenors, Ferrando's first aria, \"Un aura amorosa\", tends to come with a bit of jitters and baggage. It's fairly slow, and sits in an exposed and tricky range of the voice. When it's done well, all the technical feats go largely unnoticed, overshadowed by the beauty of Mozart's writing."
slug = "aria-guides-un-aura-amorosa"
title = "Aria guides: Un aura amorosa"

+++
 1. When you sing this aria on its own without the context of the whole opera, keep in mind that the intro bar for the piano is actually the tail end of the recitative that precedes this aria. It's loud and with a certain energy; but it's not necessarily indicative of how you want to start singing. You can consider your first line a point of contrast from the music that comes before you. As you get singing, you'll find out that this aria is a study in "staying up"; there are plenty of traps in which your singing can fall flat or stale, so avoid those traps by finding ways of staying fresh and spinning through the long _passaggio_ phrases.
 2. Look ahead as you start this phrase; the pick-up on "un" is low, but before you know it you're singing an octave higher. Start that low E with a lightness that will make the rest of the phrase easy. When you get to the leap up to the F-sharp on "cor", be sure to carry a nice open \[ɔ\] vowel through both pitches before starting to roll the R.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1503016816398/Aria-Guide---Un-aura---annotated-1.jpg.jpg)
    {{% /md %}}</figure>
 3. It seems strange, but singers grow to learn that not every semitone feels the same size. These semitones are teeny-tiny. Be sure that you're really singing the E-natural and D-sharp with spin and vibrato, so you don't end up pressing them or letting them fall flat. When you're on the long D-natural, really fill out the whole length of the note; there's a tendency to want to "check out" of longer notes early, so really sing through the third beat of the bar. Finally, when you have that little ornament at the end of "amorosa", make sure the thirty-second notes are both done on a good \[ɔ\] vowel.
 4. Practice this leap from the E to the high A in reverse, so you get a sense of the height needed to start this phrase. Choose a good version of vowel in "dolce" to help you up there, and make sure you're not letting the letter L creep in too early. As you come down from the high A, practice stopping on each note to make sure it's being properly sung; it's easy to relax or "give up" after the hard work is done, but you'll sacrifice a lot of beauty (and intonation) if you're not paying attention.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1503016825668/Aria-Guide---Un-aura---annotated-2.jpg.jpg)
    {{% /md %}}</figure>
 5. In this repetition of the phrase, Mozart gets you to really stretch out the text. Be really ready for this elongated "dolce ristoro", and stay active in the long D-naturals so that they don't grow stale.
 6. This is another spot to stay spinning and engaged. It's already pretty relaxed in tempo, and there's something about the widely set notes on the page that can make it seem even slower. To help keep these notes fresh, think in subdivisions of sixteenth or thirty-second notes. Be picky with your intonation on the G-sharp of "nudrito", and make sure it's not falling flat.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1503016833619/Aria-Guide---Un-aura---annotated-3.jpg.jpg)
    {{% /md %}}</figure>
 7. This tritone on "speme" is cool and surprising; make sure you bring it out by really singing that first D-sharp, giving it spin and vibrato. The same goes for the high G-sharp in the second "da speme"; at this tempo, a sixteenth note isn't that quick, so if you're not not supporting these pick-up notes, they really start to add up to tension and flat singing.
 8. Stay light on these triplets, and be careful that you're not working too hard for the low G-sharps. When you get to the scale on "bisogno", maintain an open vowel to help keep things clean and clear.
 9. This is a great spot to practice in reverse, so you get an idea of the space you need for the A-natural. As you sing those slow-moving eighth notes, don't let them get heavy or static; thinking of sixteenth-note subdivisions or a flowing vibrato will help you move forward. In particular, make sure you have room to spin on the "mi-" of "migliore".<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1503016844166/Aria-Guide---Un-aura---annotated-4.jpg.jpg)
    {{% /md %}}</figure>
10. It might be tempting, but don't let yourself drop down into the comfortable range at this "-sogno non ha". Pretty soon, you've just got to climb back up to _passaggio_ land, so make it easier on yourself by maintaining height even as the pitches get lower. Twice, you have this pattern of long E-naturals (eighth notes and dotted eighth notes); it's in those notes where many tenors can build up fatigue or tension, so think of renewing the vowels through these extended E-naturals.
11. Here's another spot to stay up, and not allow yourself to drop. The low A-naturals should be light, letting them lead to the next bar rather than being a point of rest or arrival. Be diligent about singing the last notes of each bar in this line; you have time to sing that F-sharp on "al", and the high A when it repeats. Particularly the second time, when it goes up to the high A, make sure you're not letting the letter L get in the way of a good \[a\] vowel on "al".<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1503016853535/Aria-Guide---Un-aura---annotated-5.jpg.jpg)
    {{% /md %}}</figure>
12. Think of this whole measure as one extended pick-up to the next bar. The pick-up "un" should be light as a feather, and then let the eighth-note F-sharps be really horizontal, leading right to "-storo". As you get to that descending arpeggio down to the low D, trust that you don't need to fight for volume. If you work too hard for that low note, it'll make the final phrase way harder than it has to be.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1503016862263/Aria-Guide---Un-aura---annotated-6.jpg.jpg)
    {{% /md %}}</figure>
13. You have time to sing the two pick-up notes at this last "al cor porgerà", so use the notes as a chance to get your voice moving the way it should for the final high A. You can give yourself some room on the high note on "cor" by getting there a bit early; the same goes for the appoggiatura that starts the trill on the last "porgerà".