+++
author = ["authors/jenna.md"]
categories = "How-To"
date = 2021-08-26T04:00:00Z
disclaimer = ""
image_gallery = []
postamble = "Have a request for our Aria Guides? Get in touch at [hello@schmopera.com](mailto:hello@schmopera.com)."
preamble = "Verdi's _Il trovatore_ has got to be in the top three most bonkers plots in all of opera. Azucena, the gypsy woman with an obvious PTSD situation over having accidentally thrown her own baby in a fire several years back. The crackling fire triggers the memory, and Azucena sings [\"Stride la vampa\"](http://www.aria-database.com/search.php?sid=24a50bbfcebd847a80bdf4ae327a0c09&X=5&dT=Full&fC=1&searching=yes&t0=all&s0=stride+la+vampa&f0=keyword&dS=arias) (\"The flames roar\"). Along with the work you do with your trusted teachers and coaches, this Aria Guide can set you on the right path with this Verdi mezzo gem:"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1629492987/media/2021/08/AriaGuide_Stride_pae5ml.jpg"
primary_image_credit = ""
related_articles = ["articles/aria-guides-parto-parto.md", "articles/aria-guides-una-voce-poco-fa.md", "articles/aria-guides-va-laisse-couler-mes-larmes.md"]
related_companies = []
related_people = []
short_description = "Azucena, the gypsy woman with an obvious PTSD situation over having accidentally thrown her own baby in a fire several years back. The crackling fire triggers the memory, and Azucena sings \"Stride la vampa\" (\"The flames roar\")."
slug = "aria-guides-stride-la-vampa"
title = "Aria guides: Stride la vampa"
youtube_url = ""

+++
Usually, music written in 3/8 time has a feeling of one-beat-to-the-bar, but in this aria, it's a bit murky **(1)**. There's certainly a feeling of one, but it's quite broad, almost like the beats are held back, like a dance that's a bit "off". And I think for a singer whose voice suits the role of Azucena, creating some space for all these dotted figures is wise. So, choose a tempo where you won't trip over the trills and dots, then find your big, swinging one-to-the-bar.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1629492741/media/2021/08/AriaGuide_Stride_p1_annotated_cropped_top_vgvhpy.jpg){{% /md %}}

</figure>

Part of these accents, like the one on "Urli" **(2)**, is to remind you to lighten up after the long note, so the dotted figures come out more clearly. While you lighten up, keep spinning the \[u\] vowel right through to the tied eighth note, otherwise you'll end up flat on the D on "-li". The same applies for "intorno" in the next phrase.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1629492751/media/2021/08/AriaGuide_Stride_p1_annotated_cropped_a8zg7h.jpg){{% /md %}}

</figure>

Really treat the "la" **(3)** as a pickup to "tetra", so your accented E's come out more dramatically. Use the crescendo/diminuendo that Verdi gives you on "fiamma", and imagine a tiny portamento from the E to the F. Work with your teacher on that double \[m\], it can be a tricky detail to include. Leading up to the trill on "ciel", plan where you're taking serious breaths, and where you're sipping. I'd advise only a sip before the second "che s'alza", so your serious breath is better for "al ciel". A note on trilling: see thy teacher.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1629492759/media/2021/08/AriaGuide_Stride_p2_annotated_cropped_top_pdf3ts.jpg){{% /md %}}

</figure>

Ideally, you've been conserving energy by coasting on this trill **(4)**, you're not giving too much too soon mid-crescendo. It's really in the last measure that you can warm back into a full sound - in fact, it's best to consider the crescendo as simply a move from light-enough-to-trill to your comfortable volume. Then, you can let rip for "che s'alza al ciel!" When you do breathe for "che", take a hair of extra time for a great-quality breath, and a bit of musical suspense.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1629492768/media/2021/08/AriaGuide_Stride_p2_annotated_cropped_itmvih.jpg){{% /md %}}

</figure>

We've skipped ahead a bit, trusting you mezzos to sing the second verse with excellent sound and great storytelling. Here **(5)**, where the text repeats, it's a spot to think about adding a few musical differences. Maybe you had an actual portamento in "fiamma", or maybe you show off with some extra volume in your high G. Doesn't have to be a full-blown cadenza - Azucena has a whole opera left to sing, after all - just some new pizzazz to avoid repetition.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1629492782/media/2021/08/AriaGuide_Stride_p3_annotated_full_a7d6xv.jpg){{% /md %}}

</figure>

Now, for some listening: I like Marilyn Horne's version of this aria, because it's just so textbook. You can hear Martin Katz all over this:

<figure data-type="video">{{% md %}}<iframe width="1010" height="758" src="https://www.youtube.com/embed/SDT4rct_n1A" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>{{% /md %}}

</figure>