+++
author = ["authors/jenna.md"]
categories = "How-To"
date = "2017-08-13T21:23:00-04:00"
lastmod = "2017-08-16T14:32:00-04:00"
postamble = "Readers, do you have an aria you'd like to see featured on one of our Aria Guides? Let us know in the comments below, or get in touch at [hello@schmopera.com](mailto:hello@schmopera.com)."
preamble = "It's a cornerstone of the operatic repertoire: Violetta's Act I aria from *La traviata*. It's got everything, from delicious long lines to flashy coloratura, and it has the special honour of closing the opera's first act. Violetta is a role that most sopranos covet, and many of them start their Traviata trip with \"Sempre libera\". Along with the work you do with your voice teachers and coaches, our latest Aria Guide a little navigation kit to help you along your way:"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1502727193169/2017-08-14---Libera.jpg.jpg"
publishDate = "2017-08-16T13:25:00-04:00"
related_articles = ["articles/aria-guides-quando-men-vo.md", "articles/aria-guides-come-paride-vezzoso.md", "articles/aria-guides-the-counts-aria.md"]
short_description = "It's a cornerstone of the operatic repertoire: Violetta's Act I aria from La traviata. It's got everything, from delicious long lines to flashy coloratura, and it has the special honour of closing the opera's first act. Violetta is a role that most sopranos covet, and many of them start their Traviata trip with \"Sempre libera\". Along with the work you do with your voice teachers and coaches, our latest Aria Guide a little naviagtion kit to help you along your way:"
slug = "aria-guides-sempre-libera"
title = "Aria guides: Sempre libera"

+++
 1. This opening is definitely easier in the context of the full opera; if you're doing the aria on its own, remember to keep it simple and speech-like. When you get to "In core scolpiti...", most conductors (and pianists) are happier if you sing the bar in a tempo, rather than as a free recitative.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1502673569866/Aria-guide---Violetta---annotated-1.jpg.jpg)
    {{% /md %}}</figure>
 2. It looks harmless, but many sopranos find intonation really tricky in this part. Be diligent with yourself, checking those small semitones in the G#-A-A# zone; it's an easy place to creep sharp.
 3. This is the first of a few outbursts in the recit, so you can absolutely have fun with "Oh gioja". Remember to approach the first two notes with enough room to stretch up to the B-flat; you can spend a bit of time up there, while you're at it. As you come down the scale, remind yourself of the open O vowel, and keep it refreshed as you descend.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1502673578862/Aria-guide---Violetta---annotated---2.jpg.jpg)
    {{% /md %}}</figure>
 4. This is another spot for intonation. In the spirit of drama, it's easy to go sharp by throwing away the E-flat on "poss'io", and being a bit sloppy on the "per l'aride". Stay on your voice, and remind yourself that your sound is a dramatic device on its own - no need to add extra expression (or tension).
 5. This is decidedly the "slow" section of this aria, but it's still only in 3/8 time; compared to 3/4, 3/8 has a bit more of a lilt to it, a feeling of 1 beat to the bar. Be careful not to set too slow a tempo for yourself, otherwise you'll lose the line (and your listeners). When you have the detached pattern on "Ah fors'è..." and "godea so-", practice it legato a few times, so your body gets used to spinning and vibrating, even on the shorter notes.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1502675031974/Aria-guide---Violetta---full-2.5.jpg.jpg)
    {{% /md %}}</figure>
 6. Make sure you're in tune for this bar; staying relaxed about it will keep you flexible enough to do what you want on the leap up in "tumulti". Speaking of that moment: there's a pretty strong tradition of adding a short fermata on the high A-flat. Finally, as you come down from the high note, into those low Gs and Fs, stay in a high position with your voice; with this aria - and this role, frankly - it's not worth tiring yourself by fighting hard for the low stuff.
 7. Verdi is starting something special here. In two-bar steps, he's getting you to sing higher and more fully, eventually taking you into the Alfredo theme at "A quell'amor..." A lot of that growth will happen naturally as your voice rises, but you'll still want to leave room for a healthy crescendo, and the cool effect of the _subito pianissimo_ he writes on "destandomi all'amor"; pay attention to where Verdi marks the beginning of that crescendo, to keep you from giving too much too soon.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1502673589692/Aria-guide---Violetta---annotated---3.jpg.jpg)
    {{% /md %}}</figure>
 8. Sing these two bars as quietly as you're comfortable doing, but not more than that; think of the crescendo on "amor" as terraced dynamics rather than a gradual volume increase, since it'll be easier for you to pace. It's common practice to move up to the F-natural at the end of "amor", and then grab a breath before starting "A quell'amor".
 9. There are a lot of opinions about what Verdi's markings mean here, these staccatos with a slur overtop. An easy way to show a change in articulation is to make more of the consonants in the text, and the word "misterioso" is a good one for that effect. When you sing "misterioso" the second time, remember that in the same breath, you're about to leap up to "croce"; you'll need lots of height and spin to make the trip feel easy.
10. Don't shy away from the consonants in "croce"; the K and rolled R sounds should help you propel things forward, as long as you keep your air spinning. Take care of the G-natural as well as the A; there's a bit of flexibility written into this bar, so you have time to really sing both notes of "croce".<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1502675043712/Aria-guide---Violetta---full-3.5.jpg.jpg)
    {{% /md %}}</figure>
11. There's a second verse to this section, but it's common in auditions and even in productions for Violetta to only sing the first verse. This is where many sopranos make a cut, going right into the coda of this slow section. The end of the cut is showed at #11 below:<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1502675055801/Aria-guide---Violetta--annotated---3.75.jpg.jpg)
    {{% /md %}}</figure>
12. Like with any cadenza, it's up to you to find some architecture to this wash of notes. There's a descending pattern highlighted with the high B-flat, then the G after that, then the E, etc. Even if you decide those are the anchor notes, spend time really showing us the funky intervals, like from the high B-flat to the D-sharp. The whole thing is more easily done - and more clearly heard - with a good, \[a\] vowel throughout, so make sure you're not closing it or dulling it into something closer to a schwa as you descend.
13. Before you start "Follie!", you should have the _allegro_ tempo in your head; there's certainly freedom for Violetta in her empty bars, but there should be a relationship between what you sing and how the orchestra responds.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1502673685407/Aria-guide---Violetta--annotated---4.jpg.jpg)
    {{% /md %}}</figure>
14. It's common for sopranos to come in a bit "early" on "Povera", so they can make more of a meal out of it before diving into the tempo at "donna". Make sure you're singing an E-natural instead of an E-flat; it's an easy note to let slip by without being careful.
15. Intonation police, once again. There's something a bit tongue-twister-like about the combination of pitches and text on "che spero or più?" Practice it slowly more times than you think you need to.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1502673710333/Aria-guide---Violetta--annotated---5.jpg.jpg)
    {{% /md %}}</figure>
16. Some sopranos breathe before "di voluttà" and before "ne'vortici", and some like to join the whole thing in one breath. No matter what you decide, know that the two bars are certainly connected in a musical sense. Make sure you don't start the "di voluttà" with too much force or weight; you want to be agile and light when you get to "vortici". After that, in all the jazz with the "gioirs", there are thousands of ways you can sing it; you'll always change it up, but the one constant is that it takes slow practice, good vowels, and time spent with your teachers and coaches.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1502673720273/Aria-guide---Violetta---annotated---6.jpg.jpg)
    {{% /md %}}</figure>
17. The challenge in this final section of the aria is to stay singing, tension-free, even though the music sounds energetic and even a bit hectic. When you have staccato markings, try and think of them being done with the vowels of the text, and not using the consonants to chew or grab the notes. A word like "sempre" is an easy trap to fall into, so remind yourself that your listeners need to hear those vowels, as much as we need to hear the letter M.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1502673733386/Aria-guide---Violetta---annotated---7.jpg.jpg)
    {{% /md %}}</figure>
18. This is a nasty little pairing of low and high singing; in less than 8 bars, Verdi has you covering two octaves at a fairly quick pace. However you sing the low C on "muoja", make sure you can easily come out of that low placement and get yourself set for the leap up to the high C on "ritrovi".<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1502673746816/Aria-guide---Violetta---annotated---8.jpg.jpg)
    {{% /md %}}</figure>
19. In case it makes your life easier, it's common practice for sopranos to condense the word "ritrovi" into the E-natural, and instead sing "ah" for the trilled G and the leap up to the high C.
20. Often conductors like to relax the tempo a bit here, and have fun with the accented notes. It means you have a bit of extra time to breathe, and find an elegant way of attacking the "dee volars". Be picky with your tuning as you creep down those semitones; they can be super sexy when they're done right.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1502673758010/Aria-guide---Violetta---annotated-8.5.jpg.jpg)
    {{% /md %}}</figure>
21. If you've pulled back the tempo at the "dee volar" section, it will pick back up as this bit of coloratura begins. This is definitely a spot to practice slowly; make sure your \[a\] vowel is working for you, and double check that you're in tune at the bottom of each little scale. When you get to the peak of the phrase, starting at that high D-flat, there's a strong tendency for it to go sharp, even up to an E-flat. Verdi stops the string doubling at this bar, which gives you a hair more flexibility of tempo, so you should use that time to be precise with your scales.
22. This (above) is another spot that's often cut; it's not done so often in productions, but it's definitely a common cut to include when you're singing the aria for auditions. The end of the cut is shown below, at #22:<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1502673773792/Aria-guide---Violetta---annotated-9.jpg.jpg)
    {{% /md %}}</figure>
23. Tough stuff, this bit. It's a good idea to practice it without the staccatos, and in reverse; you'll want to really find out how much height you need when you start on the low E-flats, so you don't get in trouble on your way up to the high A-flat. After the second scale up, you have those repeated A-flats; make sure that you don't default to breathing between each one, especially if you don't need the breath. A break or lift can help your rhythm, but try and find the longer line in all of these gymnastics.
24. It's common to hear sopranos add what sounds like a staccato note on the off beats (the first B-flat, the first A-flat, etc.); it may be common, but that articulation can make it harder to stay in tune. As you practice this bar slowly, pretend that the repeated notes are one longer note.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1502673798094/Aria-guide---Violetta---annotated-9.5.jpg.jpg)
    {{% /md %}}</figure>
25. This is probably one of the hardest bars in the aria, and it's really common to hear the pitches approximated. Verdi has really just written in a decorated version of a simpler tune. Try taking the first of each sixteenth-note pair (the C, A-natural, G, E-natural, C, and G) and give them eighth note values; this is the frame of the bar, and having it comfortably in your voice and ear will certainly make singing the rest of it easier.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1502673812897/Aria-guide---Violetta---annotated-10.jpg.jpg)
    {{% /md %}}</figure>
26. The second repetition of "il mio pensier" leading up to this moment are often tacet, to allow the soprano a moment of chill before the end; it's common to come back in at this high B-flat. In the final "il mio" bar, some sopranos opt to add a fermata so they can show off with a flashy high E-flat. It's exciting, no doubt, but it's a choice you get to make depending on how comfy you are singing that high, and whether or not you'd still have enough gas to sing the rest of the role. This is only Act I, after all...