+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2016-11-28T18:54:00+00:00"
lastmod = "2016-12-01T11:19:00+00:00"
preamble = "*Der Freischütz* is an action-packed story about girls, guns, and selling one's soul to the devil. Caspar is a man who owes his soul to the devil, and when he sings \"Schweig! damit dich Niemand warnt,\" he plans to substitute Max's soul instead of his own. This aria is difficult, even erratic, but it's mostly about finding the most energy-efficient way of singing. Caspar's aria is a schizophrenic rambling of a desperate man, and Weber's score is packed with traps that cost you breath and beauty of sound, and it's an aria that takes patience and time with your teachers and coaches.\n\nWe can offer some starting points, to help you pace yourself, avoid the traps, and keep breathing.\n\nPhoto: [Rob Albright](https://www.flickr.com/photos/8015956@N04/) via [Flickr.](https://creativecommons.org/licenses/by-nc/2.0/legalcode)"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1480367694994/2016-11-28---Gun.jpg.jpg"
publishDate = "2016-12-01T11:19:00+00:00"
related_articles = ["articles/aria-guides-aprite-un-po-quegli-occhi.md", "articles/aria-guides-deh-vieni-alla-finestra.md", "articles/aria-guides-come-paride-vezzoso.md", "articles/aria-guides-embroidery-aria.md"]
short_description = "Der Freischütz is an action-packed story about girls, guns, and selling one&#039;s soul to the devil. Caspar is a man who owes his soul to the devil, and when he sings &quot;Schweig! damit dich Niemand warnt,&quot; he plans to substitute Max&#039;s soul instead of his own. Caspar&#039;s aria is a schizophrenic rambling of a desperate man, and Weber&#039;s score is packed with traps that cost you breath and beauty of sound, and it&#039;s an aria that takes patience and time with your teachers and coaches."
slug = "aria-guides-schweig-damit-dich-niemand-warnt"
title = "Aria guides: \"Schweig! damit dich Niemand warnt\""

+++
 1. Make a meal out of the consonant cluster at the beginning of "Schweig!" For the first one, you can achieve the mood of a _piano_ dynamic by maximizing those consonants, without having to under-sing. For the _forte_ "Schweig!" right after, don't work too hard for it; let the pitch ring comfortably in your easiest sound, and let the dynamic contrast come simply from the upward leap of a major 6th. When you dive back down for "damit dich Niemand warnt," keep the sound placed forward, being true to the vowels in the text. The \[v\] sound in "warnt" is a great way of maintaining that placement as you move from the D in "Niemand" and the low A for "warnt".<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1480431980204/Aria-Guide---Schweig---annotated---1.5.jpg.jpg){{% /md %}}</figure>
 2. Imagine making sound on every letter of the word "Schweige". It's an easy, conversational range for a bass, so take care not to overthink it (or overdarken it). Resist the urge to sing the "-ei-" diphthong too soon; the long D should be 95% \[a\], and when you move to the second vowel, it's more of an \[e\] than an \[i\]. Lastly, try not to thump the second syllable of "Schweige".
 3. This section has more of a feeling of 2/2; keep that in mind as you learn all the jumpy eighth-note arpeggios, and make sure they're light, never driving. There's something about the way Weber writes this section that makes it easy to sit heavily on each the big beats (in 2/2); it's a spot where you have to pretend you're singing Verdi legato, and let the joltiness of the orchestral music do the percussive work.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1480431989736/Aria-Guide---Schweig---annotated---1.75.jpg.jpg)
    {{% /md %}}</figure>
 4. This is one of those spots where pacing is key; don't feel the need to start "nichts kann..." too loudly; it can feel a little _parlando_, and as you rise up the scale, pay attention to legato.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1480432004725/Aria-Guide---Schweig---annotated---2.jpg.jpg)
    {{% /md %}}</figure>
 5. This bit is picky, and it can tire you out if you work too hard to make it happen. The trick is lightness, but take care not to rush the process of learning all these notes; the light approach you'll eventually achieve has to come with clear intonation, and that comes largely from familiarizing your own ears with the tune. Twice, Weber asks you to pop up to a high D, on the first "tiefen" and the first "retten"; pay attention to how you sing those high Ds, and be aware if you start shouting, woofing, or reaching for them.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1480432240422/Aria-Guide---Schweig---annotated---3.jpg.jpg){{% /md %}}</figure>
 6. With these big, deliberate accents on "vom tiefen Fall," make sure that you create the effect with the vowel, not the initial consonants. At the same time, keep in mind the larger figure, which is four bars of rich, legato singing. Commit to each vowel for their full rhythmic value, and work to find seamless combinations of consonants; you can hum a smooth transition between "vom" and "tiefen", and you can send air through the end of "tiefen", into "Fall".<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1480432253375/Aria-Guide---Schweig---annotated---4.jpg.jpg){{% /md %}}</figure>
 7. The orchestral writing here can create another trap for sitting heavily on the big beats (in this case, twice per bar). Remind yourself that you're doing the opposite; you're singing a long phrase (at least four bars long), relaxing into this easy part of your voice, and showing us all those chromatic twists and turns.
 8. Again, don't get bogged down with each individual bar. The measure of "schon trägt er" should feel like a pick up to the "knirschend," and "eure" leads to "Ketten". Plus, have a look at the _crescendo_ and _diminuendo_: the dynamic peak happens two bars in, and it's a great guide to the shape of this four-bar phrase.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1480432263756/Aria-Guide---Schweig---annotated---5.jpg.jpg){{% /md %}}</figure>
 9. Don't underestimate the help that lies in the first syllable of "Triumph!" As you practice it slowly, use the brightness in the \[i\] vowel to show where to keep the resonance in the \[u\] vowel in the second syllable. It can help to cheat that pure \[u\] a bit, and sing something closer to \[ʊ\] (as in "book") or \[ɔ\] (as in the Italian "parola").
10. Find the legato in this syllabic section. For both of these short phrases, the descent down from the high D leads right to "gelingt". Get picky with yourself with the intonation of the first semitone down, on the C-sharp; the tendency is to let it go flat, so make sure you're maintaining your support.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1480432282827/Aria-Guide---Schweig---annotated---6.jpg.jpg){{% /md %}}</figure>
11. Be sure that you're not adding an extra accent on "Rache", but that's not to say you can't enjoy a great rolled R. It's more organic for the language, and easier on the voice, to channel Mozart in this section; be gentle with how you release "Rache," and think strong-weak, releasing the tension in the second syllable. Optional: see if you really need a breath between the two "die Raches"; you might find that your air is better used over a four-bar span.
12. The music gets riled up at this point, and it's easy to get excited and over-work. Be careful not to reach for the low As and Bs, and trust that singing clear text over a legato line will be enough. There's tough stuff coming up, and so take advantage of the opportunity to chill.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1480432295601/Aria-Guide---Schweig---annotated---7.jpg.jpg){{% /md %}}</figure>
13. The trick here is - you guessed it - staying light! Get yourself in a good, efficient spot with the bright vowels ("gelingt die...") at the start of this melisma, and pay attention to whether or not you can still roll the R in "Rache". If you can, it'll keep the \[a\] vowel from falling back while you're trying to stay agile. Most importantly, be careful not to follow the scale down with your throat; as you descend, maintain the height in your resonance so that the ascent back up isn't as difficult. This way, you'll use less air, and you'll be more audible.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1480432305356/Aria-Guide---Schweig---annotated---8.jpg.jpg){{% /md %}}</figure>
14. As you hover around these high Ds in all the "Triumphs", give yourself a head start with the eighth-note pick-up. Come in a bit early, and allow yourself the time to really sing the "Tri-" each time. The same applies for the two grace notes into "die Rache"; don't fall into the trap of the bass who can't sing fast notes.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1480432366039/Aria-Guide---Schweig---annotated---9.jpg.jpg){{% /md %}}</figure>
15. Each time you come out of a _fermata_, be sure that you start again right _a tempo_. Even at this brisk tempo, try to find room to sing in the tiny sixteenth note of "gelingt", almost adding a _tenuto_. With an orchestra, this practice can also help your ensemble.

***

For the big picture, check out bass Byeong Min Gil's basically-perfect performance of Caspar's aria from _Der Freischütz_ at the Korea National Opera Competition:

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/V8zrjhEXQZA" frameborder="0" allowfullscreen></iframe>
</figure>