+++
author = ["authors/jenna.md"]
categories = "How-To"
date = "2016-05-10T17:20:00-04:00"
lastmod = "2017-05-15T16:29:00-04:00"
postamble = "Do you have a request for our Aria Guides series? Get in touch at [hello@schmopera.com](mailto:hello@schmopera.com)."
preamble = "Sesto's Act I aria from *La clemenza di Tito* is somewhat of an Olympian feat for mezzo-sopranos. Packed into about 5 minutes, the aria has it all: a big, wide range, sustained lyric singing, and some intimidating coloratura saved for the end. The latest in our series of [Aria Guides](http://www.schmopera.com/search-results/?q=aria%20guides&page=1) is dedicated to easing the learning curve for all aspiring Sestos, a supportive start to go with your invaluable time spent with your teachers and coaches."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1553365917/media/2019/03/sqParto.jpg"
publishDate = "2016-05-11T06:30:00-04:00"
related_articles = ["articles/aria-guides-va-laisse-couler-mes-larmes.md", "articles/aria-guides-didos-lament.md", "articles/aria-guides-the-composers-aria.md"]
short_description = "Sesto's Act I aria from La clemenza di Tito is somewhat of an Olympian feat for mezzo-sopranos. Packed into about 5 minutes, the aria has it all: a big, wide range, sustained lyric singing, and some intimidating coloratura saved for the end. The latest in our series of Aria Guides is dedicated to easing the learning curve for all aspiring Sestos, a supportive start to go with your invaluable time spent with your teachers and coaches."
slug = "aria-guides-parto-parto"
title = "Aria guides: Parto, parto"

+++
 1. These initial "partos" can seem very significant, with all the regality and noble silence leading up to them. Mezzos, you can keep these short phrases simple, almost like a brief chance to test the waters as you get into this aria; the first two bars you sing can be treated like an extended pick-up beat to the "ma tu" to come. Be sure that the word "parto" keeps its natural inflection, meaning that the "-to" syllable should be lighter and shorter (yes, Mozart wrote two quarter notes, but like any good composer, rhythm is always contextualized by the natural pulse of the language).<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1462959781465/Aria-Guide---Parto---annotated-1-1.jpg.jpg)
    {{% /md %}}</figure>
 2. Resist the urge to slow down in this bar; stretching for dramatic effect is different than slowing down, and the affects are different, too. For that octave leap between "ben mio", you can clear away the N in "ben", since it will get naturally elided into the M of "mio" (\[bɛmm'io\]). You can make the octave even easier by really committing to singing the high F for its full value. Anticipating the leap downward will close off the sound you make up top, which doesn't make anything easier.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1462959827636/Aria-Guide---Parto---annotated-1-2.jpg.jpg)
    {{% /md %}}</figure>
 3. Get a head start on the rolled R in "ritorna", by taking time out of the end of the word "meco". It will help "meco" sound the way it should (with the stress on the first syllable), and rolling the R will keep you singing horizontally (read: legato). Be really picky about the intonation of the G in the middle of the first "pace", and let it get a vibration or two.
 4. Enjoy these eighth note pick-ups! You can almost think of coming in a bit early, creating a really nice dovetail with the end of the clarinet's solo (seen in the piano's right hand). On the dotted quarters, let your voice spin through that dot, and feel the tension as you stretch that long note over the second beat of the bar.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1462914985675/Aria-Guide---Parto---annotated-2.jpg.jpg)
    {{% /md %}}</figure>
 5. Another exposed entrance, care of Herr Mozart. Mezzos, imagine that instead of dropping from F to C, you stay on that high F. We're not saying the notes should be changed, but the way this is written makes it easy to thump on the "-to", and on that lower pitch; rise above! In the next two bars, make a point of singing "ma tu, ben" as one long pick-up to "mio".<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1462915004296/Aria-Guide---Parto---annotated-3.jpg.jpg)
    {{% /md %}}</figure>
 6. In both of these descending phrases, the semitone between the F and E-natural should be super teeny tiny. In the practice room, stop on that E-natural and double check it's high enough.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1462960370261/Aria-Guide---Parto---annotated-4-1.jpg.jpg)
    {{% /md %}}</figure>
 7. There's a change in key, and a change in mood here; mezzos, you have the opportunity to build some suspense by adding an "imaginary" fermata onto the rest before you come in again on "sarò". If you do, know what that pause means. The last piece of the puzzle is to really sing the "sa-" pick-up note; it should vibrate and spin, making the E-flat that comes next even more of a surprise.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1462960423701/Aria-Guide---Parto---annotated-4-2.jpg.jpg)
    {{% /md %}}</figure>
 8. As harmless as it looks, this dotted note on "quel" should really do something; there should be something that happens in the dot that forces Sesto to move up from the D to the F. The line he's saying is "what you want, I'll do"; the way this is written, it should feel like he's saying "whatever you want in the _whole wide world of impossible demands_, I'll do it."
 9. These bars below are a combo of two of our previous naggings: the "check your tuning" bit, and the "rhythmic tension" chestnut. The pick-ups on "quel" involve that tricky E-natural, so check it on the way up as well as the way down. The long "che" notes, whether they're dotted or tied, should have a snap of tension that ricochets your voice into the rest of the phrase. That final one on the second line should feel a bit more rectangular (masculine, maybe), than the one before, to set up the new music to come.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1462915033074/Aria-Guide---Parto---annotated-5.jpg.jpg)
    {{% /md %}}</figure>
10. Big, fat notes here. Be careful not to anticipate the consonants; there's a rolled R to deal with in "guardami", and a double T in "tutto", but more than anything, we want to hear glorious vowels like a cannon. Be careful with "guardami", that the rolled R doesn't result in a funny slide between pitches.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1462960631870/Aria-Guide---Parto---annotated-6-1.jpg.jpg)
    {{% /md %}}</figure>
11. These ornaments can feel crowded, and the best way to keep them simple is to assign them a rhythm. Some singers sing triplet sixteenth notes, starting on the primary pitch (E-flat - F - E-flat, and C - D - C respectively); others prefer a grace-note effect, starting from above the primary pitch. It first depends on which you like best, and then things like tempo and conductor influence will come into play.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1462960664021/Aria-Guide---Parto---annotated-6-2.jpg.jpg)
    {{% /md %}}</figure>
12. It looks unassuming, but the little pick-up on "Di" should get your full voice. There's a tendency for these pitches to be a bit sharp, and that's often a symptom of holding the voice back, in anticipation of landing on "quello".
13. The half-note E-flats get the automatic effect of an accent, so mezzos don't have to too much extra work to make us hear it. More important is supported, focused voice on the notes below the E-flat; this is another spot where pitch can creep sharp, and the crux lies in paying attention to the whole step between the D in "qual" and the C in "più".<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1462915061201/Aria-Guide---Parto---annotated-7.jpg.jpg)
    {{% /md %}}</figure>
14. There's an opportunity for a cadenza at this fermata. It's up to you, the mezzo, and who your Sesto is at this moment. Keep in mind that you're in the middle of a sentence, so whatever embellishments you add should continue forward, rather than being their own, stand-alone kind of thing. For the isolated "Guardamis" after, it's a chance to stretch your acting chops. How much silence you leave, what kind of subtext you have, it's all up to you, and how you envision your current conversation with Vitellia. Of course, a director and conductor may lend their opinions, but if you have an organic, clear imagination of what happens in those silences, you can be convincing.
15. There's a fun thing you can do here at the end of this line, and that's to build in an accelerando into the new, faster music that immediately follows. It's something to co-ordinate with a pianist or a conductor, but it's a pretty exciting way of shifting gears.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1462958664529/Aria-Guide---Parto---annotated-8.jpg.jpg)
    {{% /md %}}</figure>
16. Take the opportunity to coast here, and keep it easy. Adrenaline is pumping, fatigue may begin to set in, but there's coloratura on the horizon, and this is some merciful writing on Mozart's part, allowing you to recharge and organize your breath.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1462915083751/Aria-Guide---Parto---annotated-9.jpg.jpg)
    {{% /md %}}</figure>
17. Look, mezzos, it's your favourite part! We've [offered tips in the past on mastering coloratura](/4-tips-for-when-there-are-too-many-notes/), and we're fans of the "see the forest for the trees" school of thought. The notes circled in red are your checkpoints for this long melisma, and it counts for a lot to be able to hear this slower tune, hidden among all the decoration. When you get up to those tricky high B-flats, try and imagine that it's the second one you're aiming for, instead of the first.
18. Mezzos, you're experts on your own chest voice, so be wise about how much mix you use for this low D to start "donaste". With the _fortepiano_ dynamic in the orchestra, it can be tempting to opt for volume and try some pure (or mostly pure) chest voce down here, but be sure that that choice won't set you up for difficulty when you inevitably rise back up again.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1462915106696/Aria-Guide---Parto---annotated---11.jpg.jpg)
    {{% /md %}}</figure>
19. Almost there! With these detached notes, give them each a vibration or two; straight-tone short notes at this point in the aria often sound like someone who is entirely out of breath. It's worth taking time in the practice room to try these bars out like the notes are sustained half-notes, without rests in between, just to find what that long line feels like.
20. Take your last breath of the aria right before the half notes start (anyone who gives you grief for breathing mid-word in this case is being a picky nuisance). You want full lungs and a triumphant final phrase to bring this sucker to a close. On the high G, cheat a bit and get there a bit early; if you're really connecting these final notes with legato, it's a thrilling effect.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1462915227334/Aria-Guide---Parto---annotated---12.jpg.jpg)
{{% /md %}}</figure>