+++
author = ["authors/jenna.md"]
categories = "How-To"
date = "2016-11-29T21:35:00+00:00"
lastmod = "2016-12-06T16:59:00+00:00"
preamble = "Amid captured loved ones and Turkish harems, there's a tenor in love. Belmonte is off to resuce his abducted fiancée, Konstanze, but not without telling us how she makes his heart beat faster. For any tenor, this aria is a mountain of work; there's tricky coloratura, lines which hover through the *passaggio*, and making it to the end takes planning and stamina. With your teachers and coaches, we can help you wade through the endless details in Mozart's score, and start to see the big picture behind all those notes."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1480797688538/2016-12-4---Fire.jpg.jpg"
publishDate = "2016-12-06T16:12:00+00:00"
related_articles = ["articles/aria-guides-dalla-sua-pace.md", "articles/aria-guides-una-furtiva-lagrima.md", "articles/aria-guides-un-aura-amorosa.md"]
short_description = "Amid captured loved ones and Turkish harems, there's a tenor in love. Belmonte is off to resuce his abducted fiancée, Konstanze, but not without telling us how she makes his heart beat faster. For any tenor, this aria is a mountain of work; there's tricky coloratura, lines which hover through the passaggio, and making it to the end takes planning and stamina."
slug = "aria-guides-o-wie-angstlich"
title = "Aria guides: O wie ängstlich, o wie feurig!"

+++
 1. This is a nice, straight-forward way of starting a beast of an aria. Take advantage of these two small phrases; they're chances for you to take a couple of easy breaths, and spend the air healthily. Don't be afraid to start at a comfortable volume; the important part is to safe some fire, as it were, for the bigger outburst at "o wie feurig".<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1480700040380/Aria-Guide---Belmonte---annotated---1.jpg.jpg) {{% /md %}}</figure>
 2. The goal is to eventually show the lifts throughout these phrases, but to do it without hyperventilating; under "klopft mein liebesvolles Herz," the word-painting is cute, so imagine Belmonte's little heartbeats happening in the lifts. So, as you learn this bit, practice it without the rests; as you do, pay attention to how the final notes of the mini-phrases feel - like the E-natural under "lie-" or the D-natural until "-vol-". When you put the rests back in and consider Mozart's style, you'll be asked to be gentle on those same notes; after practicing singing them long, it will be easier to sing them lightly yet still in tune.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1480700053741/Aria-Guide---Belmonte---annotated---2.jpg.jpg)
    {{% /md %}}</figure>
 3. The breath you take should be a bar and a half prior (shown at the end of the last example, before the last "klopft mein liebe-"). Be light and easy as you approach "-volles", to stay air-efficient; once you're at "voll", there are a few ways you can organize this melisma. A simple way is to find anchors in the long B-naturals, which start to speed up in the next bar. Keep in mind that "anchor" doesn't mean heavy, and you'll want to lighten up the tied notes in particular. Another option is to lean into the first of each group of moving notes; so, adding a bit of a _tenuto_ on the D-naturals, and later the high F-sharp under "-volles". This option can make staying in tempo a bit trickier, but it can make the singing feel a bit more organic.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1480700064947/Aria-Guide---Belmonte---annotated---3.jpg.jpg)
    {{% /md %}}</figure>
 4. This is one of our favourite lines in this aria; these two swells up and down are graceful-yet-funky. Keep in mind that each time, the scale begins on an upbeat; let the first four notes travel forward to the peak of the line, but be careful not to slacken on your way back down. At this tempo, you can't really afford to be wishy-washy about the notes; practice them really slowly, paying attention to how they resonate around your _passaggio_, particularly the second note of each pair. You really want to be able to show the different between that D-sharp in "des", and the D-natural in the next bar.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1480796909460/Aria-Guide---Belmonte---annotated---4.5.jpg.jpg){{% /md %}}</figure>
 5. You can take a cue from the similar section earlier (the little heartbeats at "klopft mein liebesvolles Herz"); the rests here should feel a part of a large, broad phrase, rather than punctuating short bursts. Let yourself be a bit blunt, vocally; between the colourful text and the tessitura, you can afford to sing with your weight more evenly-distributed, rather than worrying about tapering phrase endings. Don't miss the little detail under "schwanke," that it's set to eighth notes, not sixteenths.
 6. This section isn't necessarily tricky, but it requires some looking ahead. You're heading towards the high F-sharp on the third "Brust", so imagine that same height in your sound as you drop down an octave lower at the first "es hebt sich..."<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1480796932213/Aria-Guide---Belmonte---annotated---4.75.jpg.jpg)
    {{% /md %}}</figure>
 7. Let these three sixteenth notes lead you to "Lispeln". It doesn't look like much on the page, but the shift between "Ist das ihr Lispeln?" and "Es wird mir so bange!" is gigantic. There's sudden stillness, a drop in dynamic and huge power in the broad quarter-note pick-up for "Es"; enjoy that C-sharp appoggiatura on "wird".<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1481036084018/Aria-Guide---Belmonte---full---annotated---5.5.jpg.jpg){{% /md %}}</figure>
 8. Gesture and text are what matter in this meandering list of questions. Mozart is approximating the rhythm of German with his pattern of three sixteenth notes leading to a downbeat; without disrupting the pulse, find a flexible version of these sixteenth notes that really captures the ebbs and flows of speech. "Täuscht" should take a bit more attention than "die", for example.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1481036111331/Aria-Guide---Belmonte---annotated---5.75.jpg.jpg){{% /md %}}</figure>
 9. A lot of tenors like to be generous with that _fermata_, and they decide that it applies to both of these bars, making them into a cadenza of sorts. It's an exciting option, and as you experiment with decorations, don't forget to practice this last "war es ein Traum?" a few times _a tempo_ to remind yourself of the big picture.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1480700117966/Aria-Guide---Belmonte---annotated---6.jpg.jpg)
    {{% /md %}}</figure>
10. This text is a bit trickier to sing, compared to this section earlier in the aria. Use the time during the rests to get a head-start on the consonants in "ängstlich" and "feurig"; otherwise, you'll start to drag the tempo. We've seen versions of this aria where the text simply reads two lines of "klopft mein liebevolles Herz", like the first time (or it got lost in some musical cuts); it's not a detail to lose sleep over, but it's worth knowing when you look for a decent score.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1480700130441/Aria-Guide---Belmonte---annotated---7.jpg.jpg)
    {{% /md %}}</figure>
11. Hopefully, you can find a moment of rest in this section, where you can momentarily coast. Take out the dot in the arpeggio rhythm, and find out where each note spins; as you add in the correct rhythm, make sure you're singing a vowel (brief as it is) on the C-sharp in the middle of the arpeggio. If that vowel is unsupported, your rhythm will feel vague and the E-naturals will start to go flat.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1480700144323/Aria-Guide---Belmonte---annotated---8.jpg.jpg)
    {{% /md %}}</figure>
12. Nice conductors and pianists will leave a bit of room for you to sing this tricky ascent up to the high A. Use a vowels-only method to find out how the shape of this phrase resonates in for you; you can make it a bit easier on yourself by treating the high As as one long note, rather than two short ones. You can certainly experiment with colour as you repeat the line, just be sure that a _piano_ doesn't read as under-energized. Finally, don't underestimate the power in the way this aria ends. It looks understated, but there's actually something really manly and strong in the simple, square cadence for "-volles Herz!" Imagine that you've finished a big Verdi tenor aria, so that you don't give up singing too soon.

***

Here's one of our favourite recordings of this aria, by mister Fritz Wunderlich:

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/TcmXV7YAoCg" frameborder="0" allowfullscreen></iframe>
</figure>